package main

import (
	"ChainGrpcTest/log"
	"ChainGrpcTest/tool"
	"ChainGrpcTest/transaction"
)

var (
	SendTxAccountArr [][]string
)

func init() {
	var err error
	cfg, err = tool.ParseConfig("./config/app.json")
	if err != nil {
		log.Errorf("Parse config error:%s", err)
		return
	}
	cfg.StorageAccFileName += ".xlsx"
	cfg.GoRoutineCount = goRoutineCount
	cfg.SignCount = txCount / 100
	SendTxAccountArr = tool.ReadExcel(cfg.Count, cfg.StorageAccFileName)
}

func startTest() {
	log.Infof("Program start initAccCount：%d tranCount", cfg.Count)
	arr := transaction.SignedTxArr(SendTxAccountArr, cfg)
	if batchSign {
		if err := transaction.BatchSignHandler(arr, cfg); err != nil {
			log.Errorf("Bath Send Tran error: %s", err)
			return
		}
	}
	if batchRecover {
		if err := transaction.BatchRecoverHandler(arr, cfg); err != nil {
			log.Errorf("Bath Send Tran error: %s", err)
			return
		}
	}
	if batchRecoverTx {
		if err := transaction.BatchRecoverTxHandler(arr, cfg); err != nil {
			log.Errorf("Bath Send Tran error: %s", err)
			return
		}
	}
	if batchVerify {
		if err := transaction.BatchVerifyHandler(arr, cfg); err != nil {
			log.Errorf("Bath Send Tran error: %s", err)
			return
		}
	}

}
