package xecc

import (
	. "github.com/CaduceusMetaverseProtocol/MetaCryptor/xecc/types"
)

func (x *Xecc) BatchSecp256k1RecoverPubkey(tasks []*XTaskSecp256k1RPubkey) ([]*XTaskSecp256k1RPubkey, error) {
	var eng Engine
	eng = x.cpue

	var tall = make([]XTask, len(tasks))
	for i := 0; i < len(tasks); i++ {
		tall[i] = tasks[i]
	}
	res, e := eng.ProcessBatch(tall)
	var xs = make([]*XTaskSecp256k1RPubkey, 0)
	for _, t := range res {
		xs = append(xs, t.(*XTaskSecp256k1RPubkey))
	}

	return xs, e
}

func (x *Xecc) BatchSecp256k1RecoverableSign(tasks []*XTaskSecp256k1RSign) ([]*XTaskSecp256k1RSign, error) {
	var eng Engine
	eng = x.cpue

	var tall = make([]XTask, len(tasks))
	for i := 0; i < len(tasks); i++ {
		tall[i] = tasks[i]
	}
	res, e := eng.ProcessBatch(tall)
	var xs = make([]*XTaskSecp256k1RSign, 0)
	for _, t := range res {
		xs = append(xs, t.(*XTaskSecp256k1RSign))
	}

	return xs, e
}

func (x *Xecc) BatchSecp256k1Sign(tasks []*XTaskSecp256k1Sign) ([]*XTaskSecp256k1Sign, error) {
	var eng Engine
	eng = x.cpue

	var tall = make([]XTask, len(tasks))
	for i := 0; i < len(tasks); i++ {
		tall[i] = tasks[i]
	}
	res, e := eng.ProcessBatch(tall)
	var xs = make([]*XTaskSecp256k1Sign, 0)
	for _, t := range res {
		xs = append(xs, t.(*XTaskSecp256k1Sign))
	}

	return xs, e
}

func (x *Xecc) BatchSecp256k1Verify(tasks []*XTaskSecp256k1Verify) ([]*XTaskSecp256k1Verify, error) {
	var eng Engine
	eng = x.cpue

	var tall = make([]XTask, len(tasks))
	for i := 0; i < len(tasks); i++ {
		tall[i] = tasks[i]
	}
	res, e := eng.ProcessBatch(tall)
	var xs = make([]*XTaskSecp256k1Verify, 0)
	for _, t := range res {
		xs = append(xs, t.(*XTaskSecp256k1Verify))
	}

	return xs, e
}

func (x *Xecc) BatchEcdsaSign(tasks []*XTaskEcdsa256Sign) ([]*XTaskEcdsa256Sign, error) {
	var eng Engine
	eng = x.cpue

	var tall = make([]XTask, len(tasks))
	for i := 0; i < len(tasks); i++ {
		tall[i] = tasks[i]
	}
	res, e := eng.ProcessBatch(tall)
	var xs = make([]*XTaskEcdsa256Sign, 0)
	for _, t := range res {
		xs = append(xs, t.(*XTaskEcdsa256Sign))
	}

	return xs, e
}

func (x *Xecc) BatchEcdsaVerify(tasks []*XTaskEcdsa256Verify) ([]*XTaskEcdsa256Verify, error) {
	var eng Engine
	eng = x.cpue

	var tall = make([]XTask, len(tasks))
	for i := 0; i < len(tasks); i++ {
		tall[i] = tasks[i]
	}
	res, e := eng.ProcessBatch(tall)
	var xs = make([]*XTaskEcdsa256Verify, 0)
	for _, t := range res {
		xs = append(xs, t.(*XTaskEcdsa256Verify))
	}

	return xs, e
}

func (x *Xecc) BatchSM2Sign(tasks []*XTaskSM2P256Sign) ([]*XTaskSM2P256Sign, error) {
	var eng Engine
	eng = x.cpue

	var tall = make([]XTask, len(tasks))
	for i := 0; i < len(tasks); i++ {
		tall[i] = tasks[i]
	}
	res, e := eng.ProcessBatch(tall)
	var xs = make([]*XTaskSM2P256Sign, 0)
	for _, t := range res {
		xs = append(xs, t.(*XTaskSM2P256Sign))
	}

	return xs, e
}

func (x *Xecc) BatchSM2Verify(tasks []*XTaskSM2P256Verify) ([]*XTaskSM2P256Verify, error) {
	var eng Engine
	eng = x.cpue

	var tall = make([]XTask, len(tasks))
	for i := 0; i < len(tasks); i++ {
		tall[i] = tasks[i]
	}
	res, e := eng.ProcessBatch(tall)
	var xs = make([]*XTaskSM2P256Verify, 0)
	for _, t := range res {
		xs = append(xs, t.(*XTaskSM2P256Verify))
	}

	return xs, e
}
