package types

func SafeWriteXTask(ch chan XTask, task XTask) error {
	var err error
	defer func() {
		if r := recover(); r != nil {
			// use closed channel
			err = ErrChanClosed
		}
	}()
	select {
	case ch <- task:
		err = nil
	default:
		err = ErrChanIsFull
	}
	return err
}

func SafeWriteXTaskWithReport(ch chan *TaskWithReport, task *TaskWithReport) error {
	var err error
	defer func() {
		if r := recover(); r != nil {
			// use closed channel
			err = ErrChanClosed
		}
	}()
	select {
	case ch <- task:
		err = nil
	default:
		err = ErrChanIsFull
	}
	return err
}
