package test

import (
	"context"
	"crypto/ecdsa"
	ringv1 "github.com/CaduceusMetaverseProtocol/MetaProtocol/gen/proto/go/ring/v1"
	metatypes "github.com/CaduceusMetaverseProtocol/MetaTypes/types"
	"github.com/ethereum/go-ethereum/crypto"
	"google.golang.org/grpc"
	"net"
	"strings"
	"testing"
	"time"
)

func TestNonce(t *testing.T) {

	local, _ := crypto.HexToECDSA("FD5CC6F5E7E2805E920AC5DC83D5AF1106F9C92F0C04F9D5E1FD4261B4B4464A")
	publicKey := local.Public()
	publicKeyECDSA, _ := publicKey.(*ecdsa.PublicKey)
	fromAddr := crypto.PubkeyToAddress(*publicKeyECDSA)

	c := StartGRPCClient("54.168.125.67:8545")

	ctx, cancel := context.WithTimeout(context.Background(), time.Second*8)
	defer cancel()

	nonce, err := c.Nonce(ctx, &ringv1.NonceRequest{Address: (*metatypes.Address)(fromAddr.Bytes())})

	if err != nil {
		t.Fatal(err)
	}
	t.Logf("nonce:  %v \n", nonce.Nonce)

}

func StartGRPCClient(protoAddr string) ringv1.RingServiceClient {
	//nolint:staticcheck // SA1019 Existing use of deprecated but supported dial option.
	conn, err := grpc.Dial(protoAddr, grpc.WithInsecure(), grpc.WithContextDialer(dialerFunc))
	if err != nil {
		panic(err)
	}

	return ringv1.NewRingServiceClient(conn)
}

func dialerFunc(ctx context.Context, addr string) (net.Conn, error) {
	return Connect(addr)
}
func Connect(protoAddr string) (net.Conn, error) {
	proto, address := ProtocolAndAddress(protoAddr)
	conn, err := net.Dial(proto, address)
	return conn, err
}

func ProtocolAndAddress(listenAddr string) (string, string) {
	protocol, address := "tcp", listenAddr
	parts := strings.SplitN(address, "://", 2)
	if len(parts) == 2 {
		protocol, address = parts[0], parts[1]
	}
	return protocol, address
}
