package xecc

import (
	. "github.com/CaduceusMetaverseProtocol/MetaCryptor/xecc/types"
)

type Session struct {
	xecc    *Xecc
	result  chan XTask
	closeCh chan struct{}
}

func (s *Session) AddTask(task XTask) error {
	ts := MakeTaskWithReport(task, s.result)
	return s.xecc.addTask(ts)
}

func (s *Session) GetResult() chan XTask {
	return s.result
}

func (s *Session) closed() bool {
	select {
	case _, ok := <-s.closeCh:
		if !ok {
			return true
		}
	default:
		return false
	}
	return false
}

// Close called by user.
func (s *Session) Close() {
	if !s.closed() {
		close(s.closeCh)
	}
}
