package xecc

import (
	"github.com/CaduceusMetaverseProtocol/MetaCryptor/xecc/engine/cpu"
	"github.com/CaduceusMetaverseProtocol/MetaCryptor/xecc/types"
	"sync"
)

var (
	xeccHandle = &Xecc{}
)

type Xecc struct {
	cpue  types.Engine

	wg       sync.WaitGroup
	mux      sync.Mutex
	close    chan struct{}
	initOnce sync.Once
}

func XeccInstance() *Xecc {
	xeccHandle.mux.Lock()
	defer xeccHandle.mux.Unlock()

	xeccHandle.initOnce.Do(func() {
		xeccHandle.cpue = cpu.GetInstance()
		xeccHandle.close = make(chan struct{})
	})
	return xeccHandle
}

func (x *Xecc) Secp256k1RecoverPubkey(msg []byte, sig []byte) ([]byte, error) {
	return cpu.GetInstance().Secp256k1RecoverPubkey(msg, sig)
}

func (x *Xecc) Secp256k1RecoverableSign(msg []byte, key []byte) ([]byte, error) {
	return cpu.GetInstance().Secp256k1RecoverableSign(msg, key)
}

func (x *Xecc) Secp256k1Sign(msg []byte, key []byte) ([]byte, error) {
	return cpu.GetInstance().Secp256k1Sign(msg, key)
}

func (x *Xecc) Secp256k1Verify(msg []byte, sign []byte, pubkey []byte) (bool, error) {
	return cpu.GetInstance().Secp256k1Verify(msg, sign, pubkey)
}
func (x *Xecc) EcdsaSign(msg []byte, key []byte) ([]byte, error) {
	return cpu.GetInstance().EcdsaSign(msg, key)
}
func (x *Xecc) EcdsaVerify(msg []byte, sign []byte, pubkey []byte) (bool, error) {
	return cpu.GetInstance().EcdsaVerify(msg, sign, pubkey)
}

func (x *Xecc) SM2Sign(msg []byte, key []byte) ([]byte, error) {
	return cpu.GetInstance().SM2Sign(msg, key)
}

func (x *Xecc) SM2Verify(msg []byte, sign []byte, pubkey []byte) (bool, error) {
	return cpu.GetInstance().SM2Verify(msg, sign, pubkey)
}

func (x *Xecc) Process(task types.XTask) (types.XTask, error) {
	return x.cpue.Process(task)
}

func (x *Xecc) AsyncSession() *Session {
	s := &Session{
		xecc:    x,
		result:  make(chan types.XTask, 100000),
		closeCh: make(chan struct{}),
	}
	return s
}

func (x *Xecc) addTask(tws *types.TaskWithReport) error {
	return x.cpue.ProcessA(tws)
}
