package tool

import (
	"ChainGrpcTest/log"
	"bufio"
	"encoding/json"
	"os"
)

type Config struct {
	ReceiveAddr           string `json:"receiveAddr"`
	Count                 int    `json:"count"`
	SignCount             int    `json:"signCount"`
	BatchCount            int    `json:"batchCount"`
	GoRoutineCount        int    `json:"goRoutineCount"`
	Type                  int    `json:"type"`
	RpcNode               string `json:"rpcNode"`
	Amount                int64  `json:"amount"`
	ChainId               int64  `json:"chainId"`
	InitAccountPrv        string `json:"initAccountPrv"`
	BatchTransferContract string `json:"batchTransferContract"`
	SleepTime             int    `json:"sleepTime"`
	StorageAccFileName    string `json:"storageAccFileName"`
}

var _cfg *Config = nil

func ParseConfig(path string) (*Config, error) {
	file, err := os.Open(path)
	if err != nil {
		panic(err)
	}
	defer func(file *os.File) {
		err := file.Close()
		if err != nil {
			log.Error("read file close failed:", err)
		}
	}(file)
	reader := bufio.NewReader(file)
	decoder := json.NewDecoder(reader)
	if err := decoder.Decode(&_cfg); err != nil {
		return nil, err
	}
	return _cfg, nil
}
