package transaction

import (
	"ChainGrpcTest/log"
	"ChainGrpcTest/tool"
	"context"
	v1 "github.com/CaduceusMetaverseProtocol/MetaProtocol/gen/proto/go/base/v1"
	ring "github.com/CaduceusMetaverseProtocol/MetaProtocol/gen/proto/go/ring/v1"
	metatypes "github.com/CaduceusMetaverseProtocol/MetaTypes/types"
	"github.com/ethereum/go-ethereum/core/types"
	"google.golang.org/grpc"
	"google.golang.org/grpc/credentials/insecure"
	"sync/atomic"
	"time"
)

var (
	bathHandleSendCount, allSignedTxCount, totalSendTime, beforeBathHandleSendCount int64
	broadcastEthTxWithFromRequestsArr                                               chan *ring.BroadcastLegacyEthTxsWithFromRequest
)

func init() {
	broadcastEthTxWithFromRequestsArr = make(chan *ring.BroadcastLegacyEthTxsWithFromRequest, 1000000)
}

func InitBroadcastTxGoroutine(cfg *tool.Config) error {
	client, err := grpc.Dial(cfg.RpcNode, grpc.WithTransportCredentials(insecure.NewCredentials()))
	if err != nil {
		return err
	}
	ringServiceClient := ring.NewRingServiceClient(client)
	for i := 0; i < cfg.GoRoutineCount; i++ {
		go broadcastTx(cfg, ringServiceClient)
	}
	return nil
}

func BroadcastTxArr(tranArr []*TxFromTran, cfg *tool.Config) error {
	allSignedTxCount = int64(len(tranArr))
	log.Info("allSignedTxCount:", allSignedTxCount)
	//startTime := time.Now()
	ethTxArr := make([]*ring.BroadcastLegacyEthTxWithFromRequest, 0)
	for i := 0; i < int(allSignedTxCount); i++ {
		inner := constructionEthLegacyTx(tranArr[i].Tran)
		request := &ring.BroadcastLegacyEthTxWithFromRequest{
			From:     tranArr[i].From,
			LegacyTx: &inner,
		}
		ethTxArr = append(ethTxArr, request)
		if len(ethTxArr) == cfg.BatchCount {
			res := &ring.BroadcastLegacyEthTxsWithFromRequest{
				List: ethTxArr,
			}
			broadcastEthTxWithFromRequestsArr <- res
			ethTxArr = make([]*ring.BroadcastLegacyEthTxWithFromRequest, 0)
		}
	}
	//for {
	//	if bathHandleSendCount == allSignedTxCount {
	//		log.Info("beforeBathHandleSendCount:", beforeBathHandleSendCount)
	//		log.Infof("Send tran count: %d", bathHandleSendCount)
	//		log.Infof("Since time: %d ms", time.Since(startTime).Milliseconds())
	//		log.Infof("Send tran total time: %d ms", totalSendTime)
	//		bathHandleSendCount = 0
	//		break
	//	}
	//}
	return nil
}

// BatchSendTran 处理批量发送的签名交易
func broadcastTx(cfg *tool.Config, client ring.RingServiceClient) error {
	for {
		select {
		case broadcastEthTxWithFromRequests := <-broadcastEthTxWithFromRequestsArr:
			log.Info("broadcastEthTxWithFromRequestsArr len:", len(broadcastEthTxWithFromRequestsArr))
			sendTranStartTime := time.Now()
			ctx, cancel := context.WithTimeout(context.Background(), time.Second*30)
			defer cancel()
			atomic.AddInt64(&beforeBathHandleSendCount, int64(len(broadcastEthTxWithFromRequests.List)))
			_, err := client.BroadcastLegacyTxs(ctx, broadcastEthTxWithFromRequests)
			if err != nil {
				log.Error("BroadcastTxs Error:", err)
			}
			sinceTime := time.Since(sendTranStartTime).Milliseconds()
			atomic.AddInt64(&bathHandleSendCount, int64(cfg.BatchCount))
			atomic.AddInt64(&totalSendTime, sinceTime)
			log.Infof("Send transaction time: %d ms ", sinceTime)
		}
	}
}

func constructionEthLegacyTx(tran *types.Transaction) v1.EthLegacyTx {
	//v, r, s := tran.RawSignatureValues()
	toAddr := metatypes.BytesToAddress(tran.To().Bytes())
	nv := metatypes.NewBigInt(0)
	nv.SetString("236", 10)
	nr := metatypes.NewBigInt(0)
	nr.SetString("103540811401203670175009355687785215115755383244051477218884606498783205629384", 10)
	ns := metatypes.NewBigInt(0)
	ns.SetString("36344895504144551167108335919542572829921945163306838661809661076218798969327", 10)
	rawTx := v1.EthLegacyTx{
		Nonce:    tran.Nonce(),
		GasPrice: metatypes.NewBigInt(tran.GasPrice().Int64()),
		Gas:      tran.Gas(),
		To:       &toAddr,
		Value:    metatypes.NewBigInt(tran.Value().Int64()),
		Data:     tran.Data(),
		V:        nv,
		R:        nr,
		S:        ns,
	}
	return rawTx
}
