package cpu

import (
	"github.com/CaduceusMetaverseProtocol/MetaCryptor/crypto"
)

func (ce *CPUEngine) Secp256k1RecoverPubkey(msg []byte, sig []byte) ([]byte, error) {
	return crypto.RecoverPubkey(msg, sig)
}

func (ce *CPUEngine) Secp256k1RecoverableSign(msg []byte, key []byte) ([]byte, error) {
	return crypto.RecoverableSign(msg, key)
}

func (ce *CPUEngine) Secp256k1Sign(msg []byte, key []byte) ([]byte, error) {
	return crypto.Secp256k1Sign(msg, key)
}

func (ce *CPUEngine) Secp256k1Verify(msg []byte, sign []byte, pubkey []byte) (bool, error) {
	return crypto.Secp256k1Verify(msg, pubkey, sign)
}
func (ce *CPUEngine) EcdsaSign(msg []byte, key []byte) ([]byte, error) {
	return crypto.EcdsaP256Sign(msg, key)
}
func (ce *CPUEngine) EcdsaVerify(msg []byte, sign []byte, pubkey []byte) (bool, error) {
	return crypto.EcdsaP256Verify(msg, pubkey, sign)
}

func (ce *CPUEngine) SM2Sign(msg []byte, key []byte) ([]byte, error) {
	return crypto.SM2Sign(msg, key)
}

func (ce *CPUEngine) SM2Verify(msg []byte, sign []byte, pubkey []byte) (bool, error) {
	return crypto.SM2Verify(msg, pubkey, sign)
}
