const getContractFactory = require("./deploy");

async function main() {
  let constantContract = await getContractFactory("CloudConstant");

  let constantArr = [
    "creating",
    "created",
    "user",
    "password",
    "cluster",
    "global_id",
    "host",
    "name",
    "stage",
    "progress",
    "is_exists",
    "external_ip",
    "internal_ip",
    "external_ssh_port",
    "external_vnc_port",
    "internal_vnc_port",
    "internal_ssh_port",
    "status",
    "memory",
    "cpu_logic_units",
    "cpu_num",
    "cpu_model",
    "cpu_cores",
    "gpu_model",
    "gpu_num",
    "disk",
    "os",
    "bind_width",
    "nps_vnc_end_port",
    "nps_vnc_start_port",
    "nps_ssh_end_port",
    "nps_ssh_start_port",
    "signalling_port",
    "turn_port",
    "stun_port"
  ];

  for (let i = 1; i <= constantArr.length; i++) {
    let res = await constantContract.setConstMap(constantArr[i - 1], i);
    await res.wait();
    console.log("Add constant index:", i);
  }

  let EX_SSH_START_PORT = await constantContract.EX_SSH_PORT();
  console.log("external_ssh_port:", EX_SSH_START_PORT);
}

main().catch((error) => {
  console.error(error);
  process.exitCode = 1;
});