const getContractFactory = require("./deploy");

async function main() {
  let vmContract = await getContractFactory("CloudVm");
  let vmId = 104;
  // await GetVmInfo(vmContract, vmId);
  // await GetVmUser(vmContract, vmId);
  // await GetVmIds(vmContract, 0, 10);
  // await enableVm(vmContract, vmId);
  // await disableVm(vmContract, vmId);
  await getVmStatus(vmContract, vmId);
}


async function enableVm(vmContract, vmId) {
  let enableVm = await vmContract.enableVm(vmId);
  await enableVm.wait();
  console.log("enableVm", enableVm);
}


async function disableVm(vmContract, vmId) {
  let disableVm = await vmContract.disableVm(vmId);
  await disableVm.wait();
  console.log("disableVm", disableVm);
}


async function getVmStatus(vmContract, vmId) {
  let getVmStatus = await vmContract.getVmStatus(vmId);
  console.log("getVmStatus:", getVmStatus);
}



async function GetVmUser(vmContract, vmId) {
  let addRes = await vmContract.getVmUser(vmId);
  console.log("addRes", addRes);
}

async function GetVmIds(vmContract, start, count) {
  let getRes = await vmContract.getVmIds(start, count);
  console.log("getRes", getRes);
}

async function GetVmInfo(vmContract, vmId) {
  let getRes = await vmContract.getVmInfo(vmId);
  console.log("getRes", getRes);
}

main().catch((error) => {
  console.error(error);
  process.exitCode = 1;
});