const hre = require("hardhat");

let isDeploy = true;

let contractName = [
  "CloudConstant",
  // "CloudGateway",
  // "CloudScheduler",
  "CloudVm",
  "CloudVmCreate",
  // "CloudHost"
];

// let contractAddress = [
//   "0x511017c4A67e6f3DAb0158538d72568D74C5909C",
//   // "0x993C630B94E4FfC2e9Cd39F9B5D65cE8c0B5B425",
//   // "0x06425aa6a39E7eB09fC1E12C9653A1efA80ba46d",
//   "0x15A5aac5D5bc2B7D0389a1054701a6583169FB00",
//   "0xFAbE2869D0E0a13b6776C31bD78505Ed9c2FAbec",
//   // "0xF465eD8D34653Dc984d47c7Bb91890e7cDfCB297"
// ];


let contractAddress = [
  "0xA427EC72294E9A8fA652CD6649689e35F3632A21",
  // "0x993C630B94E4FfC2e9Cd39F9B5D65cE8c0B5B425",
  // "0x06425aa6a39E7eB09fC1E12C9653A1efA80ba46d",
  "0x94F0EaC13064181C94a8D25DCaf9FAD8C97e105F",
  "0x01AB479187FBcd228BF808C9c2B2c1D655029444",
  // "0xF465eD8D34653Dc984d47c7Bb91890e7cDfCB297"
];

async function deployConst() {

  let constContract = await hre.ethers.getContractFactory("CloudConstant");

  let constDeploy = await constContract.deploy();

  await constDeploy.deployed();

  console.log("deploy CloudConstant contract address:", constDeploy.address);

  return constDeploy.address;
}

async function deployOtherContract(constContract, contractName) {
  for (let i = 1; i < contractName.length; i++) {
    let name = contractName[i];
    let contract = await hre.ethers.getContractFactory(name);
    let deplyContract = await contract.deploy(constContract);
    await deplyContract.deployed();
    console.log("deploy " + name + " contract address ", deplyContract.address);
  }
}


async function getContractFactory(param) {
  for (let i = 0; i < contractName.length; i++) {
    let name = contractName[i];
    if (name == param) {
      let contract = await hre.ethers.getContractAt(param, contractAddress[i]);
      return contract;
    }
  }
}

async function main() {
  if (isDeploy) {
    // let constAddress = await deployConst();
    await deployOtherContract("0xA427EC72294E9A8fA652CD6649689e35F3632A21", contractName);
  }
}

async function getTranRes(txHash) {
  let txRes = await hre.ethers.provider.getTransaction(txHash);
  await txRes.wait();
  console.log("txRes:", txRes);
}

main().catch((error) => {
  console.error(error);
  process.exitCode = 1;
});

module.exports = getContractFactory