package coin

import (
	contractCoin "contract-case/contract_abi/coin_transfer/compile"
	"contract-case/log"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"math/big"
)

type ContractCoinTrade struct {
	ToAddr []common.Address
	Amount *big.Int
}

func (trade *ContractCoinTrade) TransferSignTx(tranOpts *bind.TransactOpts, coinTransfer *contractCoin.ChainCoinTransfer) (*types.Transaction, error) {
	transferTx, err := coinTransfer.Transfer(tranOpts, trade.ToAddr, trade.Amount)
	if err != nil {
		log.Errorf("TransferSignTx func transfer tx error: %s", err)
		return nil, err
	}
	log.Info("transferTx:", transferTx.Hash())
	return transferTx, nil
}
