// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package contractReadWrite

import (
	"errors"
	"math/big"
	"strings"

	ethereum "github.com/ethereum/go-ethereum"
	"github.com/ethereum/go-ethereum/accounts/abi"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/event"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = errors.New
	_ = big.NewInt
	_ = strings.NewReader
	_ = ethereum.NotFound
	_ = bind.Bind
	_ = common.Big1
	_ = types.BloomLookup
	_ = event.NewSubscription
)

// ReadWriteBlockMetaData contains all meta data concerning the ReadWriteBlock contract.
var ReadWriteBlockMetaData = &bind.MetaData{
	ABI: "[{\"inputs\":[],\"name\":\"getBlockHash\",\"outputs\":[{\"internalType\":\"bytes32\",\"name\":\"\",\"type\":\"bytes32\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"getBlockTimestamp\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"}]",
	Bin: "0x608060405234801561001057600080fd5b50610195806100206000396000f3fe608060405234801561001057600080fd5b50600436106100365760003560e01c8063796b89b91461003b5780639663f88f14610059575b600080fd5b610043610077565b60405161005091906100ad565b60405180910390f35b61006161007f565b60405161006e91906100e1565b60405180910390f35b600042905090565b600060014361008e919061012b565b40905090565b6000819050919050565b6100a781610094565b82525050565b60006020820190506100c2600083018461009e565b92915050565b6000819050919050565b6100db816100c8565b82525050565b60006020820190506100f660008301846100d2565b92915050565b7f4e487b7100000000000000000000000000000000000000000000000000000000600052601160045260246000fd5b600061013682610094565b915061014183610094565b9250828203905081811115610159576101586100fc565b5b9291505056fea2646970667358221220a0951f4041bca69095b3463492510bc63c1b3f06250358788f792cf88939f81864736f6c63430008130033",
}

// ReadWriteBlockABI is the input ABI used to generate the binding from.
// Deprecated: Use ReadWriteBlockMetaData.ABI instead.
var ReadWriteBlockABI = ReadWriteBlockMetaData.ABI

// ReadWriteBlockBin is the compiled bytecode used for deploying new contracts.
// Deprecated: Use ReadWriteBlockMetaData.Bin instead.
var ReadWriteBlockBin = ReadWriteBlockMetaData.Bin

// DeployReadWriteBlock deploys a new Ethereum contract, binding an instance of ReadWriteBlock to it.
func DeployReadWriteBlock(auth *bind.TransactOpts, backend bind.ContractBackend) (common.Address, *types.Transaction, *ReadWriteBlock, error) {
	parsed, err := ReadWriteBlockMetaData.GetAbi()
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	if parsed == nil {
		return common.Address{}, nil, nil, errors.New("GetABI returned nil")
	}

	address, tx, contract, err := bind.DeployContract(auth, *parsed, common.FromHex(ReadWriteBlockBin), backend)
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	return address, tx, &ReadWriteBlock{ReadWriteBlockCaller: ReadWriteBlockCaller{contract: contract}, ReadWriteBlockTransactor: ReadWriteBlockTransactor{contract: contract}, ReadWriteBlockFilterer: ReadWriteBlockFilterer{contract: contract}}, nil
}

// ReadWriteBlock is an auto generated Go binding around an Ethereum contract.
type ReadWriteBlock struct {
	ReadWriteBlockCaller     // Read-only binding to the contract
	ReadWriteBlockTransactor // Write-only binding to the contract
	ReadWriteBlockFilterer   // Log filterer for contract events
}

// ReadWriteBlockCaller is an auto generated read-only Go binding around an Ethereum contract.
type ReadWriteBlockCaller struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// ReadWriteBlockTransactor is an auto generated write-only Go binding around an Ethereum contract.
type ReadWriteBlockTransactor struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// ReadWriteBlockFilterer is an auto generated log filtering Go binding around an Ethereum contract events.
type ReadWriteBlockFilterer struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// ReadWriteBlockSession is an auto generated Go binding around an Ethereum contract,
// with pre-set call and transact options.
type ReadWriteBlockSession struct {
	Contract     *ReadWriteBlock   // Generic contract binding to set the session for
	CallOpts     bind.CallOpts     // Call options to use throughout this session
	TransactOpts bind.TransactOpts // Transaction auth options to use throughout this session
}

// ReadWriteBlockCallerSession is an auto generated read-only Go binding around an Ethereum contract,
// with pre-set call options.
type ReadWriteBlockCallerSession struct {
	Contract *ReadWriteBlockCaller // Generic contract caller binding to set the session for
	CallOpts bind.CallOpts         // Call options to use throughout this session
}

// ReadWriteBlockTransactorSession is an auto generated write-only Go binding around an Ethereum contract,
// with pre-set transact options.
type ReadWriteBlockTransactorSession struct {
	Contract     *ReadWriteBlockTransactor // Generic contract transactor binding to set the session for
	TransactOpts bind.TransactOpts         // Transaction auth options to use throughout this session
}

// ReadWriteBlockRaw is an auto generated low-level Go binding around an Ethereum contract.
type ReadWriteBlockRaw struct {
	Contract *ReadWriteBlock // Generic contract binding to access the raw methods on
}

// ReadWriteBlockCallerRaw is an auto generated low-level read-only Go binding around an Ethereum contract.
type ReadWriteBlockCallerRaw struct {
	Contract *ReadWriteBlockCaller // Generic read-only contract binding to access the raw methods on
}

// ReadWriteBlockTransactorRaw is an auto generated low-level write-only Go binding around an Ethereum contract.
type ReadWriteBlockTransactorRaw struct {
	Contract *ReadWriteBlockTransactor // Generic write-only contract binding to access the raw methods on
}

// NewReadWriteBlock creates a new instance of ReadWriteBlock, bound to a specific deployed contract.
func NewReadWriteBlock(address common.Address, backend bind.ContractBackend) (*ReadWriteBlock, error) {
	contract, err := bindReadWriteBlock(address, backend, backend, backend)
	if err != nil {
		return nil, err
	}
	return &ReadWriteBlock{ReadWriteBlockCaller: ReadWriteBlockCaller{contract: contract}, ReadWriteBlockTransactor: ReadWriteBlockTransactor{contract: contract}, ReadWriteBlockFilterer: ReadWriteBlockFilterer{contract: contract}}, nil
}

// NewReadWriteBlockCaller creates a new read-only instance of ReadWriteBlock, bound to a specific deployed contract.
func NewReadWriteBlockCaller(address common.Address, caller bind.ContractCaller) (*ReadWriteBlockCaller, error) {
	contract, err := bindReadWriteBlock(address, caller, nil, nil)
	if err != nil {
		return nil, err
	}
	return &ReadWriteBlockCaller{contract: contract}, nil
}

// NewReadWriteBlockTransactor creates a new write-only instance of ReadWriteBlock, bound to a specific deployed contract.
func NewReadWriteBlockTransactor(address common.Address, transactor bind.ContractTransactor) (*ReadWriteBlockTransactor, error) {
	contract, err := bindReadWriteBlock(address, nil, transactor, nil)
	if err != nil {
		return nil, err
	}
	return &ReadWriteBlockTransactor{contract: contract}, nil
}

// NewReadWriteBlockFilterer creates a new log filterer instance of ReadWriteBlock, bound to a specific deployed contract.
func NewReadWriteBlockFilterer(address common.Address, filterer bind.ContractFilterer) (*ReadWriteBlockFilterer, error) {
	contract, err := bindReadWriteBlock(address, nil, nil, filterer)
	if err != nil {
		return nil, err
	}
	return &ReadWriteBlockFilterer{contract: contract}, nil
}

// bindReadWriteBlock binds a generic wrapper to an already deployed contract.
func bindReadWriteBlock(address common.Address, caller bind.ContractCaller, transactor bind.ContractTransactor, filterer bind.ContractFilterer) (*bind.BoundContract, error) {
	parsed, err := abi.JSON(strings.NewReader(ReadWriteBlockABI))
	if err != nil {
		return nil, err
	}
	return bind.NewBoundContract(address, parsed, caller, transactor, filterer), nil
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_ReadWriteBlock *ReadWriteBlockRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _ReadWriteBlock.Contract.ReadWriteBlockCaller.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_ReadWriteBlock *ReadWriteBlockRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _ReadWriteBlock.Contract.ReadWriteBlockTransactor.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_ReadWriteBlock *ReadWriteBlockRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _ReadWriteBlock.Contract.ReadWriteBlockTransactor.contract.Transact(opts, method, params...)
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_ReadWriteBlock *ReadWriteBlockCallerRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _ReadWriteBlock.Contract.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_ReadWriteBlock *ReadWriteBlockTransactorRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _ReadWriteBlock.Contract.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_ReadWriteBlock *ReadWriteBlockTransactorRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _ReadWriteBlock.Contract.contract.Transact(opts, method, params...)
}

// GetBlockHash is a free data retrieval call binding the contract method 0x9663f88f.
//
// Solidity: function getBlockHash() view returns(bytes32)
func (_ReadWriteBlock *ReadWriteBlockCaller) GetBlockHash(opts *bind.CallOpts) ([32]byte, error) {
	var out []interface{}
	err := _ReadWriteBlock.contract.Call(opts, &out, "getBlockHash")

	if err != nil {
		return *new([32]byte), err
	}

	out0 := *abi.ConvertType(out[0], new([32]byte)).(*[32]byte)

	return out0, err

}

// GetBlockHash is a free data retrieval call binding the contract method 0x9663f88f.
//
// Solidity: function getBlockHash() view returns(bytes32)
func (_ReadWriteBlock *ReadWriteBlockSession) GetBlockHash() ([32]byte, error) {
	return _ReadWriteBlock.Contract.GetBlockHash(&_ReadWriteBlock.CallOpts)
}

// GetBlockHash is a free data retrieval call binding the contract method 0x9663f88f.
//
// Solidity: function getBlockHash() view returns(bytes32)
func (_ReadWriteBlock *ReadWriteBlockCallerSession) GetBlockHash() ([32]byte, error) {
	return _ReadWriteBlock.Contract.GetBlockHash(&_ReadWriteBlock.CallOpts)
}

// GetBlockTimestamp is a free data retrieval call binding the contract method 0x796b89b9.
//
// Solidity: function getBlockTimestamp() view returns(uint256)
func (_ReadWriteBlock *ReadWriteBlockCaller) GetBlockTimestamp(opts *bind.CallOpts) (*big.Int, error) {
	var out []interface{}
	err := _ReadWriteBlock.contract.Call(opts, &out, "getBlockTimestamp")

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// GetBlockTimestamp is a free data retrieval call binding the contract method 0x796b89b9.
//
// Solidity: function getBlockTimestamp() view returns(uint256)
func (_ReadWriteBlock *ReadWriteBlockSession) GetBlockTimestamp() (*big.Int, error) {
	return _ReadWriteBlock.Contract.GetBlockTimestamp(&_ReadWriteBlock.CallOpts)
}

// GetBlockTimestamp is a free data retrieval call binding the contract method 0x796b89b9.
//
// Solidity: function getBlockTimestamp() view returns(uint256)
func (_ReadWriteBlock *ReadWriteBlockCallerSession) GetBlockTimestamp() (*big.Int, error) {
	return _ReadWriteBlock.Contract.GetBlockTimestamp(&_ReadWriteBlock.CallOpts)
}
