package contractErc721

import (
	erc721 "contract-case/contract_abi/erc721_transfer/compile"
	"contract-case/log"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"math/big"
)

type OneErc721Trade struct {
	NftTokenTransferAddr common.Address
	Erc721Addr           common.Address
	FromAddr             common.Address
	ToAddr               common.Address
	TokenId              *big.Int
}

func (trade *OneErc721Trade) Erc721OneTransferFromSignTx(tranOpts *bind.TransactOpts, transfer *erc721.OneNftTokenTransfer) (*types.Transaction, error) {
	transferFromTx, err := transfer.OneTransferFrom(tranOpts, trade.NftTokenTransferAddr, trade.Erc721Addr, trade.FromAddr, trade.ToAddr, trade.TokenId)
	if err != nil {
		log.Errorf("Erc721OneTransferFromSignTx func OneTransferFrom tx error: %s", err)
		return nil, err
	}
	log.Info("transferFromTx:", transferFromTx.Hash())
	return transferFromTx, nil
}
