// SPDX-License-Identifier: MIT

pragma solidity ^0.8.9;
import "../../interface/IERC721.sol";
import "../../interface/IERC721Receiver.sol";

contract NftTokenTransfer is IERC721Receiver{

    function approveFrom(
        address tokenAddr,
        address from
    ) external {
        IERC721(tokenAddr).setApprovalForAllFrom(from,address(this),true);
    }

    function transferFrom(
        address tokenAddr,
        address from,
        address to,
        uint256 tokenId
    ) external {
        IERC721(tokenAddr).safeTransferFrom(from, to, tokenId);
    }

    function onERC721Received(
        address, address, uint256, bytes calldata
    ) public pure returns (bytes4) {
        return bytes4(keccak256("onERC721Received(address,address,uint256,bytes)"));
    }
}
