// SPDX-License-Identifier: MIT
pragma solidity ^0.8.9;

import "../../interface/ITokenTransfer.sol";

contract OneTokenTransfer {
    function oneTransfer(
        address tokenTransferAddr,
        address token,
        address[] memory toArr,
        uint256 amount
    ) external {
        ITokenTransfer(tokenTransferAddr).tokenTransfer(token, toArr, amount);
    }

    function oneTransferFrom(
        address tokenTransferAddr,
        address token,
        address from,
        address to,
        uint256 amount
    ) external {
        ITokenTransfer(tokenTransferAddr).tokenTransferFrom(
            token,
            from,
            to,
            amount
        );
    }
}
