// SPDX-License-Identifier: UNLICENSED
pragma solidity ^0.8.9;

import "../../interface/IERC20.sol";
import "../../library/SafeERC20Token.sol";

contract TokenTransfer {
    using SafeERC20Token for IERC20;

    function tokenTransfer(
        address token,
        address[] memory toArr,
        uint256 value
    ) external {
        for (uint i = 0; i < toArr.length; i++) {
            IERC20(token).safeTransfer(toArr[i], value);
        }
    }

    function tokenTransferFrom(
        address token,
        address from,
        address to,
        uint256 value
    ) external {
        IERC20(token).safeTransferFrom(from, to, value);
    }
}
