// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package contractReadWrite

import (
	"errors"
	"math/big"
	"strings"

	ethereum "github.com/ethereum/go-ethereum"
	"github.com/ethereum/go-ethereum/accounts/abi"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/event"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = errors.New
	_ = big.NewInt
	_ = strings.NewReader
	_ = ethereum.NotFound
	_ = bind.Bind
	_ = common.Big1
	_ = types.BloomLookup
	_ = event.NewSubscription
)

// ReadWriteVarMetaData contains all meta data concerning the ReadWriteVar contract.
var ReadWriteVarMetaData = &bind.MetaData{
	ABI: "[{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"key\",\"type\":\"uint256\"}],\"name\":\"getVarMap\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"key\",\"type\":\"uint256\"}],\"name\":\"getVarMapArray\",\"outputs\":[{\"internalType\":\"uint256[]\",\"name\":\"\",\"type\":\"uint256[]\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"getVarString\",\"outputs\":[{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"getVarStringArray\",\"outputs\":[{\"internalType\":\"string[]\",\"name\":\"\",\"type\":\"string[]\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"getVarUint256\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"getVarUintArray\",\"outputs\":[{\"internalType\":\"uint256[]\",\"name\":\"\",\"type\":\"uint256[]\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"key\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"value\",\"type\":\"uint256\"}],\"name\":\"pushVarMapArray\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"string\",\"name\":\"value\",\"type\":\"string\"}],\"name\":\"pushVarStringArray\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"value\",\"type\":\"uint256\"}],\"name\":\"pushVarUintArray\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"key\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"value\",\"type\":\"uint256\"}],\"name\":\"setVarMap\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"key\",\"type\":\"uint256\"},{\"internalType\":\"uint256[]\",\"name\":\"valueArr\",\"type\":\"uint256[]\"}],\"name\":\"setVarMapArray\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"string\",\"name\":\"value\",\"type\":\"string\"}],\"name\":\"setVarString\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"string[]\",\"name\":\"value\",\"type\":\"string[]\"}],\"name\":\"setVarStringArray\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"value\",\"type\":\"uint256\"}],\"name\":\"setVarUint256\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256[]\",\"name\":\"value\",\"type\":\"uint256[]\"}],\"name\":\"setVarUintArray\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"name\":\"varMap\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"name\":\"varMapArray\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"varString\",\"outputs\":[{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"name\":\"varStringArray\",\"outputs\":[{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"varUint256\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"name\":\"varUintArray\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"}]",
	Bin: "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",
}

// ReadWriteVarABI is the input ABI used to generate the binding from.
// Deprecated: Use ReadWriteVarMetaData.ABI instead.
var ReadWriteVarABI = ReadWriteVarMetaData.ABI

// ReadWriteVarBin is the compiled bytecode used for deploying new contracts.
// Deprecated: Use ReadWriteVarMetaData.Bin instead.
var ReadWriteVarBin = ReadWriteVarMetaData.Bin

// DeployReadWriteVar deploys a new Ethereum contract, binding an instance of ReadWriteVar to it.
func DeployReadWriteVar(auth *bind.TransactOpts, backend bind.ContractBackend) (common.Address, *types.Transaction, *ReadWriteVar, error) {
	parsed, err := ReadWriteVarMetaData.GetAbi()
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	if parsed == nil {
		return common.Address{}, nil, nil, errors.New("GetABI returned nil")
	}

	address, tx, contract, err := bind.DeployContract(auth, *parsed, common.FromHex(ReadWriteVarBin), backend)
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	return address, tx, &ReadWriteVar{ReadWriteVarCaller: ReadWriteVarCaller{contract: contract}, ReadWriteVarTransactor: ReadWriteVarTransactor{contract: contract}, ReadWriteVarFilterer: ReadWriteVarFilterer{contract: contract}}, nil
}

// ReadWriteVar is an auto generated Go binding around an Ethereum contract.
type ReadWriteVar struct {
	ReadWriteVarCaller     // Read-only binding to the contract
	ReadWriteVarTransactor // Write-only binding to the contract
	ReadWriteVarFilterer   // Log filterer for contract events
}

// ReadWriteVarCaller is an auto generated read-only Go binding around an Ethereum contract.
type ReadWriteVarCaller struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// ReadWriteVarTransactor is an auto generated write-only Go binding around an Ethereum contract.
type ReadWriteVarTransactor struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// ReadWriteVarFilterer is an auto generated log filtering Go binding around an Ethereum contract events.
type ReadWriteVarFilterer struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// ReadWriteVarSession is an auto generated Go binding around an Ethereum contract,
// with pre-set call and transact options.
type ReadWriteVarSession struct {
	Contract     *ReadWriteVar     // Generic contract binding to set the session for
	CallOpts     bind.CallOpts     // Call options to use throughout this session
	TransactOpts bind.TransactOpts // Transaction auth options to use throughout this session
}

// ReadWriteVarCallerSession is an auto generated read-only Go binding around an Ethereum contract,
// with pre-set call options.
type ReadWriteVarCallerSession struct {
	Contract *ReadWriteVarCaller // Generic contract caller binding to set the session for
	CallOpts bind.CallOpts       // Call options to use throughout this session
}

// ReadWriteVarTransactorSession is an auto generated write-only Go binding around an Ethereum contract,
// with pre-set transact options.
type ReadWriteVarTransactorSession struct {
	Contract     *ReadWriteVarTransactor // Generic contract transactor binding to set the session for
	TransactOpts bind.TransactOpts       // Transaction auth options to use throughout this session
}

// ReadWriteVarRaw is an auto generated low-level Go binding around an Ethereum contract.
type ReadWriteVarRaw struct {
	Contract *ReadWriteVar // Generic contract binding to access the raw methods on
}

// ReadWriteVarCallerRaw is an auto generated low-level read-only Go binding around an Ethereum contract.
type ReadWriteVarCallerRaw struct {
	Contract *ReadWriteVarCaller // Generic read-only contract binding to access the raw methods on
}

// ReadWriteVarTransactorRaw is an auto generated low-level write-only Go binding around an Ethereum contract.
type ReadWriteVarTransactorRaw struct {
	Contract *ReadWriteVarTransactor // Generic write-only contract binding to access the raw methods on
}

// NewReadWriteVar creates a new instance of ReadWriteVar, bound to a specific deployed contract.
func NewReadWriteVar(address common.Address, backend bind.ContractBackend) (*ReadWriteVar, error) {
	contract, err := bindReadWriteVar(address, backend, backend, backend)
	if err != nil {
		return nil, err
	}
	return &ReadWriteVar{ReadWriteVarCaller: ReadWriteVarCaller{contract: contract}, ReadWriteVarTransactor: ReadWriteVarTransactor{contract: contract}, ReadWriteVarFilterer: ReadWriteVarFilterer{contract: contract}}, nil
}

// NewReadWriteVarCaller creates a new read-only instance of ReadWriteVar, bound to a specific deployed contract.
func NewReadWriteVarCaller(address common.Address, caller bind.ContractCaller) (*ReadWriteVarCaller, error) {
	contract, err := bindReadWriteVar(address, caller, nil, nil)
	if err != nil {
		return nil, err
	}
	return &ReadWriteVarCaller{contract: contract}, nil
}

// NewReadWriteVarTransactor creates a new write-only instance of ReadWriteVar, bound to a specific deployed contract.
func NewReadWriteVarTransactor(address common.Address, transactor bind.ContractTransactor) (*ReadWriteVarTransactor, error) {
	contract, err := bindReadWriteVar(address, nil, transactor, nil)
	if err != nil {
		return nil, err
	}
	return &ReadWriteVarTransactor{contract: contract}, nil
}

// NewReadWriteVarFilterer creates a new log filterer instance of ReadWriteVar, bound to a specific deployed contract.
func NewReadWriteVarFilterer(address common.Address, filterer bind.ContractFilterer) (*ReadWriteVarFilterer, error) {
	contract, err := bindReadWriteVar(address, nil, nil, filterer)
	if err != nil {
		return nil, err
	}
	return &ReadWriteVarFilterer{contract: contract}, nil
}

// bindReadWriteVar binds a generic wrapper to an already deployed contract.
func bindReadWriteVar(address common.Address, caller bind.ContractCaller, transactor bind.ContractTransactor, filterer bind.ContractFilterer) (*bind.BoundContract, error) {
	parsed, err := abi.JSON(strings.NewReader(ReadWriteVarABI))
	if err != nil {
		return nil, err
	}
	return bind.NewBoundContract(address, parsed, caller, transactor, filterer), nil
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_ReadWriteVar *ReadWriteVarRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _ReadWriteVar.Contract.ReadWriteVarCaller.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_ReadWriteVar *ReadWriteVarRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.ReadWriteVarTransactor.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_ReadWriteVar *ReadWriteVarRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.ReadWriteVarTransactor.contract.Transact(opts, method, params...)
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_ReadWriteVar *ReadWriteVarCallerRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _ReadWriteVar.Contract.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_ReadWriteVar *ReadWriteVarTransactorRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_ReadWriteVar *ReadWriteVarTransactorRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.contract.Transact(opts, method, params...)
}

// GetVarMap is a free data retrieval call binding the contract method 0x68c7187b.
//
// Solidity: function getVarMap(uint256 key) view returns(uint256)
func (_ReadWriteVar *ReadWriteVarCaller) GetVarMap(opts *bind.CallOpts, key *big.Int) (*big.Int, error) {
	var out []interface{}
	err := _ReadWriteVar.contract.Call(opts, &out, "getVarMap", key)

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// GetVarMap is a free data retrieval call binding the contract method 0x68c7187b.
//
// Solidity: function getVarMap(uint256 key) view returns(uint256)
func (_ReadWriteVar *ReadWriteVarSession) GetVarMap(key *big.Int) (*big.Int, error) {
	return _ReadWriteVar.Contract.GetVarMap(&_ReadWriteVar.CallOpts, key)
}

// GetVarMap is a free data retrieval call binding the contract method 0x68c7187b.
//
// Solidity: function getVarMap(uint256 key) view returns(uint256)
func (_ReadWriteVar *ReadWriteVarCallerSession) GetVarMap(key *big.Int) (*big.Int, error) {
	return _ReadWriteVar.Contract.GetVarMap(&_ReadWriteVar.CallOpts, key)
}

// GetVarMapArray is a free data retrieval call binding the contract method 0xd4242881.
//
// Solidity: function getVarMapArray(uint256 key) view returns(uint256[])
func (_ReadWriteVar *ReadWriteVarCaller) GetVarMapArray(opts *bind.CallOpts, key *big.Int) ([]*big.Int, error) {
	var out []interface{}
	err := _ReadWriteVar.contract.Call(opts, &out, "getVarMapArray", key)

	if err != nil {
		return *new([]*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new([]*big.Int)).(*[]*big.Int)

	return out0, err

}

// GetVarMapArray is a free data retrieval call binding the contract method 0xd4242881.
//
// Solidity: function getVarMapArray(uint256 key) view returns(uint256[])
func (_ReadWriteVar *ReadWriteVarSession) GetVarMapArray(key *big.Int) ([]*big.Int, error) {
	return _ReadWriteVar.Contract.GetVarMapArray(&_ReadWriteVar.CallOpts, key)
}

// GetVarMapArray is a free data retrieval call binding the contract method 0xd4242881.
//
// Solidity: function getVarMapArray(uint256 key) view returns(uint256[])
func (_ReadWriteVar *ReadWriteVarCallerSession) GetVarMapArray(key *big.Int) ([]*big.Int, error) {
	return _ReadWriteVar.Contract.GetVarMapArray(&_ReadWriteVar.CallOpts, key)
}

// GetVarString is a free data retrieval call binding the contract method 0xa4ac27f3.
//
// Solidity: function getVarString() view returns(string)
func (_ReadWriteVar *ReadWriteVarCaller) GetVarString(opts *bind.CallOpts) (string, error) {
	var out []interface{}
	err := _ReadWriteVar.contract.Call(opts, &out, "getVarString")

	if err != nil {
		return *new(string), err
	}

	out0 := *abi.ConvertType(out[0], new(string)).(*string)

	return out0, err

}

// GetVarString is a free data retrieval call binding the contract method 0xa4ac27f3.
//
// Solidity: function getVarString() view returns(string)
func (_ReadWriteVar *ReadWriteVarSession) GetVarString() (string, error) {
	return _ReadWriteVar.Contract.GetVarString(&_ReadWriteVar.CallOpts)
}

// GetVarString is a free data retrieval call binding the contract method 0xa4ac27f3.
//
// Solidity: function getVarString() view returns(string)
func (_ReadWriteVar *ReadWriteVarCallerSession) GetVarString() (string, error) {
	return _ReadWriteVar.Contract.GetVarString(&_ReadWriteVar.CallOpts)
}

// GetVarStringArray is a free data retrieval call binding the contract method 0xbe59f2da.
//
// Solidity: function getVarStringArray() view returns(string[])
func (_ReadWriteVar *ReadWriteVarCaller) GetVarStringArray(opts *bind.CallOpts) ([]string, error) {
	var out []interface{}
	err := _ReadWriteVar.contract.Call(opts, &out, "getVarStringArray")

	if err != nil {
		return *new([]string), err
	}

	out0 := *abi.ConvertType(out[0], new([]string)).(*[]string)

	return out0, err

}

// GetVarStringArray is a free data retrieval call binding the contract method 0xbe59f2da.
//
// Solidity: function getVarStringArray() view returns(string[])
func (_ReadWriteVar *ReadWriteVarSession) GetVarStringArray() ([]string, error) {
	return _ReadWriteVar.Contract.GetVarStringArray(&_ReadWriteVar.CallOpts)
}

// GetVarStringArray is a free data retrieval call binding the contract method 0xbe59f2da.
//
// Solidity: function getVarStringArray() view returns(string[])
func (_ReadWriteVar *ReadWriteVarCallerSession) GetVarStringArray() ([]string, error) {
	return _ReadWriteVar.Contract.GetVarStringArray(&_ReadWriteVar.CallOpts)
}

// GetVarUint256 is a free data retrieval call binding the contract method 0x6b83cbf1.
//
// Solidity: function getVarUint256() view returns(uint256)
func (_ReadWriteVar *ReadWriteVarCaller) GetVarUint256(opts *bind.CallOpts) (*big.Int, error) {
	var out []interface{}
	err := _ReadWriteVar.contract.Call(opts, &out, "getVarUint256")

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// GetVarUint256 is a free data retrieval call binding the contract method 0x6b83cbf1.
//
// Solidity: function getVarUint256() view returns(uint256)
func (_ReadWriteVar *ReadWriteVarSession) GetVarUint256() (*big.Int, error) {
	return _ReadWriteVar.Contract.GetVarUint256(&_ReadWriteVar.CallOpts)
}

// GetVarUint256 is a free data retrieval call binding the contract method 0x6b83cbf1.
//
// Solidity: function getVarUint256() view returns(uint256)
func (_ReadWriteVar *ReadWriteVarCallerSession) GetVarUint256() (*big.Int, error) {
	return _ReadWriteVar.Contract.GetVarUint256(&_ReadWriteVar.CallOpts)
}

// GetVarUintArray is a free data retrieval call binding the contract method 0xa0f63be1.
//
// Solidity: function getVarUintArray() view returns(uint256[])
func (_ReadWriteVar *ReadWriteVarCaller) GetVarUintArray(opts *bind.CallOpts) ([]*big.Int, error) {
	var out []interface{}
	err := _ReadWriteVar.contract.Call(opts, &out, "getVarUintArray")

	if err != nil {
		return *new([]*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new([]*big.Int)).(*[]*big.Int)

	return out0, err

}

// GetVarUintArray is a free data retrieval call binding the contract method 0xa0f63be1.
//
// Solidity: function getVarUintArray() view returns(uint256[])
func (_ReadWriteVar *ReadWriteVarSession) GetVarUintArray() ([]*big.Int, error) {
	return _ReadWriteVar.Contract.GetVarUintArray(&_ReadWriteVar.CallOpts)
}

// GetVarUintArray is a free data retrieval call binding the contract method 0xa0f63be1.
//
// Solidity: function getVarUintArray() view returns(uint256[])
func (_ReadWriteVar *ReadWriteVarCallerSession) GetVarUintArray() ([]*big.Int, error) {
	return _ReadWriteVar.Contract.GetVarUintArray(&_ReadWriteVar.CallOpts)
}

// VarMap is a free data retrieval call binding the contract method 0x1c11bb68.
//
// Solidity: function varMap(uint256 ) view returns(uint256)
func (_ReadWriteVar *ReadWriteVarCaller) VarMap(opts *bind.CallOpts, arg0 *big.Int) (*big.Int, error) {
	var out []interface{}
	err := _ReadWriteVar.contract.Call(opts, &out, "varMap", arg0)

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// VarMap is a free data retrieval call binding the contract method 0x1c11bb68.
//
// Solidity: function varMap(uint256 ) view returns(uint256)
func (_ReadWriteVar *ReadWriteVarSession) VarMap(arg0 *big.Int) (*big.Int, error) {
	return _ReadWriteVar.Contract.VarMap(&_ReadWriteVar.CallOpts, arg0)
}

// VarMap is a free data retrieval call binding the contract method 0x1c11bb68.
//
// Solidity: function varMap(uint256 ) view returns(uint256)
func (_ReadWriteVar *ReadWriteVarCallerSession) VarMap(arg0 *big.Int) (*big.Int, error) {
	return _ReadWriteVar.Contract.VarMap(&_ReadWriteVar.CallOpts, arg0)
}

// VarMapArray is a free data retrieval call binding the contract method 0x2aa47566.
//
// Solidity: function varMapArray(uint256 , uint256 ) view returns(uint256)
func (_ReadWriteVar *ReadWriteVarCaller) VarMapArray(opts *bind.CallOpts, arg0 *big.Int, arg1 *big.Int) (*big.Int, error) {
	var out []interface{}
	err := _ReadWriteVar.contract.Call(opts, &out, "varMapArray", arg0, arg1)

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// VarMapArray is a free data retrieval call binding the contract method 0x2aa47566.
//
// Solidity: function varMapArray(uint256 , uint256 ) view returns(uint256)
func (_ReadWriteVar *ReadWriteVarSession) VarMapArray(arg0 *big.Int, arg1 *big.Int) (*big.Int, error) {
	return _ReadWriteVar.Contract.VarMapArray(&_ReadWriteVar.CallOpts, arg0, arg1)
}

// VarMapArray is a free data retrieval call binding the contract method 0x2aa47566.
//
// Solidity: function varMapArray(uint256 , uint256 ) view returns(uint256)
func (_ReadWriteVar *ReadWriteVarCallerSession) VarMapArray(arg0 *big.Int, arg1 *big.Int) (*big.Int, error) {
	return _ReadWriteVar.Contract.VarMapArray(&_ReadWriteVar.CallOpts, arg0, arg1)
}

// VarString is a free data retrieval call binding the contract method 0xba22b3ca.
//
// Solidity: function varString() view returns(string)
func (_ReadWriteVar *ReadWriteVarCaller) VarString(opts *bind.CallOpts) (string, error) {
	var out []interface{}
	err := _ReadWriteVar.contract.Call(opts, &out, "varString")

	if err != nil {
		return *new(string), err
	}

	out0 := *abi.ConvertType(out[0], new(string)).(*string)

	return out0, err

}

// VarString is a free data retrieval call binding the contract method 0xba22b3ca.
//
// Solidity: function varString() view returns(string)
func (_ReadWriteVar *ReadWriteVarSession) VarString() (string, error) {
	return _ReadWriteVar.Contract.VarString(&_ReadWriteVar.CallOpts)
}

// VarString is a free data retrieval call binding the contract method 0xba22b3ca.
//
// Solidity: function varString() view returns(string)
func (_ReadWriteVar *ReadWriteVarCallerSession) VarString() (string, error) {
	return _ReadWriteVar.Contract.VarString(&_ReadWriteVar.CallOpts)
}

// VarStringArray is a free data retrieval call binding the contract method 0xec660a78.
//
// Solidity: function varStringArray(uint256 ) view returns(string)
func (_ReadWriteVar *ReadWriteVarCaller) VarStringArray(opts *bind.CallOpts, arg0 *big.Int) (string, error) {
	var out []interface{}
	err := _ReadWriteVar.contract.Call(opts, &out, "varStringArray", arg0)

	if err != nil {
		return *new(string), err
	}

	out0 := *abi.ConvertType(out[0], new(string)).(*string)

	return out0, err

}

// VarStringArray is a free data retrieval call binding the contract method 0xec660a78.
//
// Solidity: function varStringArray(uint256 ) view returns(string)
func (_ReadWriteVar *ReadWriteVarSession) VarStringArray(arg0 *big.Int) (string, error) {
	return _ReadWriteVar.Contract.VarStringArray(&_ReadWriteVar.CallOpts, arg0)
}

// VarStringArray is a free data retrieval call binding the contract method 0xec660a78.
//
// Solidity: function varStringArray(uint256 ) view returns(string)
func (_ReadWriteVar *ReadWriteVarCallerSession) VarStringArray(arg0 *big.Int) (string, error) {
	return _ReadWriteVar.Contract.VarStringArray(&_ReadWriteVar.CallOpts, arg0)
}

// VarUint256 is a free data retrieval call binding the contract method 0x9c0dde45.
//
// Solidity: function varUint256() view returns(uint256)
func (_ReadWriteVar *ReadWriteVarCaller) VarUint256(opts *bind.CallOpts) (*big.Int, error) {
	var out []interface{}
	err := _ReadWriteVar.contract.Call(opts, &out, "varUint256")

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// VarUint256 is a free data retrieval call binding the contract method 0x9c0dde45.
//
// Solidity: function varUint256() view returns(uint256)
func (_ReadWriteVar *ReadWriteVarSession) VarUint256() (*big.Int, error) {
	return _ReadWriteVar.Contract.VarUint256(&_ReadWriteVar.CallOpts)
}

// VarUint256 is a free data retrieval call binding the contract method 0x9c0dde45.
//
// Solidity: function varUint256() view returns(uint256)
func (_ReadWriteVar *ReadWriteVarCallerSession) VarUint256() (*big.Int, error) {
	return _ReadWriteVar.Contract.VarUint256(&_ReadWriteVar.CallOpts)
}

// VarUintArray is a free data retrieval call binding the contract method 0xa55cf49d.
//
// Solidity: function varUintArray(uint256 ) view returns(uint256)
func (_ReadWriteVar *ReadWriteVarCaller) VarUintArray(opts *bind.CallOpts, arg0 *big.Int) (*big.Int, error) {
	var out []interface{}
	err := _ReadWriteVar.contract.Call(opts, &out, "varUintArray", arg0)

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// VarUintArray is a free data retrieval call binding the contract method 0xa55cf49d.
//
// Solidity: function varUintArray(uint256 ) view returns(uint256)
func (_ReadWriteVar *ReadWriteVarSession) VarUintArray(arg0 *big.Int) (*big.Int, error) {
	return _ReadWriteVar.Contract.VarUintArray(&_ReadWriteVar.CallOpts, arg0)
}

// VarUintArray is a free data retrieval call binding the contract method 0xa55cf49d.
//
// Solidity: function varUintArray(uint256 ) view returns(uint256)
func (_ReadWriteVar *ReadWriteVarCallerSession) VarUintArray(arg0 *big.Int) (*big.Int, error) {
	return _ReadWriteVar.Contract.VarUintArray(&_ReadWriteVar.CallOpts, arg0)
}

// PushVarMapArray is a paid mutator transaction binding the contract method 0x01f045e0.
//
// Solidity: function pushVarMapArray(uint256 key, uint256 value) returns()
func (_ReadWriteVar *ReadWriteVarTransactor) PushVarMapArray(opts *bind.TransactOpts, key *big.Int, value *big.Int) (*types.Transaction, error) {
	return _ReadWriteVar.contract.Transact(opts, "pushVarMapArray", key, value)
}

// PushVarMapArray is a paid mutator transaction binding the contract method 0x01f045e0.
//
// Solidity: function pushVarMapArray(uint256 key, uint256 value) returns()
func (_ReadWriteVar *ReadWriteVarSession) PushVarMapArray(key *big.Int, value *big.Int) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.PushVarMapArray(&_ReadWriteVar.TransactOpts, key, value)
}

// PushVarMapArray is a paid mutator transaction binding the contract method 0x01f045e0.
//
// Solidity: function pushVarMapArray(uint256 key, uint256 value) returns()
func (_ReadWriteVar *ReadWriteVarTransactorSession) PushVarMapArray(key *big.Int, value *big.Int) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.PushVarMapArray(&_ReadWriteVar.TransactOpts, key, value)
}

// PushVarStringArray is a paid mutator transaction binding the contract method 0xa3f32fb8.
//
// Solidity: function pushVarStringArray(string value) returns()
func (_ReadWriteVar *ReadWriteVarTransactor) PushVarStringArray(opts *bind.TransactOpts, value string) (*types.Transaction, error) {
	return _ReadWriteVar.contract.Transact(opts, "pushVarStringArray", value)
}

// PushVarStringArray is a paid mutator transaction binding the contract method 0xa3f32fb8.
//
// Solidity: function pushVarStringArray(string value) returns()
func (_ReadWriteVar *ReadWriteVarSession) PushVarStringArray(value string) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.PushVarStringArray(&_ReadWriteVar.TransactOpts, value)
}

// PushVarStringArray is a paid mutator transaction binding the contract method 0xa3f32fb8.
//
// Solidity: function pushVarStringArray(string value) returns()
func (_ReadWriteVar *ReadWriteVarTransactorSession) PushVarStringArray(value string) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.PushVarStringArray(&_ReadWriteVar.TransactOpts, value)
}

// PushVarUintArray is a paid mutator transaction binding the contract method 0x7e76b995.
//
// Solidity: function pushVarUintArray(uint256 value) returns()
func (_ReadWriteVar *ReadWriteVarTransactor) PushVarUintArray(opts *bind.TransactOpts, value *big.Int) (*types.Transaction, error) {
	return _ReadWriteVar.contract.Transact(opts, "pushVarUintArray", value)
}

// PushVarUintArray is a paid mutator transaction binding the contract method 0x7e76b995.
//
// Solidity: function pushVarUintArray(uint256 value) returns()
func (_ReadWriteVar *ReadWriteVarSession) PushVarUintArray(value *big.Int) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.PushVarUintArray(&_ReadWriteVar.TransactOpts, value)
}

// PushVarUintArray is a paid mutator transaction binding the contract method 0x7e76b995.
//
// Solidity: function pushVarUintArray(uint256 value) returns()
func (_ReadWriteVar *ReadWriteVarTransactorSession) PushVarUintArray(value *big.Int) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.PushVarUintArray(&_ReadWriteVar.TransactOpts, value)
}

// SetVarMap is a paid mutator transaction binding the contract method 0x463a8c60.
//
// Solidity: function setVarMap(uint256 key, uint256 value) returns()
func (_ReadWriteVar *ReadWriteVarTransactor) SetVarMap(opts *bind.TransactOpts, key *big.Int, value *big.Int) (*types.Transaction, error) {
	return _ReadWriteVar.contract.Transact(opts, "setVarMap", key, value)
}

// SetVarMap is a paid mutator transaction binding the contract method 0x463a8c60.
//
// Solidity: function setVarMap(uint256 key, uint256 value) returns()
func (_ReadWriteVar *ReadWriteVarSession) SetVarMap(key *big.Int, value *big.Int) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.SetVarMap(&_ReadWriteVar.TransactOpts, key, value)
}

// SetVarMap is a paid mutator transaction binding the contract method 0x463a8c60.
//
// Solidity: function setVarMap(uint256 key, uint256 value) returns()
func (_ReadWriteVar *ReadWriteVarTransactorSession) SetVarMap(key *big.Int, value *big.Int) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.SetVarMap(&_ReadWriteVar.TransactOpts, key, value)
}

// SetVarMapArray is a paid mutator transaction binding the contract method 0xdb277ccc.
//
// Solidity: function setVarMapArray(uint256 key, uint256[] valueArr) returns()
func (_ReadWriteVar *ReadWriteVarTransactor) SetVarMapArray(opts *bind.TransactOpts, key *big.Int, valueArr []*big.Int) (*types.Transaction, error) {
	return _ReadWriteVar.contract.Transact(opts, "setVarMapArray", key, valueArr)
}

// SetVarMapArray is a paid mutator transaction binding the contract method 0xdb277ccc.
//
// Solidity: function setVarMapArray(uint256 key, uint256[] valueArr) returns()
func (_ReadWriteVar *ReadWriteVarSession) SetVarMapArray(key *big.Int, valueArr []*big.Int) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.SetVarMapArray(&_ReadWriteVar.TransactOpts, key, valueArr)
}

// SetVarMapArray is a paid mutator transaction binding the contract method 0xdb277ccc.
//
// Solidity: function setVarMapArray(uint256 key, uint256[] valueArr) returns()
func (_ReadWriteVar *ReadWriteVarTransactorSession) SetVarMapArray(key *big.Int, valueArr []*big.Int) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.SetVarMapArray(&_ReadWriteVar.TransactOpts, key, valueArr)
}

// SetVarString is a paid mutator transaction binding the contract method 0x91aa423a.
//
// Solidity: function setVarString(string value) returns()
func (_ReadWriteVar *ReadWriteVarTransactor) SetVarString(opts *bind.TransactOpts, value string) (*types.Transaction, error) {
	return _ReadWriteVar.contract.Transact(opts, "setVarString", value)
}

// SetVarString is a paid mutator transaction binding the contract method 0x91aa423a.
//
// Solidity: function setVarString(string value) returns()
func (_ReadWriteVar *ReadWriteVarSession) SetVarString(value string) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.SetVarString(&_ReadWriteVar.TransactOpts, value)
}

// SetVarString is a paid mutator transaction binding the contract method 0x91aa423a.
//
// Solidity: function setVarString(string value) returns()
func (_ReadWriteVar *ReadWriteVarTransactorSession) SetVarString(value string) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.SetVarString(&_ReadWriteVar.TransactOpts, value)
}

// SetVarStringArray is a paid mutator transaction binding the contract method 0x0063caa8.
//
// Solidity: function setVarStringArray(string[] value) returns()
func (_ReadWriteVar *ReadWriteVarTransactor) SetVarStringArray(opts *bind.TransactOpts, value []string) (*types.Transaction, error) {
	return _ReadWriteVar.contract.Transact(opts, "setVarStringArray", value)
}

// SetVarStringArray is a paid mutator transaction binding the contract method 0x0063caa8.
//
// Solidity: function setVarStringArray(string[] value) returns()
func (_ReadWriteVar *ReadWriteVarSession) SetVarStringArray(value []string) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.SetVarStringArray(&_ReadWriteVar.TransactOpts, value)
}

// SetVarStringArray is a paid mutator transaction binding the contract method 0x0063caa8.
//
// Solidity: function setVarStringArray(string[] value) returns()
func (_ReadWriteVar *ReadWriteVarTransactorSession) SetVarStringArray(value []string) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.SetVarStringArray(&_ReadWriteVar.TransactOpts, value)
}

// SetVarUint256 is a paid mutator transaction binding the contract method 0xba525ac0.
//
// Solidity: function setVarUint256(uint256 value) returns()
func (_ReadWriteVar *ReadWriteVarTransactor) SetVarUint256(opts *bind.TransactOpts, value *big.Int) (*types.Transaction, error) {
	return _ReadWriteVar.contract.Transact(opts, "setVarUint256", value)
}

// SetVarUint256 is a paid mutator transaction binding the contract method 0xba525ac0.
//
// Solidity: function setVarUint256(uint256 value) returns()
func (_ReadWriteVar *ReadWriteVarSession) SetVarUint256(value *big.Int) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.SetVarUint256(&_ReadWriteVar.TransactOpts, value)
}

// SetVarUint256 is a paid mutator transaction binding the contract method 0xba525ac0.
//
// Solidity: function setVarUint256(uint256 value) returns()
func (_ReadWriteVar *ReadWriteVarTransactorSession) SetVarUint256(value *big.Int) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.SetVarUint256(&_ReadWriteVar.TransactOpts, value)
}

// SetVarUintArray is a paid mutator transaction binding the contract method 0x919a1707.
//
// Solidity: function setVarUintArray(uint256[] value) returns()
func (_ReadWriteVar *ReadWriteVarTransactor) SetVarUintArray(opts *bind.TransactOpts, value []*big.Int) (*types.Transaction, error) {
	return _ReadWriteVar.contract.Transact(opts, "setVarUintArray", value)
}

// SetVarUintArray is a paid mutator transaction binding the contract method 0x919a1707.
//
// Solidity: function setVarUintArray(uint256[] value) returns()
func (_ReadWriteVar *ReadWriteVarSession) SetVarUintArray(value []*big.Int) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.SetVarUintArray(&_ReadWriteVar.TransactOpts, value)
}

// SetVarUintArray is a paid mutator transaction binding the contract method 0x919a1707.
//
// Solidity: function setVarUintArray(uint256[] value) returns()
func (_ReadWriteVar *ReadWriteVarTransactorSession) SetVarUintArray(value []*big.Int) (*types.Transaction, error) {
	return _ReadWriteVar.Contract.SetVarUintArray(&_ReadWriteVar.TransactOpts, value)
}
