package coin

import (
	contractCoin "contract-case/contract_abi/coin_transfer/compile"
	"contract-case/log"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"math/big"
)

type ContractCoinTwoTrade struct {
	OneChainContractAddr common.Address
	ChainContractAddr    common.Address
	ToAddr               []common.Address
	Amount               *big.Int
}

func (trade *ContractCoinTwoTrade) TwoTransferSignTx(tranOpts *bind.TransactOpts, twoChainCoinTransfer *contractCoin.TwoChainCoinTransfer) (*types.Transaction, error) {
	twoTransferTx, err := twoChainCoinTransfer.TwoTransfer(tranOpts, trade.OneChainContractAddr, trade.ChainContractAddr, trade.ToAddr, trade.Amount)
	if err != nil {
		log.Errorf("TwoTransferSignTx func two transfer tx error: %s", err)
		return nil, err
	}
	log.Info("twoTransferTx:", twoTransferTx.Hash())
	return twoTransferTx, nil
}
