package coin

import (
	"contract-case/log"
	"contract-case/util"
	"crypto/ecdsa"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"math/big"
)

type Trade struct {
	FromPrv   *ecdsa.PrivateKey
	FromNonce *big.Int
	ToAddr    *common.Address
	Amount    *big.Int
	Gas       *big.Int
	GasPrice  *big.Int
	ChainId   *big.Int
}

func (coinTrade *Trade) CoinTransferSignTx() (*types.Transaction, error) {
	txData := &types.LegacyTx{
		Nonce:    coinTrade.FromNonce.Uint64(),
		To:       coinTrade.ToAddr,
		Value:    coinTrade.Amount,
		Gas:      coinTrade.Gas.Uint64(),
		GasPrice: coinTrade.GasPrice,
		Data:     nil,
	}
	tx, err := util.SignNewTx(txData, coinTrade.ChainId, coinTrade.FromPrv)
	if err != nil {
		log.Errorf("Coin transfer sign tx err: %s", err.Error())
		return nil, err
	}
	return tx, nil
}
