package deploy

import (
	"contract-case/constant"
	coin "contract-case/contract_abi/coin_transfer/compile"
	erc20 "contract-case/contract_abi/erc20_transfer/compile"
	erc721 "contract-case/contract_abi/erc721_transfer/compile"
	rw "contract-case/contract_abi/read_write/compile"
	"contract-case/log"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/ethclient"
)

var DeployFunc = make([]func(auth *bind.TransactOpts, client *ethclient.Client) (common.Address, *types.Transaction, string), 0)

func init() {
	DeployFunc = append(DeployFunc, GetDeployERC20Tx)
	DeployFunc = append(DeployFunc, GetDeployTokenTransferTx)
	DeployFunc = append(DeployFunc, GetDeployOneTokenTransferTx)
	DeployFunc = append(DeployFunc, GetDeployTwoTokenTransferTx)
	DeployFunc = append(DeployFunc, GetDeployChainCoinTransferTx)
	DeployFunc = append(DeployFunc, GetDeployOneChainCoinTransferTx)
	DeployFunc = append(DeployFunc, GetDeployTwoChainCoinTransferTx)
	DeployFunc = append(DeployFunc, GetDeployErc721)
	DeployFunc = append(DeployFunc, GetDeployNftTokenTransfer)
	DeployFunc = append(DeployFunc, GetDeployOneNftTokenTransferTx)
	DeployFunc = append(DeployFunc, GetDeployTwoNftTokenTransferTx)
	DeployFunc = append(DeployFunc, GetDeployReadWriteVarTx)
	DeployFunc = append(DeployFunc, GetDeployOneReadWriteVarTx)
	DeployFunc = append(DeployFunc, GetDeployReadWriteBlock)
}

func GetDeployERC20Tx(auth *bind.TransactOpts, client *ethclient.Client) (common.Address, *types.Transaction, string) {
	addr, tx, _, err := erc20.DeployERC20(auth, client, "test", "case")
	if err != nil {
		log.Fatal(err)
	}
	return addr, tx, constant.ERC20
}

func GetDeployTokenTransferTx(auth *bind.TransactOpts, client *ethclient.Client) (common.Address, *types.Transaction, string) {
	addr, tx, _, err := erc20.DeployTokenTransfer(auth, client)
	if err != nil {
		log.Fatal(err)
	}
	return addr, tx, constant.TOKEN20_TRANSFER
}

func GetDeployOneTokenTransferTx(auth *bind.TransactOpts, client *ethclient.Client) (common.Address, *types.Transaction, string) {
	addr, tx, _, err := erc20.DeployOneTokenTransfer(auth, client)
	if err != nil {
		log.Fatal(err)
	}
	return addr, tx, constant.ONE_TOKEN20_TRANSFER
}
func GetDeployTwoTokenTransferTx(auth *bind.TransactOpts, client *ethclient.Client) (common.Address, *types.Transaction, string) {
	addr, tx, _, err := erc20.DeployTwoTokenTransfer(auth, client)
	if err != nil {
		log.Fatal(err)
	}
	return addr, tx, constant.TWO_TOKEN20_TRANSFER
}

func GetDeployChainCoinTransferTx(auth *bind.TransactOpts, client *ethclient.Client) (common.Address, *types.Transaction, string) {
	addr, tx, _, err := coin.DeployChainCoinTransfer(auth, client)
	if err != nil {
		log.Fatal(err)
	}
	return addr, tx, constant.COIN_TRANSFER
}

func GetDeployOneChainCoinTransferTx(auth *bind.TransactOpts, client *ethclient.Client) (common.Address, *types.Transaction, string) {
	addr, tx, _, err := coin.DeployOneChainCoinTransfer(auth, client)
	if err != nil {
		log.Fatal(err)
	}
	return addr, tx, constant.ONE_COIN_TRANSFER
}

func GetDeployTwoChainCoinTransferTx(auth *bind.TransactOpts, client *ethclient.Client) (common.Address, *types.Transaction, string) {
	addr, tx, _, err := coin.DeployTwoChainCoinTransfer(auth, client)
	if err != nil {
		log.Fatal(err)
	}
	return addr, tx, constant.TWO_COIN_TRANSFER
}

func GetDeployErc721(auth *bind.TransactOpts, client *ethclient.Client) (common.Address, *types.Transaction, string) {
	addr, tx, _, err := erc721.DeployERC721(auth, client, "CaduceusErc721", "META")
	if err != nil {
		log.Fatal(err)
	}
	return addr, tx, constant.ERC721
}

func GetDeployNftTokenTransfer(auth *bind.TransactOpts, client *ethclient.Client) (common.Address, *types.Transaction, string) {
	addr, tx, _, err := erc721.DeployNftTokenTransfer(auth, client)
	if err != nil {
		log.Fatal(err)
	}
	return addr, tx, constant.TOKEN721_TRANSFER
}

func GetDeployOneNftTokenTransferTx(auth *bind.TransactOpts, client *ethclient.Client) (common.Address, *types.Transaction, string) {
	addr, tx, _, err := erc721.DeployOneNftTokenTransfer(auth, client)
	if err != nil {
		log.Fatal(err)
	}
	return addr, tx, constant.ONE_TOKEN721_TRANSFER
}

func GetDeployTwoNftTokenTransferTx(auth *bind.TransactOpts, client *ethclient.Client) (common.Address, *types.Transaction, string) {
	addr, tx, _, err := erc721.DeployTwoNftTokenTransfer(auth, client)
	if err != nil {
		log.Fatal(err)
	}
	return addr, tx, constant.TWO_TOKEN721_TRANSFER
}

func GetDeployReadWriteVarTx(auth *bind.TransactOpts, client *ethclient.Client) (common.Address, *types.Transaction, string) {
	addr, tx, _, err := rw.DeployReadWriteVar(auth, client)
	if err != nil {
		log.Fatal(err)
	}
	return addr, tx, constant.READ_WRITE
}

func GetDeployOneReadWriteVarTx(auth *bind.TransactOpts, client *ethclient.Client) (common.Address, *types.Transaction, string) {
	addr, tx, _, err := rw.DeployOneReadWriteVar(auth, client)
	if err != nil {
		log.Fatal(err)
	}
	return addr, tx, constant.ONE_READ_WRITE
}

func GetDeployReadWriteBlock(auth *bind.TransactOpts, client *ethclient.Client) (common.Address, *types.Transaction, string) {
	addr, tx, _, err := rw.DeployReadWriteBlock(auth, client)
	if err != nil {
		log.Fatal(err)
	}
	return addr, tx, constant.READ_CHAIN
}
