package contractErc20

import (
	contractToken20 "contract-case/contract_abi/erc20_transfer/compile"
	"contract-case/log"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"math/big"
)

type OneErc20Trade struct {
	TokenTransferAddr common.Address
	Erc20Addr         common.Address
	FromAddr          common.Address
	ToAddr            []common.Address
	Amount            *big.Int
}

func (trade *OneErc20Trade) Erc20OneTransferTx(tranOpts *bind.TransactOpts, tokenTransfer *contractToken20.OneTokenTransfer) (*types.Transaction, error) {
	oneTransferTx, err := tokenTransfer.OneTransfer(tranOpts, trade.TokenTransferAddr, trade.Erc20Addr, trade.ToAddr, trade.Amount)
	if err != nil {
		log.Errorf("Erc20OneTransferTx func oneTransfer tx error: %s", err)
		return nil, err
	}
	log.Info("tokenTransfer:", oneTransferTx.Hash())
	return oneTransferTx, nil
}

func (trade *OneErc20Trade) Erc20OneTransferFromTx(tranOpts *bind.TransactOpts, tokenTransfer *contractToken20.OneTokenTransfer) (*types.Transaction, error) {
	tokenTransferFromTx, err := tokenTransfer.OneTransferFrom(tranOpts, trade.TokenTransferAddr, trade.Erc20Addr, trade.FromAddr, trade.ToAddr[0], trade.Amount)
	if err != nil {
		log.Errorf("Constructor TokenTransferFrom tx error: %s", err)
		return nil, err
	}
	log.Info("tokenTransferFromTx:", tokenTransferFromTx.Hash())
	return tokenTransferFromTx, nil
}
