package contractErc20

import (
	contractToken20 "contract-case/contract_abi/erc20_transfer/compile"
	"contract-case/log"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"math/big"
)

type TwoErc20Trade struct {
	OneTokenTransferAddr common.Address
	TokenTransfer        common.Address
	Erc20Addr            common.Address
	FromAddr             common.Address
	ToAddr               []common.Address
	Amount               *big.Int
}

func (trade *TwoErc20Trade) Erc20TwoTransferSignTx(tranOpts *bind.TransactOpts, tokenTransfer *contractToken20.TwoTokenTransfer) (*types.Transaction, error) {
	tokenTransferTx, err := tokenTransfer.TwoTransfer(tranOpts, trade.OneTokenTransferAddr, trade.TokenTransfer, trade.Erc20Addr, trade.ToAddr, trade.Amount)
	if err != nil {
		log.Errorf("Erc20TwoTransferSignTx func twoTransfer tx error: %s", err)
		return nil, err
	}
	log.Info("tokenTransfer:", tokenTransferTx.Hash())
	return tokenTransferTx, nil
}

func (trade *TwoErc20Trade) Erc20TwoTransferFromSignTx(tranOpts *bind.TransactOpts, tokenTransfer *contractToken20.TwoTokenTransfer) (*types.Transaction, error) {
	twoTransferFromTx, err := tokenTransfer.TwoTransferFrom(tranOpts, trade.OneTokenTransferAddr, trade.TokenTransfer, trade.Erc20Addr, trade.FromAddr, trade.ToAddr[0], trade.Amount)
	if err != nil {
		log.Errorf("Erc20TwoTransferFromSignTx func twoTransferFrom tx error: %s", err)
		return nil, err
	}
	log.Info("twoTransferFromTx:", twoTransferFromTx.Hash())
	return twoTransferFromTx, nil
}
