package readWrite

import (
	contractReadWrite "contract-case/contract_abi/read_write/compile"
	"contract-case/log"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"math/big"
)

type OneReadWriteTrade struct {
	ReadWriteContract common.Address
	KeyParam          *big.Int
	ValueParam        *big.Int
	StringParam       string
	UintParam         *big.Int
	ValueArrParam     []*big.Int
	StringArrParam    []string
}

func (trade *OneReadWriteTrade) OneReadWriteSignTxPushVarMapArray(tranOpts *bind.TransactOpts, transfer contractReadWrite.OneReadWriteVar) (*types.Transaction, error) {
	pushVarMapArrayTx, err := transfer.OnePushVarMapArray(tranOpts, trade.ReadWriteContract, trade.KeyParam, trade.ValueParam)
	if err != nil {
		log.Errorf("OneReadWriteSignTxPushVarMapArray func pushVarMapArrayTx tx error: %s", err)
		return nil, err
	}
	log.Info("pushVarMapArrayTx:", pushVarMapArrayTx.Hash())
	return pushVarMapArrayTx, nil
}

func (trade *OneReadWriteTrade) OneReadWriteSignTxPushVarStringArray(tranOpts *bind.TransactOpts, transfer contractReadWrite.OneReadWriteVar) (*types.Transaction, error) {
	pushVarStringArrayTx, err := transfer.OnePushVarStringArray(tranOpts, trade.ReadWriteContract, trade.StringParam)
	if err != nil {
		log.Errorf("OneReadWriteSignTxPushVarStringArray func pushVarStringArrayTx tx error: %s", err)
		return nil, err
	}
	log.Info("pushVarStringArrayTx:", pushVarStringArrayTx.Hash())
	return pushVarStringArrayTx, nil
}

func (trade *OneReadWriteTrade) OneReadWriteSignTxPushVarUintArray(tranOpts *bind.TransactOpts, transfer contractReadWrite.OneReadWriteVar) (*types.Transaction, error) {
	pushVarUintArrayTx, err := transfer.OnePushVarUintArray(tranOpts, trade.ReadWriteContract, trade.UintParam)
	if err != nil {
		log.Errorf("OneReadWriteSignTxPushVarUintArray func PushVarUintArray tx error: %s", err)
		return nil, err
	}
	log.Info("pushVarUintArrayTx:", pushVarUintArrayTx.Hash())
	return pushVarUintArrayTx, nil
}

func (trade *OneReadWriteTrade) OneReadWriteSignTxSetVarString(tranOpts *bind.TransactOpts, transfer contractReadWrite.OneReadWriteVar) (*types.Transaction, error) {
	setVarStringTx, err := transfer.OneSetVarString(tranOpts, trade.ReadWriteContract, trade.StringParam)
	if err != nil {
		log.Errorf("OneReadWriteSignTxSetVarString func SetVarString tx error: %s", err)
		return nil, err
	}
	log.Info("setVarStringTx:", setVarStringTx.Hash())
	return setVarStringTx, nil
}

func (trade *OneReadWriteTrade) OneReadWriteSignTxSetVarMap(tranOpts *bind.TransactOpts, transfer contractReadWrite.OneReadWriteVar) (*types.Transaction, error) {
	SetVarMapTx, err := transfer.OneSetVarMap(tranOpts, trade.ReadWriteContract, trade.KeyParam, trade.ValueParam)
	if err != nil {
		log.Errorf("OneReadWriteSignTxSetVarMap func SetVarMap tx error: %s", err)
		return nil, err
	}
	log.Info("pushVarMapArrayTx:", SetVarMapTx.Hash())
	return SetVarMapTx, nil
}

func (trade *OneReadWriteTrade) OneReadWriteSignTxSetVarMapArray(tranOpts *bind.TransactOpts, transfer contractReadWrite.OneReadWriteVar) (*types.Transaction, error) {
	SetVarMapArrayTx, err := transfer.OneSetVarMapArray(tranOpts, trade.ReadWriteContract, trade.KeyParam, trade.ValueArrParam)
	if err != nil {
		log.Errorf("OneReadWriteSignTxSetVarMapArray func SetVarMapArray tx error: %s", err)
		return nil, err
	}
	log.Info("SetVarMapArrayTx:", SetVarMapArrayTx.Hash())
	return SetVarMapArrayTx, nil
}

func (trade *OneReadWriteTrade) OneReadWriteSignTxSetVarUint256(tranOpts *bind.TransactOpts, transfer contractReadWrite.OneReadWriteVar) (*types.Transaction, error) {
	setVarUint256Tx, err := transfer.OneSetVarUint256(tranOpts, trade.ReadWriteContract, trade.UintParam)
	if err != nil {
		log.Errorf("OneReadWriteSignTxSetVarUint256 func SetVarUint256 tx error: %s", err)
		return nil, err
	}
	log.Info("setVarUint256Tx:", setVarUint256Tx.Hash())
	return setVarUint256Tx, nil
}

func (trade *OneReadWriteTrade) OneReadWriteSignTxSetVarStringArray(tranOpts *bind.TransactOpts, transfer contractReadWrite.OneReadWriteVar) (*types.Transaction, error) {
	SetVarStringArrayTx, err := transfer.OneSetVarStringArray(tranOpts, trade.ReadWriteContract, trade.StringArrParam)
	if err != nil {
		log.Errorf("OneReadWriteSignTxSetVarStringArray func SetVarStringArray tx error: %s", err)
		return nil, err
	}
	log.Info("SetVarStringArrayTx:", SetVarStringArrayTx.Hash())
	return SetVarStringArrayTx, nil
}

func (trade *OneReadWriteTrade) OneReadWriteSignTxSetVarUintArray(tranOpts *bind.TransactOpts, transfer contractReadWrite.OneReadWriteVar) (*types.Transaction, error) {
	SetVarUintArrayTx, err := transfer.OneSetVarUintArray(tranOpts, trade.ReadWriteContract, trade.ValueArrParam)
	if err != nil {
		log.Errorf("OneReadWriteSignTxSetVarUintArray func SetVarUintArray tx error: %s", err)
		return nil, err
	}
	log.Info("SetVarUintArrayTx:", SetVarUintArrayTx.Hash())
	return SetVarUintArrayTx, nil
}
