package contractErc721

import (
	erc721 "contract-case/contract_abi/erc721_transfer/compile"
	"contract-case/log"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"math/big"
)

type TwoErc721Trade struct {
	OneErc721TransferAddr common.Address
	NftTokenTransferAddr  common.Address
	Erc721Addr            common.Address
	FromAddr              common.Address
	ToAddr                common.Address
	TokenId               *big.Int
}

func (trade *TwoErc721Trade) Erc721TwoTransferFromSignTx(tranOpts *bind.TransactOpts, transfer erc721.TwoNftTokenTransfer) (*types.Transaction, error) {
	oneTransferFromTx, err := transfer.OneTransferFrom(tranOpts, trade.OneErc721TransferAddr, trade.NftTokenTransferAddr, trade.Erc721Addr, trade.FromAddr, trade.ToAddr, trade.TokenId)
	if err != nil {
		log.Errorf("Erc721TwoTransferFromSignTx func OneTransferFrom tx error: %s", err)
		return nil, err
	}
	log.Info("oneTransferFromTx:", oneTransferFromTx.Hash())
	return oneTransferFromTx, nil
}
