// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package contractReadWrite

import (
	"errors"
	"math/big"
	"strings"

	ethereum "github.com/ethereum/go-ethereum"
	"github.com/ethereum/go-ethereum/accounts/abi"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/event"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = errors.New
	_ = big.NewInt
	_ = strings.NewReader
	_ = ethereum.NotFound
	_ = bind.Bind
	_ = common.Big1
	_ = types.BloomLookup
	_ = event.NewSubscription
)

// OneReadWriteVarMetaData contains all meta data concerning the OneReadWriteVar contract.
var OneReadWriteVarMetaData = &bind.MetaData{
	ABI: "[{\"inputs\":[{\"internalType\":\"address\",\"name\":\"readWriteAddr\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"key\",\"type\":\"uint256\"}],\"name\":\"oneGetVarMap\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"readWriteAddr\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"key\",\"type\":\"uint256\"}],\"name\":\"oneGetVarMapArray\",\"outputs\":[{\"internalType\":\"uint256[]\",\"name\":\"\",\"type\":\"uint256[]\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"readWriteAddr\",\"type\":\"address\"}],\"name\":\"oneGetVarString\",\"outputs\":[{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"readWriteAddr\",\"type\":\"address\"}],\"name\":\"oneGetVarStringArray\",\"outputs\":[{\"internalType\":\"string[]\",\"name\":\"\",\"type\":\"string[]\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"readWriteAddr\",\"type\":\"address\"}],\"name\":\"oneGetVarUint256\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"readWriteAddr\",\"type\":\"address\"}],\"name\":\"oneGetVarUintArray\",\"outputs\":[{\"internalType\":\"uint256[]\",\"name\":\"\",\"type\":\"uint256[]\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"readWriteAddr\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"key\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"value\",\"type\":\"uint256\"}],\"name\":\"onePushVarMapArray\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"readWriteAddr\",\"type\":\"address\"},{\"internalType\":\"string\",\"name\":\"value\",\"type\":\"string\"}],\"name\":\"onePushVarStringArray\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"readWriteAddr\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"value\",\"type\":\"uint256\"}],\"name\":\"onePushVarUintArray\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"readWriteAddr\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"key\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"value\",\"type\":\"uint256\"}],\"name\":\"oneSetVarMap\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"readWriteAddr\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"key\",\"type\":\"uint256\"},{\"internalType\":\"uint256[]\",\"name\":\"valueArr\",\"type\":\"uint256[]\"}],\"name\":\"oneSetVarMapArray\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"readWriteAddr\",\"type\":\"address\"},{\"internalType\":\"string\",\"name\":\"value\",\"type\":\"string\"}],\"name\":\"oneSetVarString\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"readWriteAddr\",\"type\":\"address\"},{\"internalType\":\"string[]\",\"name\":\"value\",\"type\":\"string[]\"}],\"name\":\"oneSetVarStringArray\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"readWriteAddr\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"value\",\"type\":\"uint256\"}],\"name\":\"oneSetVarUint256\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"readWriteAddr\",\"type\":\"address\"},{\"internalType\":\"uint256[]\",\"name\":\"value\",\"type\":\"uint256[]\"}],\"name\":\"oneSetVarUintArray\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"}]",
	Bin: "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",
}

// OneReadWriteVarABI is the input ABI used to generate the binding from.
// Deprecated: Use OneReadWriteVarMetaData.ABI instead.
var OneReadWriteVarABI = OneReadWriteVarMetaData.ABI

// OneReadWriteVarBin is the compiled bytecode used for deploying new contracts.
// Deprecated: Use OneReadWriteVarMetaData.Bin instead.
var OneReadWriteVarBin = OneReadWriteVarMetaData.Bin

// DeployOneReadWriteVar deploys a new Ethereum contract, binding an instance of OneReadWriteVar to it.
func DeployOneReadWriteVar(auth *bind.TransactOpts, backend bind.ContractBackend) (common.Address, *types.Transaction, *OneReadWriteVar, error) {
	parsed, err := OneReadWriteVarMetaData.GetAbi()
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	if parsed == nil {
		return common.Address{}, nil, nil, errors.New("GetABI returned nil")
	}

	address, tx, contract, err := bind.DeployContract(auth, *parsed, common.FromHex(OneReadWriteVarBin), backend)
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	return address, tx, &OneReadWriteVar{OneReadWriteVarCaller: OneReadWriteVarCaller{contract: contract}, OneReadWriteVarTransactor: OneReadWriteVarTransactor{contract: contract}, OneReadWriteVarFilterer: OneReadWriteVarFilterer{contract: contract}}, nil
}

// OneReadWriteVar is an auto generated Go binding around an Ethereum contract.
type OneReadWriteVar struct {
	OneReadWriteVarCaller     // Read-only binding to the contract
	OneReadWriteVarTransactor // Write-only binding to the contract
	OneReadWriteVarFilterer   // Log filterer for contract events
}

// OneReadWriteVarCaller is an auto generated read-only Go binding around an Ethereum contract.
type OneReadWriteVarCaller struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// OneReadWriteVarTransactor is an auto generated write-only Go binding around an Ethereum contract.
type OneReadWriteVarTransactor struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// OneReadWriteVarFilterer is an auto generated log filtering Go binding around an Ethereum contract events.
type OneReadWriteVarFilterer struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// OneReadWriteVarSession is an auto generated Go binding around an Ethereum contract,
// with pre-set call and transact options.
type OneReadWriteVarSession struct {
	Contract     *OneReadWriteVar  // Generic contract binding to set the session for
	CallOpts     bind.CallOpts     // Call options to use throughout this session
	TransactOpts bind.TransactOpts // Transaction auth options to use throughout this session
}

// OneReadWriteVarCallerSession is an auto generated read-only Go binding around an Ethereum contract,
// with pre-set call options.
type OneReadWriteVarCallerSession struct {
	Contract *OneReadWriteVarCaller // Generic contract caller binding to set the session for
	CallOpts bind.CallOpts          // Call options to use throughout this session
}

// OneReadWriteVarTransactorSession is an auto generated write-only Go binding around an Ethereum contract,
// with pre-set transact options.
type OneReadWriteVarTransactorSession struct {
	Contract     *OneReadWriteVarTransactor // Generic contract transactor binding to set the session for
	TransactOpts bind.TransactOpts          // Transaction auth options to use throughout this session
}

// OneReadWriteVarRaw is an auto generated low-level Go binding around an Ethereum contract.
type OneReadWriteVarRaw struct {
	Contract *OneReadWriteVar // Generic contract binding to access the raw methods on
}

// OneReadWriteVarCallerRaw is an auto generated low-level read-only Go binding around an Ethereum contract.
type OneReadWriteVarCallerRaw struct {
	Contract *OneReadWriteVarCaller // Generic read-only contract binding to access the raw methods on
}

// OneReadWriteVarTransactorRaw is an auto generated low-level write-only Go binding around an Ethereum contract.
type OneReadWriteVarTransactorRaw struct {
	Contract *OneReadWriteVarTransactor // Generic write-only contract binding to access the raw methods on
}

// NewOneReadWriteVar creates a new instance of OneReadWriteVar, bound to a specific deployed contract.
func NewOneReadWriteVar(address common.Address, backend bind.ContractBackend) (*OneReadWriteVar, error) {
	contract, err := bindOneReadWriteVar(address, backend, backend, backend)
	if err != nil {
		return nil, err
	}
	return &OneReadWriteVar{OneReadWriteVarCaller: OneReadWriteVarCaller{contract: contract}, OneReadWriteVarTransactor: OneReadWriteVarTransactor{contract: contract}, OneReadWriteVarFilterer: OneReadWriteVarFilterer{contract: contract}}, nil
}

// NewOneReadWriteVarCaller creates a new read-only instance of OneReadWriteVar, bound to a specific deployed contract.
func NewOneReadWriteVarCaller(address common.Address, caller bind.ContractCaller) (*OneReadWriteVarCaller, error) {
	contract, err := bindOneReadWriteVar(address, caller, nil, nil)
	if err != nil {
		return nil, err
	}
	return &OneReadWriteVarCaller{contract: contract}, nil
}

// NewOneReadWriteVarTransactor creates a new write-only instance of OneReadWriteVar, bound to a specific deployed contract.
func NewOneReadWriteVarTransactor(address common.Address, transactor bind.ContractTransactor) (*OneReadWriteVarTransactor, error) {
	contract, err := bindOneReadWriteVar(address, nil, transactor, nil)
	if err != nil {
		return nil, err
	}
	return &OneReadWriteVarTransactor{contract: contract}, nil
}

// NewOneReadWriteVarFilterer creates a new log filterer instance of OneReadWriteVar, bound to a specific deployed contract.
func NewOneReadWriteVarFilterer(address common.Address, filterer bind.ContractFilterer) (*OneReadWriteVarFilterer, error) {
	contract, err := bindOneReadWriteVar(address, nil, nil, filterer)
	if err != nil {
		return nil, err
	}
	return &OneReadWriteVarFilterer{contract: contract}, nil
}

// bindOneReadWriteVar binds a generic wrapper to an already deployed contract.
func bindOneReadWriteVar(address common.Address, caller bind.ContractCaller, transactor bind.ContractTransactor, filterer bind.ContractFilterer) (*bind.BoundContract, error) {
	parsed, err := abi.JSON(strings.NewReader(OneReadWriteVarABI))
	if err != nil {
		return nil, err
	}
	return bind.NewBoundContract(address, parsed, caller, transactor, filterer), nil
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_OneReadWriteVar *OneReadWriteVarRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _OneReadWriteVar.Contract.OneReadWriteVarCaller.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_OneReadWriteVar *OneReadWriteVarRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.OneReadWriteVarTransactor.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_OneReadWriteVar *OneReadWriteVarRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.OneReadWriteVarTransactor.contract.Transact(opts, method, params...)
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_OneReadWriteVar *OneReadWriteVarCallerRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _OneReadWriteVar.Contract.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_OneReadWriteVar *OneReadWriteVarTransactorRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_OneReadWriteVar *OneReadWriteVarTransactorRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.contract.Transact(opts, method, params...)
}

// OneGetVarMap is a free data retrieval call binding the contract method 0x130050a6.
//
// Solidity: function oneGetVarMap(address readWriteAddr, uint256 key) view returns(uint256)
func (_OneReadWriteVar *OneReadWriteVarCaller) OneGetVarMap(opts *bind.CallOpts, readWriteAddr common.Address, key *big.Int) (*big.Int, error) {
	var out []interface{}
	err := _OneReadWriteVar.contract.Call(opts, &out, "oneGetVarMap", readWriteAddr, key)

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// OneGetVarMap is a free data retrieval call binding the contract method 0x130050a6.
//
// Solidity: function oneGetVarMap(address readWriteAddr, uint256 key) view returns(uint256)
func (_OneReadWriteVar *OneReadWriteVarSession) OneGetVarMap(readWriteAddr common.Address, key *big.Int) (*big.Int, error) {
	return _OneReadWriteVar.Contract.OneGetVarMap(&_OneReadWriteVar.CallOpts, readWriteAddr, key)
}

// OneGetVarMap is a free data retrieval call binding the contract method 0x130050a6.
//
// Solidity: function oneGetVarMap(address readWriteAddr, uint256 key) view returns(uint256)
func (_OneReadWriteVar *OneReadWriteVarCallerSession) OneGetVarMap(readWriteAddr common.Address, key *big.Int) (*big.Int, error) {
	return _OneReadWriteVar.Contract.OneGetVarMap(&_OneReadWriteVar.CallOpts, readWriteAddr, key)
}

// OneGetVarMapArray is a free data retrieval call binding the contract method 0xd2ab52d5.
//
// Solidity: function oneGetVarMapArray(address readWriteAddr, uint256 key) view returns(uint256[])
func (_OneReadWriteVar *OneReadWriteVarCaller) OneGetVarMapArray(opts *bind.CallOpts, readWriteAddr common.Address, key *big.Int) ([]*big.Int, error) {
	var out []interface{}
	err := _OneReadWriteVar.contract.Call(opts, &out, "oneGetVarMapArray", readWriteAddr, key)

	if err != nil {
		return *new([]*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new([]*big.Int)).(*[]*big.Int)

	return out0, err

}

// OneGetVarMapArray is a free data retrieval call binding the contract method 0xd2ab52d5.
//
// Solidity: function oneGetVarMapArray(address readWriteAddr, uint256 key) view returns(uint256[])
func (_OneReadWriteVar *OneReadWriteVarSession) OneGetVarMapArray(readWriteAddr common.Address, key *big.Int) ([]*big.Int, error) {
	return _OneReadWriteVar.Contract.OneGetVarMapArray(&_OneReadWriteVar.CallOpts, readWriteAddr, key)
}

// OneGetVarMapArray is a free data retrieval call binding the contract method 0xd2ab52d5.
//
// Solidity: function oneGetVarMapArray(address readWriteAddr, uint256 key) view returns(uint256[])
func (_OneReadWriteVar *OneReadWriteVarCallerSession) OneGetVarMapArray(readWriteAddr common.Address, key *big.Int) ([]*big.Int, error) {
	return _OneReadWriteVar.Contract.OneGetVarMapArray(&_OneReadWriteVar.CallOpts, readWriteAddr, key)
}

// OneGetVarString is a free data retrieval call binding the contract method 0xe0f01609.
//
// Solidity: function oneGetVarString(address readWriteAddr) view returns(string)
func (_OneReadWriteVar *OneReadWriteVarCaller) OneGetVarString(opts *bind.CallOpts, readWriteAddr common.Address) (string, error) {
	var out []interface{}
	err := _OneReadWriteVar.contract.Call(opts, &out, "oneGetVarString", readWriteAddr)

	if err != nil {
		return *new(string), err
	}

	out0 := *abi.ConvertType(out[0], new(string)).(*string)

	return out0, err

}

// OneGetVarString is a free data retrieval call binding the contract method 0xe0f01609.
//
// Solidity: function oneGetVarString(address readWriteAddr) view returns(string)
func (_OneReadWriteVar *OneReadWriteVarSession) OneGetVarString(readWriteAddr common.Address) (string, error) {
	return _OneReadWriteVar.Contract.OneGetVarString(&_OneReadWriteVar.CallOpts, readWriteAddr)
}

// OneGetVarString is a free data retrieval call binding the contract method 0xe0f01609.
//
// Solidity: function oneGetVarString(address readWriteAddr) view returns(string)
func (_OneReadWriteVar *OneReadWriteVarCallerSession) OneGetVarString(readWriteAddr common.Address) (string, error) {
	return _OneReadWriteVar.Contract.OneGetVarString(&_OneReadWriteVar.CallOpts, readWriteAddr)
}

// OneGetVarStringArray is a free data retrieval call binding the contract method 0xe3a0f8b2.
//
// Solidity: function oneGetVarStringArray(address readWriteAddr) view returns(string[])
func (_OneReadWriteVar *OneReadWriteVarCaller) OneGetVarStringArray(opts *bind.CallOpts, readWriteAddr common.Address) ([]string, error) {
	var out []interface{}
	err := _OneReadWriteVar.contract.Call(opts, &out, "oneGetVarStringArray", readWriteAddr)

	if err != nil {
		return *new([]string), err
	}

	out0 := *abi.ConvertType(out[0], new([]string)).(*[]string)

	return out0, err

}

// OneGetVarStringArray is a free data retrieval call binding the contract method 0xe3a0f8b2.
//
// Solidity: function oneGetVarStringArray(address readWriteAddr) view returns(string[])
func (_OneReadWriteVar *OneReadWriteVarSession) OneGetVarStringArray(readWriteAddr common.Address) ([]string, error) {
	return _OneReadWriteVar.Contract.OneGetVarStringArray(&_OneReadWriteVar.CallOpts, readWriteAddr)
}

// OneGetVarStringArray is a free data retrieval call binding the contract method 0xe3a0f8b2.
//
// Solidity: function oneGetVarStringArray(address readWriteAddr) view returns(string[])
func (_OneReadWriteVar *OneReadWriteVarCallerSession) OneGetVarStringArray(readWriteAddr common.Address) ([]string, error) {
	return _OneReadWriteVar.Contract.OneGetVarStringArray(&_OneReadWriteVar.CallOpts, readWriteAddr)
}

// OneGetVarUint256 is a free data retrieval call binding the contract method 0x650793f8.
//
// Solidity: function oneGetVarUint256(address readWriteAddr) view returns(uint256)
func (_OneReadWriteVar *OneReadWriteVarCaller) OneGetVarUint256(opts *bind.CallOpts, readWriteAddr common.Address) (*big.Int, error) {
	var out []interface{}
	err := _OneReadWriteVar.contract.Call(opts, &out, "oneGetVarUint256", readWriteAddr)

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// OneGetVarUint256 is a free data retrieval call binding the contract method 0x650793f8.
//
// Solidity: function oneGetVarUint256(address readWriteAddr) view returns(uint256)
func (_OneReadWriteVar *OneReadWriteVarSession) OneGetVarUint256(readWriteAddr common.Address) (*big.Int, error) {
	return _OneReadWriteVar.Contract.OneGetVarUint256(&_OneReadWriteVar.CallOpts, readWriteAddr)
}

// OneGetVarUint256 is a free data retrieval call binding the contract method 0x650793f8.
//
// Solidity: function oneGetVarUint256(address readWriteAddr) view returns(uint256)
func (_OneReadWriteVar *OneReadWriteVarCallerSession) OneGetVarUint256(readWriteAddr common.Address) (*big.Int, error) {
	return _OneReadWriteVar.Contract.OneGetVarUint256(&_OneReadWriteVar.CallOpts, readWriteAddr)
}

// OneGetVarUintArray is a free data retrieval call binding the contract method 0x19c8da24.
//
// Solidity: function oneGetVarUintArray(address readWriteAddr) view returns(uint256[])
func (_OneReadWriteVar *OneReadWriteVarCaller) OneGetVarUintArray(opts *bind.CallOpts, readWriteAddr common.Address) ([]*big.Int, error) {
	var out []interface{}
	err := _OneReadWriteVar.contract.Call(opts, &out, "oneGetVarUintArray", readWriteAddr)

	if err != nil {
		return *new([]*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new([]*big.Int)).(*[]*big.Int)

	return out0, err

}

// OneGetVarUintArray is a free data retrieval call binding the contract method 0x19c8da24.
//
// Solidity: function oneGetVarUintArray(address readWriteAddr) view returns(uint256[])
func (_OneReadWriteVar *OneReadWriteVarSession) OneGetVarUintArray(readWriteAddr common.Address) ([]*big.Int, error) {
	return _OneReadWriteVar.Contract.OneGetVarUintArray(&_OneReadWriteVar.CallOpts, readWriteAddr)
}

// OneGetVarUintArray is a free data retrieval call binding the contract method 0x19c8da24.
//
// Solidity: function oneGetVarUintArray(address readWriteAddr) view returns(uint256[])
func (_OneReadWriteVar *OneReadWriteVarCallerSession) OneGetVarUintArray(readWriteAddr common.Address) ([]*big.Int, error) {
	return _OneReadWriteVar.Contract.OneGetVarUintArray(&_OneReadWriteVar.CallOpts, readWriteAddr)
}

// OnePushVarMapArray is a paid mutator transaction binding the contract method 0xf8a9c655.
//
// Solidity: function onePushVarMapArray(address readWriteAddr, uint256 key, uint256 value) returns()
func (_OneReadWriteVar *OneReadWriteVarTransactor) OnePushVarMapArray(opts *bind.TransactOpts, readWriteAddr common.Address, key *big.Int, value *big.Int) (*types.Transaction, error) {
	return _OneReadWriteVar.contract.Transact(opts, "onePushVarMapArray", readWriteAddr, key, value)
}

// OnePushVarMapArray is a paid mutator transaction binding the contract method 0xf8a9c655.
//
// Solidity: function onePushVarMapArray(address readWriteAddr, uint256 key, uint256 value) returns()
func (_OneReadWriteVar *OneReadWriteVarSession) OnePushVarMapArray(readWriteAddr common.Address, key *big.Int, value *big.Int) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.OnePushVarMapArray(&_OneReadWriteVar.TransactOpts, readWriteAddr, key, value)
}

// OnePushVarMapArray is a paid mutator transaction binding the contract method 0xf8a9c655.
//
// Solidity: function onePushVarMapArray(address readWriteAddr, uint256 key, uint256 value) returns()
func (_OneReadWriteVar *OneReadWriteVarTransactorSession) OnePushVarMapArray(readWriteAddr common.Address, key *big.Int, value *big.Int) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.OnePushVarMapArray(&_OneReadWriteVar.TransactOpts, readWriteAddr, key, value)
}

// OnePushVarStringArray is a paid mutator transaction binding the contract method 0xd991a629.
//
// Solidity: function onePushVarStringArray(address readWriteAddr, string value) returns()
func (_OneReadWriteVar *OneReadWriteVarTransactor) OnePushVarStringArray(opts *bind.TransactOpts, readWriteAddr common.Address, value string) (*types.Transaction, error) {
	return _OneReadWriteVar.contract.Transact(opts, "onePushVarStringArray", readWriteAddr, value)
}

// OnePushVarStringArray is a paid mutator transaction binding the contract method 0xd991a629.
//
// Solidity: function onePushVarStringArray(address readWriteAddr, string value) returns()
func (_OneReadWriteVar *OneReadWriteVarSession) OnePushVarStringArray(readWriteAddr common.Address, value string) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.OnePushVarStringArray(&_OneReadWriteVar.TransactOpts, readWriteAddr, value)
}

// OnePushVarStringArray is a paid mutator transaction binding the contract method 0xd991a629.
//
// Solidity: function onePushVarStringArray(address readWriteAddr, string value) returns()
func (_OneReadWriteVar *OneReadWriteVarTransactorSession) OnePushVarStringArray(readWriteAddr common.Address, value string) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.OnePushVarStringArray(&_OneReadWriteVar.TransactOpts, readWriteAddr, value)
}

// OnePushVarUintArray is a paid mutator transaction binding the contract method 0x5fcbac6b.
//
// Solidity: function onePushVarUintArray(address readWriteAddr, uint256 value) returns()
func (_OneReadWriteVar *OneReadWriteVarTransactor) OnePushVarUintArray(opts *bind.TransactOpts, readWriteAddr common.Address, value *big.Int) (*types.Transaction, error) {
	return _OneReadWriteVar.contract.Transact(opts, "onePushVarUintArray", readWriteAddr, value)
}

// OnePushVarUintArray is a paid mutator transaction binding the contract method 0x5fcbac6b.
//
// Solidity: function onePushVarUintArray(address readWriteAddr, uint256 value) returns()
func (_OneReadWriteVar *OneReadWriteVarSession) OnePushVarUintArray(readWriteAddr common.Address, value *big.Int) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.OnePushVarUintArray(&_OneReadWriteVar.TransactOpts, readWriteAddr, value)
}

// OnePushVarUintArray is a paid mutator transaction binding the contract method 0x5fcbac6b.
//
// Solidity: function onePushVarUintArray(address readWriteAddr, uint256 value) returns()
func (_OneReadWriteVar *OneReadWriteVarTransactorSession) OnePushVarUintArray(readWriteAddr common.Address, value *big.Int) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.OnePushVarUintArray(&_OneReadWriteVar.TransactOpts, readWriteAddr, value)
}

// OneSetVarMap is a paid mutator transaction binding the contract method 0x91a08da8.
//
// Solidity: function oneSetVarMap(address readWriteAddr, uint256 key, uint256 value) returns()
func (_OneReadWriteVar *OneReadWriteVarTransactor) OneSetVarMap(opts *bind.TransactOpts, readWriteAddr common.Address, key *big.Int, value *big.Int) (*types.Transaction, error) {
	return _OneReadWriteVar.contract.Transact(opts, "oneSetVarMap", readWriteAddr, key, value)
}

// OneSetVarMap is a paid mutator transaction binding the contract method 0x91a08da8.
//
// Solidity: function oneSetVarMap(address readWriteAddr, uint256 key, uint256 value) returns()
func (_OneReadWriteVar *OneReadWriteVarSession) OneSetVarMap(readWriteAddr common.Address, key *big.Int, value *big.Int) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.OneSetVarMap(&_OneReadWriteVar.TransactOpts, readWriteAddr, key, value)
}

// OneSetVarMap is a paid mutator transaction binding the contract method 0x91a08da8.
//
// Solidity: function oneSetVarMap(address readWriteAddr, uint256 key, uint256 value) returns()
func (_OneReadWriteVar *OneReadWriteVarTransactorSession) OneSetVarMap(readWriteAddr common.Address, key *big.Int, value *big.Int) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.OneSetVarMap(&_OneReadWriteVar.TransactOpts, readWriteAddr, key, value)
}

// OneSetVarMapArray is a paid mutator transaction binding the contract method 0x5c947f9c.
//
// Solidity: function oneSetVarMapArray(address readWriteAddr, uint256 key, uint256[] valueArr) returns()
func (_OneReadWriteVar *OneReadWriteVarTransactor) OneSetVarMapArray(opts *bind.TransactOpts, readWriteAddr common.Address, key *big.Int, valueArr []*big.Int) (*types.Transaction, error) {
	return _OneReadWriteVar.contract.Transact(opts, "oneSetVarMapArray", readWriteAddr, key, valueArr)
}

// OneSetVarMapArray is a paid mutator transaction binding the contract method 0x5c947f9c.
//
// Solidity: function oneSetVarMapArray(address readWriteAddr, uint256 key, uint256[] valueArr) returns()
func (_OneReadWriteVar *OneReadWriteVarSession) OneSetVarMapArray(readWriteAddr common.Address, key *big.Int, valueArr []*big.Int) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.OneSetVarMapArray(&_OneReadWriteVar.TransactOpts, readWriteAddr, key, valueArr)
}

// OneSetVarMapArray is a paid mutator transaction binding the contract method 0x5c947f9c.
//
// Solidity: function oneSetVarMapArray(address readWriteAddr, uint256 key, uint256[] valueArr) returns()
func (_OneReadWriteVar *OneReadWriteVarTransactorSession) OneSetVarMapArray(readWriteAddr common.Address, key *big.Int, valueArr []*big.Int) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.OneSetVarMapArray(&_OneReadWriteVar.TransactOpts, readWriteAddr, key, valueArr)
}

// OneSetVarString is a paid mutator transaction binding the contract method 0x72da1fb5.
//
// Solidity: function oneSetVarString(address readWriteAddr, string value) returns()
func (_OneReadWriteVar *OneReadWriteVarTransactor) OneSetVarString(opts *bind.TransactOpts, readWriteAddr common.Address, value string) (*types.Transaction, error) {
	return _OneReadWriteVar.contract.Transact(opts, "oneSetVarString", readWriteAddr, value)
}

// OneSetVarString is a paid mutator transaction binding the contract method 0x72da1fb5.
//
// Solidity: function oneSetVarString(address readWriteAddr, string value) returns()
func (_OneReadWriteVar *OneReadWriteVarSession) OneSetVarString(readWriteAddr common.Address, value string) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.OneSetVarString(&_OneReadWriteVar.TransactOpts, readWriteAddr, value)
}

// OneSetVarString is a paid mutator transaction binding the contract method 0x72da1fb5.
//
// Solidity: function oneSetVarString(address readWriteAddr, string value) returns()
func (_OneReadWriteVar *OneReadWriteVarTransactorSession) OneSetVarString(readWriteAddr common.Address, value string) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.OneSetVarString(&_OneReadWriteVar.TransactOpts, readWriteAddr, value)
}

// OneSetVarStringArray is a paid mutator transaction binding the contract method 0x62b529ce.
//
// Solidity: function oneSetVarStringArray(address readWriteAddr, string[] value) returns()
func (_OneReadWriteVar *OneReadWriteVarTransactor) OneSetVarStringArray(opts *bind.TransactOpts, readWriteAddr common.Address, value []string) (*types.Transaction, error) {
	return _OneReadWriteVar.contract.Transact(opts, "oneSetVarStringArray", readWriteAddr, value)
}

// OneSetVarStringArray is a paid mutator transaction binding the contract method 0x62b529ce.
//
// Solidity: function oneSetVarStringArray(address readWriteAddr, string[] value) returns()
func (_OneReadWriteVar *OneReadWriteVarSession) OneSetVarStringArray(readWriteAddr common.Address, value []string) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.OneSetVarStringArray(&_OneReadWriteVar.TransactOpts, readWriteAddr, value)
}

// OneSetVarStringArray is a paid mutator transaction binding the contract method 0x62b529ce.
//
// Solidity: function oneSetVarStringArray(address readWriteAddr, string[] value) returns()
func (_OneReadWriteVar *OneReadWriteVarTransactorSession) OneSetVarStringArray(readWriteAddr common.Address, value []string) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.OneSetVarStringArray(&_OneReadWriteVar.TransactOpts, readWriteAddr, value)
}

// OneSetVarUint256 is a paid mutator transaction binding the contract method 0xec2df307.
//
// Solidity: function oneSetVarUint256(address readWriteAddr, uint256 value) returns()
func (_OneReadWriteVar *OneReadWriteVarTransactor) OneSetVarUint256(opts *bind.TransactOpts, readWriteAddr common.Address, value *big.Int) (*types.Transaction, error) {
	return _OneReadWriteVar.contract.Transact(opts, "oneSetVarUint256", readWriteAddr, value)
}

// OneSetVarUint256 is a paid mutator transaction binding the contract method 0xec2df307.
//
// Solidity: function oneSetVarUint256(address readWriteAddr, uint256 value) returns()
func (_OneReadWriteVar *OneReadWriteVarSession) OneSetVarUint256(readWriteAddr common.Address, value *big.Int) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.OneSetVarUint256(&_OneReadWriteVar.TransactOpts, readWriteAddr, value)
}

// OneSetVarUint256 is a paid mutator transaction binding the contract method 0xec2df307.
//
// Solidity: function oneSetVarUint256(address readWriteAddr, uint256 value) returns()
func (_OneReadWriteVar *OneReadWriteVarTransactorSession) OneSetVarUint256(readWriteAddr common.Address, value *big.Int) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.OneSetVarUint256(&_OneReadWriteVar.TransactOpts, readWriteAddr, value)
}

// OneSetVarUintArray is a paid mutator transaction binding the contract method 0xfe32cb02.
//
// Solidity: function oneSetVarUintArray(address readWriteAddr, uint256[] value) returns()
func (_OneReadWriteVar *OneReadWriteVarTransactor) OneSetVarUintArray(opts *bind.TransactOpts, readWriteAddr common.Address, value []*big.Int) (*types.Transaction, error) {
	return _OneReadWriteVar.contract.Transact(opts, "oneSetVarUintArray", readWriteAddr, value)
}

// OneSetVarUintArray is a paid mutator transaction binding the contract method 0xfe32cb02.
//
// Solidity: function oneSetVarUintArray(address readWriteAddr, uint256[] value) returns()
func (_OneReadWriteVar *OneReadWriteVarSession) OneSetVarUintArray(readWriteAddr common.Address, value []*big.Int) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.OneSetVarUintArray(&_OneReadWriteVar.TransactOpts, readWriteAddr, value)
}

// OneSetVarUintArray is a paid mutator transaction binding the contract method 0xfe32cb02.
//
// Solidity: function oneSetVarUintArray(address readWriteAddr, uint256[] value) returns()
func (_OneReadWriteVar *OneReadWriteVarTransactorSession) OneSetVarUintArray(readWriteAddr common.Address, value []*big.Int) (*types.Transaction, error) {
	return _OneReadWriteVar.Contract.OneSetVarUintArray(&_OneReadWriteVar.TransactOpts, readWriteAddr, value)
}
