// SPDX-License-Identifier: UNLICENSED
pragma solidity ^0.8.9;

import "../../interface/IReadWriteVar.sol";

contract OneReadWriteVar {
    function oneSetVarMap(
        address readWriteAddr,
        uint256 key,
        uint256 value
    ) external {
        IReadWriteVar(readWriteAddr).setVarMap(key, value);
    }

    function oneGetVarMap(
        address readWriteAddr,
        uint256 key
    ) external view returns (uint256) {
        return IReadWriteVar(readWriteAddr).getVarMap(key);
    }

    function onePushVarMapArray(
        address readWriteAddr,
        uint256 key,
        uint256 value
    ) external {
        IReadWriteVar(readWriteAddr).pushVarMapArray(key, value);
    }

    function oneGetVarMapArray(
        address readWriteAddr,
        uint256 key
    ) external view returns (uint256[] memory) {
        return IReadWriteVar(readWriteAddr).getVarMapArray(key);
    }

    function oneSetVarMapArray(
        address readWriteAddr,
        uint256 key,
        uint256[] memory valueArr
    ) external {
        IReadWriteVar(readWriteAddr).setVarMapArray(key, valueArr);
    }

    function onePushVarUintArray(
        address readWriteAddr,
        uint256 value
    ) external {
        IReadWriteVar(readWriteAddr).pushVarUintArray(value);
    }

    function oneSetVarUintArray(
        address readWriteAddr,
        uint256[] memory value
    ) external {
        IReadWriteVar(readWriteAddr).setVarUintArray(value);
    }

    function oneGetVarUintArray(
        address readWriteAddr
    ) external view returns (uint256[] memory) {
        return IReadWriteVar(readWriteAddr).getVarUintArray();
    }

    function onePushVarStringArray(
        address readWriteAddr,
        string memory value
    ) external {
        IReadWriteVar(readWriteAddr).pushVarStringArray(value);
    }

    function oneSetVarStringArray(
        address readWriteAddr,
        string[] memory value
    ) external {
        IReadWriteVar(readWriteAddr).setVarStringArray(value);
    }

    function oneGetVarStringArray(
        address readWriteAddr
    ) external view returns (string[] memory) {
        return IReadWriteVar(readWriteAddr).getVarStringArray();
    }

    function oneSetVarUint256(address readWriteAddr, uint256 value) external {
        IReadWriteVar(readWriteAddr).setVarUint256(value);
    }

    function oneGetVarUint256(
        address readWriteAddr
    ) external view returns (uint256) {
        return IReadWriteVar(readWriteAddr).getVarUint256();
    }

    function oneSetVarString(
        address readWriteAddr,
        string memory value
    ) external {
        IReadWriteVar(readWriteAddr).setVarString(value);
    }

    function oneGetVarString(
        address readWriteAddr
    ) external view returns (string memory) {
        return IReadWriteVar(readWriteAddr).getVarString();
    }
}
