package coin

import (
	contractCoin "contract-case/contract_abi/coin_transfer/compile"
	"contract-case/log"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"math/big"
)

type ContractCoinOneTrade struct {
	ChainContractAdr common.Address
	ToAddr           []common.Address
	Amount           *big.Int
}

func (trade *ContractCoinOneTrade) OneTransferSetTempSignTx(tranOpts *bind.TransactOpts, oneChainCoinTransfer *contractCoin.OneChainCoinTransfer) (*types.Transaction, error) {
	oneTransferTx, err := oneChainCoinTransfer.SetChainCoinTransferContract(tranOpts, trade.ChainContractAdr)
	if err != nil {
		log.Errorf("OneTransferSignTx func SetChainCoinTransferContract tx error: %s", err)
		return nil, err
	}
	log.Info("OneTransfer:", oneTransferTx.Hash())
	return oneTransferTx, nil
}

func (trade *ContractCoinOneTrade) OneTransferSetAfterSignTx(tranOpts *bind.TransactOpts, oneChainCoinTransfer *contractCoin.OneChainCoinTransfer) (*types.Transaction, error) {
	oneTransferTx, err := oneChainCoinTransfer.OneTempTransfer(tranOpts, trade.ToAddr, trade.Amount)
	if err != nil {
		log.Errorf("OneTransferSignTx func OneTempTransfer tx error: %s", err)
		return nil, err
	}
	log.Info("OneTransfer:", oneTransferTx.Hash())
	return oneTransferTx, nil
}

func (trade *ContractCoinOneTrade) OneTransferSignTx(tranOpts *bind.TransactOpts, oneChainCoinTransfer *contractCoin.OneChainCoinTransfer) (*types.Transaction, error) {
	oneTransferTx, err := oneChainCoinTransfer.OneTransfer(tranOpts, trade.ChainContractAdr, trade.ToAddr, trade.Amount)
	if err != nil {
		log.Errorf("OneTransferSignTx func oneTransfer tx error: %s", err)
		return nil, err
	}
	log.Info("OneTransfer:", oneTransferTx.Hash())
	return oneTransferTx, nil
}
