package contractErc20

import (
	contractToken20 "contract-case/contract_abi/erc20_transfer/compile"
	"contract-case/log"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"math/big"
)

type Erc20Trade struct {
	Erc20Addr common.Address
	FromAddr  common.Address
	ToAddr    []common.Address
	Amount    *big.Int
}

func (trade *Erc20Trade) Erc20TransferSignTx(tranOpts *bind.TransactOpts, tokenTransfer *contractToken20.TokenTransfer) (*types.Transaction, error) {
	tokenTransferTx, err := tokenTransfer.TokenTransfer(tranOpts, trade.Erc20Addr, trade.ToAddr, trade.Amount)
	if err != nil {
		log.Errorf("Constructor tokenTransfer tx error: %s", err)
		return nil, err
	}
	log.Info("tokenTransfer:", tokenTransferTx.Hash())
	return tokenTransferTx, nil
}

func (trade *Erc20Trade) Erc20TransferFromSignTx(tranOpts *bind.TransactOpts, tokenTransfer *contractToken20.TokenTransfer) (*types.Transaction, error) {
	tokenTransferFromTx, err := tokenTransfer.TokenTransferFrom(tranOpts, trade.Erc20Addr, trade.FromAddr, trade.ToAddr[0], trade.Amount)
	if err != nil {
		log.Errorf("Constructor TokenTransferFrom tx error: %s", err)
		return nil, err
	}
	log.Info("tokenTransferFromTx:", tokenTransferFromTx.Hash())
	return tokenTransferFromTx, nil
}
