package readWrite

import (
	contractReadWrite "contract-case/contract_abi/read_write/compile"
	"contract-case/log"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/core/types"
	"math/big"
)

type ReadWriteTrade struct {
	KeyParam       *big.Int
	ValueParam     *big.Int
	StringParam    string
	UintParam      *big.Int
	ValueArrParam  []*big.Int
	StringArrParam []string
}

func (trade *ReadWriteTrade) ReadWriteSignTxPushVarMapArray(tranOpts *bind.TransactOpts, transfer *contractReadWrite.ReadWriteVar) (*types.Transaction, error) {
	pushVarMapArrayTx, err := transfer.PushVarMapArray(tranOpts, trade.KeyParam, trade.ValueParam)
	if err != nil {
		log.Errorf("ReadWriteSignTxPushVarMapArray func pushVarMapArrayTx tx error: %s", err)
		return nil, err
	}
	log.Info("pushVarMapArrayTx:", pushVarMapArrayTx.Hash())
	return pushVarMapArrayTx, nil
}

func (trade *ReadWriteTrade) ReadWriteSignTxPushVarStringArray(tranOpts *bind.TransactOpts, transfer *contractReadWrite.ReadWriteVar) (*types.Transaction, error) {
	pushVarStringArrayTx, err := transfer.PushVarStringArray(tranOpts, trade.StringParam)
	if err != nil {
		log.Errorf("ReadWriteSignTxPushVarStringArray func pushVarStringArrayTx tx error: %s", err)
		return nil, err
	}
	log.Info("pushVarStringArrayTx:", pushVarStringArrayTx.Hash())
	return pushVarStringArrayTx, nil
}

func (trade *ReadWriteTrade) ReadWriteSignTxPushVarUintArray(tranOpts *bind.TransactOpts, transfer *contractReadWrite.ReadWriteVar) (*types.Transaction, error) {
	pushVarUintArrayTx, err := transfer.PushVarUintArray(tranOpts, trade.UintParam)
	if err != nil {
		log.Errorf("ReadWriteSignTxPushVarUintArray func PushVarUintArray tx error: %s", err)
		return nil, err
	}
	log.Info("pushVarUintArrayTx:", pushVarUintArrayTx.Hash())
	return pushVarUintArrayTx, nil
}

func (trade *ReadWriteTrade) ReadWriteSignTxSetVarString(tranOpts *bind.TransactOpts, transfer *contractReadWrite.ReadWriteVar) (*types.Transaction, error) {
	setVarStringTx, err := transfer.SetVarString(tranOpts, trade.StringParam)
	if err != nil {
		log.Errorf("ReadWriteSignTxSetVarString func SetVarString tx error: %s", err)
		return nil, err
	}
	log.Info("setVarStringTx:", setVarStringTx.Hash())
	return setVarStringTx, nil
}

func (trade *ReadWriteTrade) ReadWriteSignTxSetVarMap(tranOpts *bind.TransactOpts, transfer *contractReadWrite.ReadWriteVar) (*types.Transaction, error) {
	SetVarMapTx, err := transfer.SetVarMap(tranOpts, trade.KeyParam, trade.ValueParam)
	if err != nil {
		log.Errorf("ReadWriteSignTxSetVarMap func SetVarMap tx error: %s", err)
		return nil, err
	}
	log.Info("pushVarMapArrayTx:", SetVarMapTx.Hash())
	return SetVarMapTx, nil
}

func (trade *ReadWriteTrade) ReadWriteSignTxSetVarMapArray(tranOpts *bind.TransactOpts, transfer *contractReadWrite.ReadWriteVar) (*types.Transaction, error) {
	SetVarMapArrayTx, err := transfer.SetVarMapArray(tranOpts, trade.KeyParam, trade.ValueArrParam)
	if err != nil {
		log.Errorf("ReadWriteSignTxSetVarMapArray func SetVarMapArray tx error: %s", err)
		return nil, err
	}
	log.Info("SetVarMapArrayTx:", SetVarMapArrayTx.Hash())
	return SetVarMapArrayTx, nil
}

func (trade *ReadWriteTrade) ReadWriteSignTxSetVarUint256(tranOpts *bind.TransactOpts, transfer *contractReadWrite.ReadWriteVar) (*types.Transaction, error) {
	setVarUint256Tx, err := transfer.SetVarUint256(tranOpts, trade.UintParam)
	if err != nil {
		log.Errorf("ReadWriteSignTxSetVarUint256 func SetVarUint256 tx error: %s", err)
		return nil, err
	}
	log.Info("setVarUint256Tx:", setVarUint256Tx.Hash())
	return setVarUint256Tx, nil
}

func (trade *ReadWriteTrade) ReadWriteSignTxSetVarStringArray(tranOpts *bind.TransactOpts, transfer *contractReadWrite.ReadWriteVar) (*types.Transaction, error) {
	SetVarStringArrayTx, err := transfer.SetVarStringArray(tranOpts, trade.StringArrParam)
	if err != nil {
		log.Errorf("ReadWriteSignTxSetVarStringArray func SetVarStringArray tx error: %s", err)
		return nil, err
	}
	log.Info("SetVarStringArrayTx:", SetVarStringArrayTx.Hash())
	return SetVarStringArrayTx, nil
}

func (trade *ReadWriteTrade) ReadWriteSignTxSetVarUintArray(tranOpts *bind.TransactOpts, transfer *contractReadWrite.ReadWriteVar) (*types.Transaction, error) {
	SetVarUintArrayTx, err := transfer.SetVarUintArray(tranOpts, trade.ValueArrParam)
	if err != nil {
		log.Errorf("ReadWriteSignTxSetVarUintArray func SetVarUintArray tx error: %s", err)
		return nil, err
	}
	log.Info("SetVarUintArrayTx:", SetVarUintArrayTx.Hash())
	return SetVarUintArrayTx, nil
}
