package util

import (
	"contract-case/log"
	"crypto/ecdsa"
	"github.com/ethereum/go-ethereum/core/types"
	"math/big"
)

func SignNewTx(tx types.TxData, chainId *big.Int, prv *ecdsa.PrivateKey) (*types.Transaction, error) {
	signedTx, err := types.SignNewTx(prv, types.NewEIP155Signer(chainId), tx)
	if err != nil {
		log.Errorf("Sign tx error:", err)
		return nil, err
	}
	return signedTx, nil
}
