package contractErc721

import (
	erc721 "contract-case/contract_abi/erc721_transfer/compile"
	"contract-case/log"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"math/big"
)

type Erc721Trade struct {
	Erc721Addr common.Address
	FromAddr   common.Address
	ToAddr     common.Address
	TokenId    *big.Int
}

func (trade *Erc721Trade) Erc721TransferFromSignTx(tranOpts *bind.TransactOpts, transfer *erc721.NftTokenTransfer) (*types.Transaction, error) {
	transferFromTx, err := transfer.TransferFrom(tranOpts, trade.Erc721Addr, trade.FromAddr, trade.ToAddr, trade.TokenId)
	if err != nil {
		log.Errorf("Erc721TransferFromSignTx func TransferFrom tx error: %s", err)
		return nil, err
	}
	log.Info("transferFromTx:", transferFromTx.Hash())
	return transferFromTx, nil
}
