package main

import (
	"contract-case/log"
	"contract-case/operator"
	"contract-case/tool"
	"contract-case/util"
	"github.com/ethereum/go-ethereum/core/types"
)

func main() {
	log.InitLog(log.LogConfig{Path: "logs", Level: "debug", Save: 3})
	txArr := make([]*types.Transaction, 0)
	verifyFuncArr := make([]func() bool, 0)

	// 部署合约
	if tool.Cfg.IsDeployContract {
		txArr = operator.DeployContract(tool.Cfg.RpcNode, txArr)
	}

	// 初始化From账户以及合约账户
	if tool.Cfg.IsInitAccountBalance {
		txArr = operator.InitCaseAccount(tool.Cfg.RpcNode, txArr)
	}

	// 转账交易case
	if len(tool.Cfg.TransferType) != 0 {
		accIndex := 12
		nonceMap := util.GetAccountNonce(tool.Cfg.RpcNode)
		arrFormat := tool.ParseAccountConfig("./config/account.json")
		parseContractConfig := tool.ParseContractConfig("./config/contractConfig.json")
		for _, caseType := range tool.Cfg.TransferType {
			tranList, verifyFunc := operator.GetTranFunc(caseType, accIndex, 2, nonceMap, arrFormat, tool.Cfg.RpcNode, parseContractConfig)
			txArr = append(txArr, tranList...)
			verifyFuncArr = append(verifyFuncArr, verifyFunc)
			accIndex += 2
		}
	}

	// 发送整合后的交易
	if len(txArr) > 0 {
		operator.SendTransaction(txArr)
		util.GetTxReceipt(tool.Cfg.RpcNode, txArr)
		for _, vf := range verifyFuncArr {
			if !vf() {
				log.Error("Verify failed")
			}
		}
	}

	util.GetAccountBalance(tool.Cfg.RpcNode)
}
