package main

import (
	"context"
	erc20 "contract-case/contract_abi/erc20_transfer/compile"
	erc721 "contract-case/contract_abi/erc721_transfer/compile"
	"contract-case/log"
	"fmt"
	"github.com/ethereum/go-ethereum/accounts/abi"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/ethclient"
	"math/big"
	"strings"
	"testing"
)

func TestGetContractAbi(t *testing.T) {
	// 连接以太坊网络
	client, err := ethclient.Dial("http://15.161.177.5:26658")
	if err != nil {
		log.Fatal(err)
	}

	// 从合约地址获取合约代码
	contractAddress := common.HexToAddress("0xacea4c028c233e5d896b5ea28eb1c24d64b937e2")

	code, err := client.CodeAt(context.Background(), contractAddress, nil)
	if err != nil {
		log.Fatal("get contract code err:", err)
	}

	balance, err := client.BalanceAt(context.Background(), contractAddress, nil)
	if err != nil {
		log.Fatal("Get account balance err:", err.Error())
	}
	log.Info("balance:", balance.String())

	// 解析ABI
	contractAbi, err := abi.JSON(strings.NewReader(string(code)))
	if err != nil {
		log.Fatal(err)
	}

	// 打印ABI信息
	fmt.Println(contractAbi.Methods)
}

func TestGetErc20Balance(t *testing.T) {
	// 连接以太坊网络
	client, err := ethclient.Dial("http://54.72.101.87:50000")
	if err != nil {
		log.Fatal(err)
	}
	// 从合约地址获取合约代码
	contractAddress := common.HexToAddress("0x14f2567347beb8ed0fec95397940f17ef7a94541")
	accountAddr := common.HexToAddress("0x812D866f7f558A7325c16B729286e0e661b9DB36")

	newERC20, err := erc20.NewERC20(contractAddress, client)
	if err != nil {
		return
	}
	of, err := newERC20.BalanceOf(&bind.CallOpts{}, accountAddr)
	if err != nil {
		return
	}
	log.Info("balance is :", of.String())
}

func TestGetErc721Balance(t *testing.T) {
	// 连接以太坊网络
	client, err := ethclient.Dial("http://15.161.177.5:26658")
	if err != nil {
		log.Fatal(err)
	}
	// 从合约地址获取合约代码
	contractAddress := common.HexToAddress("0x450260F10b2D55b785037388fA3aA3b2232cC9F4")
	accountAddr := common.HexToAddress("0x40EC4256fcBCA69CdbAc942594caeC79FBE10494")

	newERC721, err := erc721.NewERC721(contractAddress, client)
	if err != nil {
		return
	}
	of, err := newERC721.BalanceOf(&bind.CallOpts{}, accountAddr)
	if err != nil {
		return
	}
	log.Info("balance is :", of.String())
}

func TestBigIntFunc(t *testing.T) {

	//amount := big.NewInt(10000000000)

	mul := big.NewInt(1).Mul(big.NewInt(10000000000000000), big.NewInt(2))

	t.Log("amount:", mul.String())

}
