// SPDX-License-Identifier: MIT
pragma solidity ^0.8.9;

import "../../interface/IOneTokenTransfer.sol";

contract TwoTokenTransfer {
    function twoTransfer(
        address oneTokenTransferAddr,
        address tokenTransferAddr,
        address token,
        address[] memory toArr,
        uint256 amount
    ) external {
        IOneTokenTransfer(oneTokenTransferAddr).oneTransfer(
            tokenTransferAddr,
            token,
            toArr,
            amount
        );
    }

    function twoTransferFrom(
        address oneTokenTransferAddr,
        address tokenTransferAddr,
        address token,
        address from,
        address to,
        uint256 amount
    ) external {
        IOneTokenTransfer(oneTokenTransferAddr).oneTokenTransferFrom(
            tokenTransferAddr,
            token,
            from,
            to,
            amount
        );
    }
}
