package main

import (
	"context"
	erc20 "contract-case/contract_abi/erc20_transfer/compile"
	erc721 "contract-case/contract_abi/erc721_transfer/compile"
	"contract-case/log"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/ethclient"
	"math/big"
	"testing"
)

func TestGetContractAbi(t *testing.T) {
	// 连接以太坊网络
	client, err := ethclient.Dial("http://192.168.1.112:50000")
	if err != nil {
		log.Fatal(err)
	}
	// 从合约地址获取合约代码
	contractAddress := common.HexToAddress("0xfb1bF24c0C7e7C1B89c4A496aACf01aBF26C0B94")

	//code, err := client.CodeAt(context.Background(), contractAddress, nil)
	//if err != nil {
	//	log.Fatal("get contract code err:", err)
	//}

	// 解析ABI
	//contractAbi, err := abi.JSON(strings.NewReader(string(code)))
	//if err != nil {
	//	log.Fatal(err)
	//}

	// 打印ABI信息
	//fmt.Println(contractAbi.Methods)

	balance, err := client.BalanceAt(context.Background(), contractAddress, nil)
	if err != nil {
		log.Fatal("Get account balance err:", err.Error())
	}
	log.Info("balance:", balance.String())

	receipt, err := client.TransactionReceipt(context.Background(), common.HexToHash("0x1df7a8d79fc3419484fa3e5e72fa801f917ba7133e4bf324786fa9727a920319"))
	if err != nil {
		log.Fatal("Get receipt error:", err.Error())
		return
	}
	log.Info("status:", receipt.Status, ",tranNonce:", receipt.TransactionIndex, ",GasUsed:", receipt.GasUsed)
}

func TestGetErc20Balance(t *testing.T) {
	// 连接以太坊网络
	client, err := ethclient.Dial("http://54.72.101.87:50000")
	if err != nil {
		log.Fatal(err)
	}
	// 从合约地址获取合约代码
	contractAddress := common.HexToAddress("0x14f2567347beb8ed0fec95397940f17ef7a94541")
	accountAddr := common.HexToAddress("0x812D866f7f558A7325c16B729286e0e661b9DB36")

	newERC20, err := erc20.NewERC20(contractAddress, client)
	if err != nil {
		return
	}
	of, err := newERC20.BalanceOf(&bind.CallOpts{}, accountAddr)
	if err != nil {
		return
	}
	log.Info("balance is :", of.String())
}

func TestGetErc721Balance(t *testing.T) {
	// 连接以太坊网络
	client, err := ethclient.Dial("http://15.161.177.5:26658")
	if err != nil {
		log.Fatal(err)
	}
	// 从合约地址获取合约代码
	contractAddress := common.HexToAddress("0x408d8a2e22265edb60bc98f59d7a458f2cefc638")
	accountAddr := common.HexToAddress("0xe2bA4B27E835f3D5A8f74B53aD6b8b6264D3F501")

	newERC721, err := erc721.NewERC721(contractAddress, client)
	if err != nil {
		return
	}
	of, err := newERC721.BalanceOf(&bind.CallOpts{}, accountAddr)
	if err != nil {
		return
	}
	log.Info("balance is :", of.String())
	for i := 0; i < 100; i++ {
		ownerOf, err := newERC721.OwnerOf(&bind.CallOpts{}, big.NewInt(int64(i)))
		if err != nil {
			log.Error("Error:", err.Error())
			return
		}
		log.Info("ownerOf:", ownerOf.Hex())
	}
}

func TestBigIntFunc(t *testing.T) {

	//amount := big.NewInt(10000000000)

	mul := big.NewInt(1).Mul(big.NewInt(10000000000000000), big.NewInt(2))

	t.Log("amount:", mul.String())

}
