// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package vm

import (
	"errors"
	"math/big"
	"strings"

	ethereum "github.com/ethereum/go-ethereum"
	"github.com/ethereum/go-ethereum/accounts/abi"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/event"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = errors.New
	_ = big.NewInt
	_ = strings.NewReader
	_ = ethereum.NotFound
	_ = bind.Bind
	_ = common.Big1
	_ = types.BloomLookup
	_ = event.NewSubscription
)

// VmMetaData contains all meta data concerning the Vm contract.
var VmMetaData = &bind.MetaData{
	ABI: "[{\"inputs\":[{\"internalType\":\"address\",\"name\":\"const\",\"type\":\"address\"}],\"stateMutability\":\"nonpayable\",\"type\":\"constructor\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"previousOwner\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"newOwner\",\"type\":\"address\"}],\"name\":\"OwnershipTransferred\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"vmId\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"string\",\"name\":\"intranetIp\",\"type\":\"string\"},{\"indexed\":false,\"internalType\":\"string\",\"name\":\"externalIp\",\"type\":\"string\"},{\"indexed\":false,\"internalType\":\"string\",\"name\":\"exSshPort\",\"type\":\"string\"},{\"indexed\":false,\"internalType\":\"string\",\"name\":\"exVncPort\",\"type\":\"string\"},{\"indexed\":false,\"internalType\":\"string\",\"name\":\"inSshPort\",\"type\":\"string\"},{\"indexed\":false,\"internalType\":\"string\",\"name\":\"inVncPort\",\"type\":\"string\"}],\"name\":\"UpdateNetworkInfoEvent\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"vmId\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"string\",\"name\":\"cpuCost\",\"type\":\"string\"},{\"indexed\":false,\"internalType\":\"string\",\"name\":\"memoryCost\",\"type\":\"string\"},{\"indexed\":false,\"internalType\":\"string\",\"name\":\"gpuCost\",\"type\":\"string\"},{\"indexed\":false,\"internalType\":\"string\",\"name\":\"diskCost\",\"type\":\"string\"}],\"name\":\"UpdateResourceInfoEvent\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"vmId\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"uint64\",\"name\":\"cpuNum\",\"type\":\"uint64\"},{\"indexed\":false,\"internalType\":\"uint64\",\"name\":\"memoryNum\",\"type\":\"uint64\"},{\"indexed\":false,\"internalType\":\"uint64\",\"name\":\"gpuNum\",\"type\":\"uint64\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"disk\",\"type\":\"uint256\"}],\"name\":\"UpdateVMInfoEvent\",\"type\":\"event\"},{\"inputs\":[],\"name\":\"_const\",\"outputs\":[{\"internalType\":\"contractICloudConstant\",\"name\":\"\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"_admin\",\"type\":\"address\"}],\"name\":\"addAdmin\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"owner\",\"type\":\"address\"},{\"internalType\":\"string\",\"name\":\"taskId\",\"type\":\"string\"},{\"internalType\":\"uint256\",\"name\":\"vmId\",\"type\":\"uint256\"},{\"internalType\":\"string\",\"name\":\"clusterId\",\"type\":\"string\"},{\"internalType\":\"string\",\"name\":\"globalIdentify\",\"type\":\"string\"},{\"internalType\":\"string\",\"name\":\"hostId\",\"type\":\"string\"},{\"internalType\":\"string\",\"name\":\"vmName\",\"type\":\"string\"},{\"internalType\":\"string\",\"name\":\"os\",\"type\":\"string\"}],\"name\":\"addVirtualMachine\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"vmid\",\"type\":\"uint256\"},{\"internalType\":\"string\",\"name\":\"user\",\"type\":\"string\"},{\"internalType\":\"string\",\"name\":\"pwd\",\"type\":\"string\"}],\"name\":\"addVmUser\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"_admin\",\"type\":\"address\"}],\"name\":\"delAdmin\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"string\",\"name\":\"taskId\",\"type\":\"string\"}],\"name\":\"getVmInfo\",\"outputs\":[{\"internalType\":\"string\",\"name\":\"externalIp\",\"type\":\"string\"},{\"internalType\":\"string\",\"name\":\"externalPort\",\"type\":\"string\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"_addr\",\"type\":\"address\"}],\"name\":\"isAdmin\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"owner\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"renounceOwnership\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"const\",\"type\":\"address\"}],\"name\":\"setConstant\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"newOwner\",\"type\":\"address\"}],\"name\":\"transferOwnership\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"vmId\",\"type\":\"uint256\"},{\"internalType\":\"string\",\"name\":\"cpuCost\",\"type\":\"string\"},{\"internalType\":\"string\",\"name\":\"memoryCost\",\"type\":\"string\"},{\"internalType\":\"string\",\"name\":\"gpuCost\",\"type\":\"string\"},{\"internalType\":\"string\",\"name\":\"diskCost\",\"type\":\"string\"}],\"name\":\"updateResourceInfo\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"vmId\",\"type\":\"uint256\"},{\"internalType\":\"uint64\",\"name\":\"cpuNum\",\"type\":\"uint64\"},{\"internalType\":\"uint64\",\"name\":\"memoryNum\",\"type\":\"uint64\"},{\"internalType\":\"uint64\",\"name\":\"gpuNum\",\"type\":\"uint64\"},{\"internalType\":\"uint256\",\"name\":\"disk\",\"type\":\"uint256\"}],\"name\":\"updateVMInfoEvent\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"vmId\",\"type\":\"uint256\"},{\"internalType\":\"string\",\"name\":\"intranetIp\",\"type\":\"string\"},{\"internalType\":\"string\",\"name\":\"externalIp\",\"type\":\"string\"},{\"internalType\":\"string\",\"name\":\"exSshPort\",\"type\":\"string\"},{\"internalType\":\"string\",\"name\":\"exVncPort\",\"type\":\"string\"},{\"internalType\":\"string\",\"name\":\"inSshPort\",\"type\":\"string\"},{\"internalType\":\"string\",\"name\":\"inVncPort\",\"type\":\"string\"}],\"name\":\"updateVmNetworkInfo\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"name\":\"vmData\",\"outputs\":[{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"}],\"stateMutability\":\"view\",\"type\":\"function\"}]",
}

// VmABI is the input ABI used to generate the binding from.
// Deprecated: Use VmMetaData.ABI instead.
var VmABI = VmMetaData.ABI

// Vm is an auto generated Go binding around an Ethereum contract.
type Vm struct {
	VmCaller     // Read-only binding to the contract
	VmTransactor // Write-only binding to the contract
	VmFilterer   // Log filterer for contract events
}

// VmCaller is an auto generated read-only Go binding around an Ethereum contract.
type VmCaller struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// VmTransactor is an auto generated write-only Go binding around an Ethereum contract.
type VmTransactor struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// VmFilterer is an auto generated log filtering Go binding around an Ethereum contract events.
type VmFilterer struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// VmSession is an auto generated Go binding around an Ethereum contract,
// with pre-set call and transact options.
type VmSession struct {
	Contract     *Vm               // Generic contract binding to set the session for
	CallOpts     bind.CallOpts     // Call options to use throughout this session
	TransactOpts bind.TransactOpts // Transaction auth options to use throughout this session
}

// VmCallerSession is an auto generated read-only Go binding around an Ethereum contract,
// with pre-set call options.
type VmCallerSession struct {
	Contract *VmCaller     // Generic contract caller binding to set the session for
	CallOpts bind.CallOpts // Call options to use throughout this session
}

// VmTransactorSession is an auto generated write-only Go binding around an Ethereum contract,
// with pre-set transact options.
type VmTransactorSession struct {
	Contract     *VmTransactor     // Generic contract transactor binding to set the session for
	TransactOpts bind.TransactOpts // Transaction auth options to use throughout this session
}

// VmRaw is an auto generated low-level Go binding around an Ethereum contract.
type VmRaw struct {
	Contract *Vm // Generic contract binding to access the raw methods on
}

// VmCallerRaw is an auto generated low-level read-only Go binding around an Ethereum contract.
type VmCallerRaw struct {
	Contract *VmCaller // Generic read-only contract binding to access the raw methods on
}

// VmTransactorRaw is an auto generated low-level write-only Go binding around an Ethereum contract.
type VmTransactorRaw struct {
	Contract *VmTransactor // Generic write-only contract binding to access the raw methods on
}

// NewVm creates a new instance of Vm, bound to a specific deployed contract.
func NewVm(address common.Address, backend bind.ContractBackend) (*Vm, error) {
	contract, err := bindVm(address, backend, backend, backend)
	if err != nil {
		return nil, err
	}
	return &Vm{VmCaller: VmCaller{contract: contract}, VmTransactor: VmTransactor{contract: contract}, VmFilterer: VmFilterer{contract: contract}}, nil
}

// NewVmCaller creates a new read-only instance of Vm, bound to a specific deployed contract.
func NewVmCaller(address common.Address, caller bind.ContractCaller) (*VmCaller, error) {
	contract, err := bindVm(address, caller, nil, nil)
	if err != nil {
		return nil, err
	}
	return &VmCaller{contract: contract}, nil
}

// NewVmTransactor creates a new write-only instance of Vm, bound to a specific deployed contract.
func NewVmTransactor(address common.Address, transactor bind.ContractTransactor) (*VmTransactor, error) {
	contract, err := bindVm(address, nil, transactor, nil)
	if err != nil {
		return nil, err
	}
	return &VmTransactor{contract: contract}, nil
}

// NewVmFilterer creates a new log filterer instance of Vm, bound to a specific deployed contract.
func NewVmFilterer(address common.Address, filterer bind.ContractFilterer) (*VmFilterer, error) {
	contract, err := bindVm(address, nil, nil, filterer)
	if err != nil {
		return nil, err
	}
	return &VmFilterer{contract: contract}, nil
}

// bindVm binds a generic wrapper to an already deployed contract.
func bindVm(address common.Address, caller bind.ContractCaller, transactor bind.ContractTransactor, filterer bind.ContractFilterer) (*bind.BoundContract, error) {
	parsed, err := abi.JSON(strings.NewReader(VmABI))
	if err != nil {
		return nil, err
	}
	return bind.NewBoundContract(address, parsed, caller, transactor, filterer), nil
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_Vm *VmRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _Vm.Contract.VmCaller.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_Vm *VmRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _Vm.Contract.VmTransactor.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_Vm *VmRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _Vm.Contract.VmTransactor.contract.Transact(opts, method, params...)
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_Vm *VmCallerRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _Vm.Contract.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_Vm *VmTransactorRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _Vm.Contract.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_Vm *VmTransactorRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _Vm.Contract.contract.Transact(opts, method, params...)
}

// Const is a free data retrieval call binding the contract method 0xe76dba42.
//
// Solidity: function _const() view returns(address)
func (_Vm *VmCaller) Const(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _Vm.contract.Call(opts, &out, "_const")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// Const is a free data retrieval call binding the contract method 0xe76dba42.
//
// Solidity: function _const() view returns(address)
func (_Vm *VmSession) Const() (common.Address, error) {
	return _Vm.Contract.Const(&_Vm.CallOpts)
}

// Const is a free data retrieval call binding the contract method 0xe76dba42.
//
// Solidity: function _const() view returns(address)
func (_Vm *VmCallerSession) Const() (common.Address, error) {
	return _Vm.Contract.Const(&_Vm.CallOpts)
}

// GetVmInfo is a free data retrieval call binding the contract method 0x165e73cd.
//
// Solidity: function getVmInfo(string taskId) view returns(string externalIp, string externalPort)
func (_Vm *VmCaller) GetVmInfo(opts *bind.CallOpts, taskId string) (struct {
	ExternalIp   string
	ExternalPort string
}, error) {
	var out []interface{}
	err := _Vm.contract.Call(opts, &out, "getVmInfo", taskId)

	outstruct := new(struct {
		ExternalIp   string
		ExternalPort string
	})
	if err != nil {
		return *outstruct, err
	}

	outstruct.ExternalIp = *abi.ConvertType(out[0], new(string)).(*string)
	outstruct.ExternalPort = *abi.ConvertType(out[1], new(string)).(*string)

	return *outstruct, err

}

// GetVmInfo is a free data retrieval call binding the contract method 0x165e73cd.
//
// Solidity: function getVmInfo(string taskId) view returns(string externalIp, string externalPort)
func (_Vm *VmSession) GetVmInfo(taskId string) (struct {
	ExternalIp   string
	ExternalPort string
}, error) {
	return _Vm.Contract.GetVmInfo(&_Vm.CallOpts, taskId)
}

// GetVmInfo is a free data retrieval call binding the contract method 0x165e73cd.
//
// Solidity: function getVmInfo(string taskId) view returns(string externalIp, string externalPort)
func (_Vm *VmCallerSession) GetVmInfo(taskId string) (struct {
	ExternalIp   string
	ExternalPort string
}, error) {
	return _Vm.Contract.GetVmInfo(&_Vm.CallOpts, taskId)
}

// IsAdmin is a free data retrieval call binding the contract method 0x24d7806c.
//
// Solidity: function isAdmin(address _addr) view returns(bool)
func (_Vm *VmCaller) IsAdmin(opts *bind.CallOpts, _addr common.Address) (bool, error) {
	var out []interface{}
	err := _Vm.contract.Call(opts, &out, "isAdmin", _addr)

	if err != nil {
		return *new(bool), err
	}

	out0 := *abi.ConvertType(out[0], new(bool)).(*bool)

	return out0, err

}

// IsAdmin is a free data retrieval call binding the contract method 0x24d7806c.
//
// Solidity: function isAdmin(address _addr) view returns(bool)
func (_Vm *VmSession) IsAdmin(_addr common.Address) (bool, error) {
	return _Vm.Contract.IsAdmin(&_Vm.CallOpts, _addr)
}

// IsAdmin is a free data retrieval call binding the contract method 0x24d7806c.
//
// Solidity: function isAdmin(address _addr) view returns(bool)
func (_Vm *VmCallerSession) IsAdmin(_addr common.Address) (bool, error) {
	return _Vm.Contract.IsAdmin(&_Vm.CallOpts, _addr)
}

// Owner is a free data retrieval call binding the contract method 0x8da5cb5b.
//
// Solidity: function owner() view returns(address)
func (_Vm *VmCaller) Owner(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _Vm.contract.Call(opts, &out, "owner")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// Owner is a free data retrieval call binding the contract method 0x8da5cb5b.
//
// Solidity: function owner() view returns(address)
func (_Vm *VmSession) Owner() (common.Address, error) {
	return _Vm.Contract.Owner(&_Vm.CallOpts)
}

// Owner is a free data retrieval call binding the contract method 0x8da5cb5b.
//
// Solidity: function owner() view returns(address)
func (_Vm *VmCallerSession) Owner() (common.Address, error) {
	return _Vm.Contract.Owner(&_Vm.CallOpts)
}

// VmData is a free data retrieval call binding the contract method 0x2d9d87d7.
//
// Solidity: function vmData(uint256 , uint256 ) view returns(string)
func (_Vm *VmCaller) VmData(opts *bind.CallOpts, arg0 *big.Int, arg1 *big.Int) (string, error) {
	var out []interface{}
	err := _Vm.contract.Call(opts, &out, "vmData", arg0, arg1)

	if err != nil {
		return *new(string), err
	}

	out0 := *abi.ConvertType(out[0], new(string)).(*string)

	return out0, err

}

// VmData is a free data retrieval call binding the contract method 0x2d9d87d7.
//
// Solidity: function vmData(uint256 , uint256 ) view returns(string)
func (_Vm *VmSession) VmData(arg0 *big.Int, arg1 *big.Int) (string, error) {
	return _Vm.Contract.VmData(&_Vm.CallOpts, arg0, arg1)
}

// VmData is a free data retrieval call binding the contract method 0x2d9d87d7.
//
// Solidity: function vmData(uint256 , uint256 ) view returns(string)
func (_Vm *VmCallerSession) VmData(arg0 *big.Int, arg1 *big.Int) (string, error) {
	return _Vm.Contract.VmData(&_Vm.CallOpts, arg0, arg1)
}

// AddAdmin is a paid mutator transaction binding the contract method 0x70480275.
//
// Solidity: function addAdmin(address _admin) returns()
func (_Vm *VmTransactor) AddAdmin(opts *bind.TransactOpts, _admin common.Address) (*types.Transaction, error) {
	return _Vm.contract.Transact(opts, "addAdmin", _admin)
}

// AddAdmin is a paid mutator transaction binding the contract method 0x70480275.
//
// Solidity: function addAdmin(address _admin) returns()
func (_Vm *VmSession) AddAdmin(_admin common.Address) (*types.Transaction, error) {
	return _Vm.Contract.AddAdmin(&_Vm.TransactOpts, _admin)
}

// AddAdmin is a paid mutator transaction binding the contract method 0x70480275.
//
// Solidity: function addAdmin(address _admin) returns()
func (_Vm *VmTransactorSession) AddAdmin(_admin common.Address) (*types.Transaction, error) {
	return _Vm.Contract.AddAdmin(&_Vm.TransactOpts, _admin)
}

// AddVirtualMachine is a paid mutator transaction binding the contract method 0x7c95f48f.
//
// Solidity: function addVirtualMachine(address owner, string taskId, uint256 vmId, string clusterId, string globalIdentify, string hostId, string vmName, string os) returns()
func (_Vm *VmTransactor) AddVirtualMachine(opts *bind.TransactOpts, owner common.Address, taskId string, vmId *big.Int, clusterId string, globalIdentify string, hostId string, vmName string, os string) (*types.Transaction, error) {
	return _Vm.contract.Transact(opts, "addVirtualMachine", owner, taskId, vmId, clusterId, globalIdentify, hostId, vmName, os)
}

// AddVirtualMachine is a paid mutator transaction binding the contract method 0x7c95f48f.
//
// Solidity: function addVirtualMachine(address owner, string taskId, uint256 vmId, string clusterId, string globalIdentify, string hostId, string vmName, string os) returns()
func (_Vm *VmSession) AddVirtualMachine(owner common.Address, taskId string, vmId *big.Int, clusterId string, globalIdentify string, hostId string, vmName string, os string) (*types.Transaction, error) {
	return _Vm.Contract.AddVirtualMachine(&_Vm.TransactOpts, owner, taskId, vmId, clusterId, globalIdentify, hostId, vmName, os)
}

// AddVirtualMachine is a paid mutator transaction binding the contract method 0x7c95f48f.
//
// Solidity: function addVirtualMachine(address owner, string taskId, uint256 vmId, string clusterId, string globalIdentify, string hostId, string vmName, string os) returns()
func (_Vm *VmTransactorSession) AddVirtualMachine(owner common.Address, taskId string, vmId *big.Int, clusterId string, globalIdentify string, hostId string, vmName string, os string) (*types.Transaction, error) {
	return _Vm.Contract.AddVirtualMachine(&_Vm.TransactOpts, owner, taskId, vmId, clusterId, globalIdentify, hostId, vmName, os)
}

// AddVmUser is a paid mutator transaction binding the contract method 0x388911d6.
//
// Solidity: function addVmUser(uint256 vmid, string user, string pwd) returns()
func (_Vm *VmTransactor) AddVmUser(opts *bind.TransactOpts, vmid *big.Int, user string, pwd string) (*types.Transaction, error) {
	return _Vm.contract.Transact(opts, "addVmUser", vmid, user, pwd)
}

// AddVmUser is a paid mutator transaction binding the contract method 0x388911d6.
//
// Solidity: function addVmUser(uint256 vmid, string user, string pwd) returns()
func (_Vm *VmSession) AddVmUser(vmid *big.Int, user string, pwd string) (*types.Transaction, error) {
	return _Vm.Contract.AddVmUser(&_Vm.TransactOpts, vmid, user, pwd)
}

// AddVmUser is a paid mutator transaction binding the contract method 0x388911d6.
//
// Solidity: function addVmUser(uint256 vmid, string user, string pwd) returns()
func (_Vm *VmTransactorSession) AddVmUser(vmid *big.Int, user string, pwd string) (*types.Transaction, error) {
	return _Vm.Contract.AddVmUser(&_Vm.TransactOpts, vmid, user, pwd)
}

// DelAdmin is a paid mutator transaction binding the contract method 0x62d91855.
//
// Solidity: function delAdmin(address _admin) returns()
func (_Vm *VmTransactor) DelAdmin(opts *bind.TransactOpts, _admin common.Address) (*types.Transaction, error) {
	return _Vm.contract.Transact(opts, "delAdmin", _admin)
}

// DelAdmin is a paid mutator transaction binding the contract method 0x62d91855.
//
// Solidity: function delAdmin(address _admin) returns()
func (_Vm *VmSession) DelAdmin(_admin common.Address) (*types.Transaction, error) {
	return _Vm.Contract.DelAdmin(&_Vm.TransactOpts, _admin)
}

// DelAdmin is a paid mutator transaction binding the contract method 0x62d91855.
//
// Solidity: function delAdmin(address _admin) returns()
func (_Vm *VmTransactorSession) DelAdmin(_admin common.Address) (*types.Transaction, error) {
	return _Vm.Contract.DelAdmin(&_Vm.TransactOpts, _admin)
}

// RenounceOwnership is a paid mutator transaction binding the contract method 0x715018a6.
//
// Solidity: function renounceOwnership() returns()
func (_Vm *VmTransactor) RenounceOwnership(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _Vm.contract.Transact(opts, "renounceOwnership")
}

// RenounceOwnership is a paid mutator transaction binding the contract method 0x715018a6.
//
// Solidity: function renounceOwnership() returns()
func (_Vm *VmSession) RenounceOwnership() (*types.Transaction, error) {
	return _Vm.Contract.RenounceOwnership(&_Vm.TransactOpts)
}

// RenounceOwnership is a paid mutator transaction binding the contract method 0x715018a6.
//
// Solidity: function renounceOwnership() returns()
func (_Vm *VmTransactorSession) RenounceOwnership() (*types.Transaction, error) {
	return _Vm.Contract.RenounceOwnership(&_Vm.TransactOpts)
}

// SetConstant is a paid mutator transaction binding the contract method 0xc88e7e42.
//
// Solidity: function setConstant(address const) returns()
func (_Vm *VmTransactor) SetConstant(opts *bind.TransactOpts, arg0 common.Address) (*types.Transaction, error) {
	return _Vm.contract.Transact(opts, "setConstant", arg0)
}

// SetConstant is a paid mutator transaction binding the contract method 0xc88e7e42.
//
// Solidity: function setConstant(address const) returns()
func (_Vm *VmSession) SetConstant(arg0 common.Address) (*types.Transaction, error) {
	return _Vm.Contract.SetConstant(&_Vm.TransactOpts, arg0)
}

// SetConstant is a paid mutator transaction binding the contract method 0xc88e7e42.
//
// Solidity: function setConstant(address const) returns()
func (_Vm *VmTransactorSession) SetConstant(arg0 common.Address) (*types.Transaction, error) {
	return _Vm.Contract.SetConstant(&_Vm.TransactOpts, arg0)
}

// TransferOwnership is a paid mutator transaction binding the contract method 0xf2fde38b.
//
// Solidity: function transferOwnership(address newOwner) returns()
func (_Vm *VmTransactor) TransferOwnership(opts *bind.TransactOpts, newOwner common.Address) (*types.Transaction, error) {
	return _Vm.contract.Transact(opts, "transferOwnership", newOwner)
}

// TransferOwnership is a paid mutator transaction binding the contract method 0xf2fde38b.
//
// Solidity: function transferOwnership(address newOwner) returns()
func (_Vm *VmSession) TransferOwnership(newOwner common.Address) (*types.Transaction, error) {
	return _Vm.Contract.TransferOwnership(&_Vm.TransactOpts, newOwner)
}

// TransferOwnership is a paid mutator transaction binding the contract method 0xf2fde38b.
//
// Solidity: function transferOwnership(address newOwner) returns()
func (_Vm *VmTransactorSession) TransferOwnership(newOwner common.Address) (*types.Transaction, error) {
	return _Vm.Contract.TransferOwnership(&_Vm.TransactOpts, newOwner)
}

// UpdateResourceInfo is a paid mutator transaction binding the contract method 0xb46831f8.
//
// Solidity: function updateResourceInfo(uint256 vmId, string cpuCost, string memoryCost, string gpuCost, string diskCost) returns()
func (_Vm *VmTransactor) UpdateResourceInfo(opts *bind.TransactOpts, vmId *big.Int, cpuCost string, memoryCost string, gpuCost string, diskCost string) (*types.Transaction, error) {
	return _Vm.contract.Transact(opts, "updateResourceInfo", vmId, cpuCost, memoryCost, gpuCost, diskCost)
}

// UpdateResourceInfo is a paid mutator transaction binding the contract method 0xb46831f8.
//
// Solidity: function updateResourceInfo(uint256 vmId, string cpuCost, string memoryCost, string gpuCost, string diskCost) returns()
func (_Vm *VmSession) UpdateResourceInfo(vmId *big.Int, cpuCost string, memoryCost string, gpuCost string, diskCost string) (*types.Transaction, error) {
	return _Vm.Contract.UpdateResourceInfo(&_Vm.TransactOpts, vmId, cpuCost, memoryCost, gpuCost, diskCost)
}

// UpdateResourceInfo is a paid mutator transaction binding the contract method 0xb46831f8.
//
// Solidity: function updateResourceInfo(uint256 vmId, string cpuCost, string memoryCost, string gpuCost, string diskCost) returns()
func (_Vm *VmTransactorSession) UpdateResourceInfo(vmId *big.Int, cpuCost string, memoryCost string, gpuCost string, diskCost string) (*types.Transaction, error) {
	return _Vm.Contract.UpdateResourceInfo(&_Vm.TransactOpts, vmId, cpuCost, memoryCost, gpuCost, diskCost)
}

// UpdateVMInfoEvent is a paid mutator transaction binding the contract method 0xa33d9a98.
//
// Solidity: function updateVMInfoEvent(uint256 vmId, uint64 cpuNum, uint64 memoryNum, uint64 gpuNum, uint256 disk) returns()
func (_Vm *VmTransactor) UpdateVMInfoEvent(opts *bind.TransactOpts, vmId *big.Int, cpuNum uint64, memoryNum uint64, gpuNum uint64, disk *big.Int) (*types.Transaction, error) {
	return _Vm.contract.Transact(opts, "updateVMInfoEvent", vmId, cpuNum, memoryNum, gpuNum, disk)
}

// UpdateVMInfoEvent is a paid mutator transaction binding the contract method 0xa33d9a98.
//
// Solidity: function updateVMInfoEvent(uint256 vmId, uint64 cpuNum, uint64 memoryNum, uint64 gpuNum, uint256 disk) returns()
func (_Vm *VmSession) UpdateVMInfoEvent(vmId *big.Int, cpuNum uint64, memoryNum uint64, gpuNum uint64, disk *big.Int) (*types.Transaction, error) {
	return _Vm.Contract.UpdateVMInfoEvent(&_Vm.TransactOpts, vmId, cpuNum, memoryNum, gpuNum, disk)
}

// UpdateVMInfoEvent is a paid mutator transaction binding the contract method 0xa33d9a98.
//
// Solidity: function updateVMInfoEvent(uint256 vmId, uint64 cpuNum, uint64 memoryNum, uint64 gpuNum, uint256 disk) returns()
func (_Vm *VmTransactorSession) UpdateVMInfoEvent(vmId *big.Int, cpuNum uint64, memoryNum uint64, gpuNum uint64, disk *big.Int) (*types.Transaction, error) {
	return _Vm.Contract.UpdateVMInfoEvent(&_Vm.TransactOpts, vmId, cpuNum, memoryNum, gpuNum, disk)
}

// UpdateVmNetworkInfo is a paid mutator transaction binding the contract method 0xfea9da61.
//
// Solidity: function updateVmNetworkInfo(uint256 vmId, string intranetIp, string externalIp, string exSshPort, string exVncPort, string inSshPort, string inVncPort) returns()
func (_Vm *VmTransactor) UpdateVmNetworkInfo(opts *bind.TransactOpts, vmId *big.Int, intranetIp string, externalIp string, exSshPort string, exVncPort string, inSshPort string, inVncPort string) (*types.Transaction, error) {
	return _Vm.contract.Transact(opts, "updateVmNetworkInfo", vmId, intranetIp, externalIp, exSshPort, exVncPort, inSshPort, inVncPort)
}

// UpdateVmNetworkInfo is a paid mutator transaction binding the contract method 0xfea9da61.
//
// Solidity: function updateVmNetworkInfo(uint256 vmId, string intranetIp, string externalIp, string exSshPort, string exVncPort, string inSshPort, string inVncPort) returns()
func (_Vm *VmSession) UpdateVmNetworkInfo(vmId *big.Int, intranetIp string, externalIp string, exSshPort string, exVncPort string, inSshPort string, inVncPort string) (*types.Transaction, error) {
	return _Vm.Contract.UpdateVmNetworkInfo(&_Vm.TransactOpts, vmId, intranetIp, externalIp, exSshPort, exVncPort, inSshPort, inVncPort)
}

// UpdateVmNetworkInfo is a paid mutator transaction binding the contract method 0xfea9da61.
//
// Solidity: function updateVmNetworkInfo(uint256 vmId, string intranetIp, string externalIp, string exSshPort, string exVncPort, string inSshPort, string inVncPort) returns()
func (_Vm *VmTransactorSession) UpdateVmNetworkInfo(vmId *big.Int, intranetIp string, externalIp string, exSshPort string, exVncPort string, inSshPort string, inVncPort string) (*types.Transaction, error) {
	return _Vm.Contract.UpdateVmNetworkInfo(&_Vm.TransactOpts, vmId, intranetIp, externalIp, exSshPort, exVncPort, inSshPort, inVncPort)
}

// VmOwnershipTransferredIterator is returned from FilterOwnershipTransferred and is used to iterate over the raw logs and unpacked data for OwnershipTransferred events raised by the Vm contract.
type VmOwnershipTransferredIterator struct {
	Event *VmOwnershipTransferred // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *VmOwnershipTransferredIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(VmOwnershipTransferred)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(VmOwnershipTransferred)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *VmOwnershipTransferredIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *VmOwnershipTransferredIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// VmOwnershipTransferred represents a OwnershipTransferred event raised by the Vm contract.
type VmOwnershipTransferred struct {
	PreviousOwner common.Address
	NewOwner      common.Address
	Raw           types.Log // Blockchain specific contextual infos
}

// FilterOwnershipTransferred is a free log retrieval operation binding the contract event 0x8be0079c531659141344cd1fd0a4f28419497f9722a3daafe3b4186f6b6457e0.
//
// Solidity: event OwnershipTransferred(address indexed previousOwner, address indexed newOwner)
func (_Vm *VmFilterer) FilterOwnershipTransferred(opts *bind.FilterOpts, previousOwner []common.Address, newOwner []common.Address) (*VmOwnershipTransferredIterator, error) {

	var previousOwnerRule []interface{}
	for _, previousOwnerItem := range previousOwner {
		previousOwnerRule = append(previousOwnerRule, previousOwnerItem)
	}
	var newOwnerRule []interface{}
	for _, newOwnerItem := range newOwner {
		newOwnerRule = append(newOwnerRule, newOwnerItem)
	}

	logs, sub, err := _Vm.contract.FilterLogs(opts, "OwnershipTransferred", previousOwnerRule, newOwnerRule)
	if err != nil {
		return nil, err
	}
	return &VmOwnershipTransferredIterator{contract: _Vm.contract, event: "OwnershipTransferred", logs: logs, sub: sub}, nil
}

// WatchOwnershipTransferred is a free log subscription operation binding the contract event 0x8be0079c531659141344cd1fd0a4f28419497f9722a3daafe3b4186f6b6457e0.
//
// Solidity: event OwnershipTransferred(address indexed previousOwner, address indexed newOwner)
func (_Vm *VmFilterer) WatchOwnershipTransferred(opts *bind.WatchOpts, sink chan<- *VmOwnershipTransferred, previousOwner []common.Address, newOwner []common.Address) (event.Subscription, error) {

	var previousOwnerRule []interface{}
	for _, previousOwnerItem := range previousOwner {
		previousOwnerRule = append(previousOwnerRule, previousOwnerItem)
	}
	var newOwnerRule []interface{}
	for _, newOwnerItem := range newOwner {
		newOwnerRule = append(newOwnerRule, newOwnerItem)
	}

	logs, sub, err := _Vm.contract.WatchLogs(opts, "OwnershipTransferred", previousOwnerRule, newOwnerRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(VmOwnershipTransferred)
				if err := _Vm.contract.UnpackLog(event, "OwnershipTransferred", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseOwnershipTransferred is a log parse operation binding the contract event 0x8be0079c531659141344cd1fd0a4f28419497f9722a3daafe3b4186f6b6457e0.
//
// Solidity: event OwnershipTransferred(address indexed previousOwner, address indexed newOwner)
func (_Vm *VmFilterer) ParseOwnershipTransferred(log types.Log) (*VmOwnershipTransferred, error) {
	event := new(VmOwnershipTransferred)
	if err := _Vm.contract.UnpackLog(event, "OwnershipTransferred", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// VmUpdateNetworkInfoEventIterator is returned from FilterUpdateNetworkInfoEvent and is used to iterate over the raw logs and unpacked data for UpdateNetworkInfoEvent events raised by the Vm contract.
type VmUpdateNetworkInfoEventIterator struct {
	Event *VmUpdateNetworkInfoEvent // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *VmUpdateNetworkInfoEventIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(VmUpdateNetworkInfoEvent)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(VmUpdateNetworkInfoEvent)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *VmUpdateNetworkInfoEventIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *VmUpdateNetworkInfoEventIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// VmUpdateNetworkInfoEvent represents a UpdateNetworkInfoEvent event raised by the Vm contract.
type VmUpdateNetworkInfoEvent struct {
	VmId       *big.Int
	IntranetIp string
	ExternalIp string
	ExSshPort  string
	ExVncPort  string
	InSshPort  string
	InVncPort  string
	Raw        types.Log // Blockchain specific contextual infos
}

// FilterUpdateNetworkInfoEvent is a free log retrieval operation binding the contract event 0x0fd5b7102f3ab58b1bb714a22fe4cbcb938d3841bbcd2076eb3959939e048399.
//
// Solidity: event UpdateNetworkInfoEvent(uint256 vmId, string intranetIp, string externalIp, string exSshPort, string exVncPort, string inSshPort, string inVncPort)
func (_Vm *VmFilterer) FilterUpdateNetworkInfoEvent(opts *bind.FilterOpts) (*VmUpdateNetworkInfoEventIterator, error) {

	logs, sub, err := _Vm.contract.FilterLogs(opts, "UpdateNetworkInfoEvent")
	if err != nil {
		return nil, err
	}
	return &VmUpdateNetworkInfoEventIterator{contract: _Vm.contract, event: "UpdateNetworkInfoEvent", logs: logs, sub: sub}, nil
}

// WatchUpdateNetworkInfoEvent is a free log subscription operation binding the contract event 0x0fd5b7102f3ab58b1bb714a22fe4cbcb938d3841bbcd2076eb3959939e048399.
//
// Solidity: event UpdateNetworkInfoEvent(uint256 vmId, string intranetIp, string externalIp, string exSshPort, string exVncPort, string inSshPort, string inVncPort)
func (_Vm *VmFilterer) WatchUpdateNetworkInfoEvent(opts *bind.WatchOpts, sink chan<- *VmUpdateNetworkInfoEvent) (event.Subscription, error) {

	logs, sub, err := _Vm.contract.WatchLogs(opts, "UpdateNetworkInfoEvent")
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(VmUpdateNetworkInfoEvent)
				if err := _Vm.contract.UnpackLog(event, "UpdateNetworkInfoEvent", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseUpdateNetworkInfoEvent is a log parse operation binding the contract event 0x0fd5b7102f3ab58b1bb714a22fe4cbcb938d3841bbcd2076eb3959939e048399.
//
// Solidity: event UpdateNetworkInfoEvent(uint256 vmId, string intranetIp, string externalIp, string exSshPort, string exVncPort, string inSshPort, string inVncPort)
func (_Vm *VmFilterer) ParseUpdateNetworkInfoEvent(log types.Log) (*VmUpdateNetworkInfoEvent, error) {
	event := new(VmUpdateNetworkInfoEvent)
	if err := _Vm.contract.UnpackLog(event, "UpdateNetworkInfoEvent", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// VmUpdateResourceInfoEventIterator is returned from FilterUpdateResourceInfoEvent and is used to iterate over the raw logs and unpacked data for UpdateResourceInfoEvent events raised by the Vm contract.
type VmUpdateResourceInfoEventIterator struct {
	Event *VmUpdateResourceInfoEvent // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *VmUpdateResourceInfoEventIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(VmUpdateResourceInfoEvent)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(VmUpdateResourceInfoEvent)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *VmUpdateResourceInfoEventIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *VmUpdateResourceInfoEventIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// VmUpdateResourceInfoEvent represents a UpdateResourceInfoEvent event raised by the Vm contract.
type VmUpdateResourceInfoEvent struct {
	VmId       *big.Int
	CpuCost    string
	MemoryCost string
	GpuCost    string
	DiskCost   string
	Raw        types.Log // Blockchain specific contextual infos
}

// FilterUpdateResourceInfoEvent is a free log retrieval operation binding the contract event 0xbd56b2e50e1a20a86f7cfe93c0113b889f5cfc56d1a64b67cfc2f28decc7bfd7.
//
// Solidity: event UpdateResourceInfoEvent(uint256 vmId, string cpuCost, string memoryCost, string gpuCost, string diskCost)
func (_Vm *VmFilterer) FilterUpdateResourceInfoEvent(opts *bind.FilterOpts) (*VmUpdateResourceInfoEventIterator, error) {

	logs, sub, err := _Vm.contract.FilterLogs(opts, "UpdateResourceInfoEvent")
	if err != nil {
		return nil, err
	}
	return &VmUpdateResourceInfoEventIterator{contract: _Vm.contract, event: "UpdateResourceInfoEvent", logs: logs, sub: sub}, nil
}

// WatchUpdateResourceInfoEvent is a free log subscription operation binding the contract event 0xbd56b2e50e1a20a86f7cfe93c0113b889f5cfc56d1a64b67cfc2f28decc7bfd7.
//
// Solidity: event UpdateResourceInfoEvent(uint256 vmId, string cpuCost, string memoryCost, string gpuCost, string diskCost)
func (_Vm *VmFilterer) WatchUpdateResourceInfoEvent(opts *bind.WatchOpts, sink chan<- *VmUpdateResourceInfoEvent) (event.Subscription, error) {

	logs, sub, err := _Vm.contract.WatchLogs(opts, "UpdateResourceInfoEvent")
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(VmUpdateResourceInfoEvent)
				if err := _Vm.contract.UnpackLog(event, "UpdateResourceInfoEvent", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseUpdateResourceInfoEvent is a log parse operation binding the contract event 0xbd56b2e50e1a20a86f7cfe93c0113b889f5cfc56d1a64b67cfc2f28decc7bfd7.
//
// Solidity: event UpdateResourceInfoEvent(uint256 vmId, string cpuCost, string memoryCost, string gpuCost, string diskCost)
func (_Vm *VmFilterer) ParseUpdateResourceInfoEvent(log types.Log) (*VmUpdateResourceInfoEvent, error) {
	event := new(VmUpdateResourceInfoEvent)
	if err := _Vm.contract.UnpackLog(event, "UpdateResourceInfoEvent", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// VmUpdateVMInfoEventIterator is returned from FilterUpdateVMInfoEvent and is used to iterate over the raw logs and unpacked data for UpdateVMInfoEvent events raised by the Vm contract.
type VmUpdateVMInfoEventIterator struct {
	Event *VmUpdateVMInfoEvent // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *VmUpdateVMInfoEventIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(VmUpdateVMInfoEvent)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(VmUpdateVMInfoEvent)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *VmUpdateVMInfoEventIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *VmUpdateVMInfoEventIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// VmUpdateVMInfoEvent represents a UpdateVMInfoEvent event raised by the Vm contract.
type VmUpdateVMInfoEvent struct {
	VmId      *big.Int
	CpuNum    uint64
	MemoryNum uint64
	GpuNum    uint64
	Disk      *big.Int
	Raw       types.Log // Blockchain specific contextual infos
}

// FilterUpdateVMInfoEvent is a free log retrieval operation binding the contract event 0xe7eca197713d046c5838b32bdc1fac83a9de5a9ca65a070482955f7953f6aab1.
//
// Solidity: event UpdateVMInfoEvent(uint256 vmId, uint64 cpuNum, uint64 memoryNum, uint64 gpuNum, uint256 disk)
func (_Vm *VmFilterer) FilterUpdateVMInfoEvent(opts *bind.FilterOpts) (*VmUpdateVMInfoEventIterator, error) {

	logs, sub, err := _Vm.contract.FilterLogs(opts, "UpdateVMInfoEvent")
	if err != nil {
		return nil, err
	}
	return &VmUpdateVMInfoEventIterator{contract: _Vm.contract, event: "UpdateVMInfoEvent", logs: logs, sub: sub}, nil
}

// WatchUpdateVMInfoEvent is a free log subscription operation binding the contract event 0xe7eca197713d046c5838b32bdc1fac83a9de5a9ca65a070482955f7953f6aab1.
//
// Solidity: event UpdateVMInfoEvent(uint256 vmId, uint64 cpuNum, uint64 memoryNum, uint64 gpuNum, uint256 disk)
func (_Vm *VmFilterer) WatchUpdateVMInfoEvent(opts *bind.WatchOpts, sink chan<- *VmUpdateVMInfoEvent) (event.Subscription, error) {

	logs, sub, err := _Vm.contract.WatchLogs(opts, "UpdateVMInfoEvent")
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(VmUpdateVMInfoEvent)
				if err := _Vm.contract.UnpackLog(event, "UpdateVMInfoEvent", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseUpdateVMInfoEvent is a log parse operation binding the contract event 0xe7eca197713d046c5838b32bdc1fac83a9de5a9ca65a070482955f7953f6aab1.
//
// Solidity: event UpdateVMInfoEvent(uint256 vmId, uint64 cpuNum, uint64 memoryNum, uint64 gpuNum, uint256 disk)
func (_Vm *VmFilterer) ParseUpdateVMInfoEvent(log types.Log) (*VmUpdateVMInfoEvent, error) {
	event := new(VmUpdateVMInfoEvent)
	if err := _Vm.contract.UnpackLog(event, "UpdateVMInfoEvent", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}
