package models

import (
	"github.com/ethereum/go-ethereum/common"
	"math/big"
	"time"
)

// HeaderInfo 请求头的信息
type HeaderInfo struct {
	CSRFPreventionToken string `json:"CSRFPreventionToken"`
	Ticket              string `json:"ticket"`
}

// VM 虚拟机的数据
type VM struct {
	NewId       string      `json:"newId"` // 克隆虚拟机模版新id
	VmId        string      `json:"vmId"`  // 虚拟机模版id
	SupportType int         `json:"supportType"`
	VmCfg       *VmConfig   `json:"vmConfig"`
	User        string      `json:"user"`
	Password    string      `json:"password"`
	HeaderInfo  *HeaderInfo `json:"headerInfo"`
}

// VmConfig 虚拟机的配置信息
type VmConfig struct {
	CallerIp  string         `json:"callerIp"`
	TaskId    string         `json:"taskId"`
	Owner     common.Address `json:"owner"`
	Cpu       string         `json:"cpu"`       // 指定虚拟CPU的类型、特性和配置。
	Cores     *big.Int       `json:"cores"`     // 设置每个CPU插槽中的核心数量。
	Sockets   *big.Int       `json:"sockets"`   // 设置CPU插槽的数量。
	Memory    *big.Int       `json:"memory"`    // 设置虚拟机的内存大小。
	OsType    string         `json:"osType"`    // 客户操作系统的类型。
	Gpu       string         `json:"gpu"`       // 指定虚拟GPU的类型、特性和配置。
	GpuNum    *big.Int       `json:"gpuNum"`    // 设置虚拟机的Gpu数量。
	StartDate time.Time      `json:"startDate"` // 设置虚拟机的初始日期和时间。
	Disk      *big.Int       `json:"disk"`
	Name      string         `json:"name"`
}

type VmNetWork struct {
	InternalIp  string `json:"internal_ip"`
	InSshPort   string `json:"in_ssh_port"`
	InVncPort   string `json:"in_vnc_port"`
	ExternalIp  string `json:"external_ip"`
	ExSshPort   string `json:"ex_ssh_port"`
	ExVncPort   string `json:"ex_vnc_port"`
	SupportType int64  `json:"support_type"`
}
