// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package vmCreate

import (
	"errors"
	"math/big"
	"strings"

	ethereum "github.com/ethereum/go-ethereum"
	"github.com/ethereum/go-ethereum/accounts/abi"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/event"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = errors.New
	_ = big.NewInt
	_ = strings.NewReader
	_ = ethereum.NotFound
	_ = bind.Bind
	_ = common.Big1
	_ = types.BloomLookup
	_ = event.NewSubscription
)

// VmCreateMetaData contains all meta data concerning the VmCreate contract.
var VmCreateMetaData = &bind.MetaData{
	ABI: "[{\"inputs\":[{\"internalType\":\"address\",\"name\":\"const\",\"type\":\"address\"}],\"stateMutability\":\"nonpayable\",\"type\":\"constructor\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"internalType\":\"string\",\"name\":\"taskId\",\"type\":\"string\"},{\"indexed\":false,\"internalType\":\"address\",\"name\":\"owner\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"string\",\"name\":\"callerIp\",\"type\":\"string\"},{\"indexed\":false,\"internalType\":\"string\",\"name\":\"cpuModel\",\"type\":\"string\"},{\"indexed\":false,\"internalType\":\"uint64\",\"name\":\"cpuNum\",\"type\":\"uint64\"},{\"indexed\":false,\"internalType\":\"uint64\",\"name\":\"cpuCores\",\"type\":\"uint64\"},{\"indexed\":false,\"internalType\":\"string\",\"name\":\"gpuModel\",\"type\":\"string\"},{\"indexed\":false,\"internalType\":\"uint64\",\"name\":\"gpuNum\",\"type\":\"uint64\"},{\"indexed\":false,\"internalType\":\"uint64\",\"name\":\"memNum\",\"type\":\"uint64\"},{\"indexed\":false,\"internalType\":\"string\",\"name\":\"os\",\"type\":\"string\"}],\"name\":\"AddCreateVMInfoEvent\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"previousOwner\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"newOwner\",\"type\":\"address\"}],\"name\":\"OwnershipTransferred\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"internalType\":\"string\",\"name\":\"taskId\",\"type\":\"string\"},{\"indexed\":false,\"internalType\":\"address\",\"name\":\"creater\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"address\",\"name\":\"snatcher\",\"type\":\"address\"}],\"name\":\"SnatchTaskEvent\",\"type\":\"event\"},{\"inputs\":[],\"name\":\"_const\",\"outputs\":[{\"internalType\":\"contractICloudConstant\",\"name\":\"\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"_admin\",\"type\":\"address\"}],\"name\":\"addAdmin\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"string\",\"name\":\"taskId\",\"type\":\"string\"},{\"internalType\":\"string\",\"name\":\"callerIp\",\"type\":\"string\"},{\"internalType\":\"string\",\"name\":\"cpuModel\",\"type\":\"string\"},{\"internalType\":\"uint64\",\"name\":\"cpuNum\",\"type\":\"uint64\"},{\"internalType\":\"uint64\",\"name\":\"cpuCores\",\"type\":\"uint64\"},{\"internalType\":\"string\",\"name\":\"gpuModel\",\"type\":\"string\"},{\"internalType\":\"uint64\",\"name\":\"gpuNum\",\"type\":\"uint64\"},{\"internalType\":\"uint64\",\"name\":\"memNum\",\"type\":\"uint64\"},{\"internalType\":\"string\",\"name\":\"os\",\"type\":\"string\"}],\"name\":\"addVirtualMachine\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"_admin\",\"type\":\"address\"}],\"name\":\"delAdmin\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"getTaskId\",\"outputs\":[{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"string\",\"name\":\"taskId\",\"type\":\"string\"}],\"name\":\"getVmCreateProgress\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"_addr\",\"type\":\"address\"}],\"name\":\"isAdmin\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"owner\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"renounceOwnership\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"const\",\"type\":\"address\"}],\"name\":\"setConstant\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"string\",\"name\":\"taskId\",\"type\":\"string\"},{\"internalType\":\"address\",\"name\":\"creater\",\"type\":\"address\"}],\"name\":\"snatchTask\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"},{\"internalType\":\"uint8\",\"name\":\"\",\"type\":\"uint8\"}],\"name\":\"taskProgress\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"newOwner\",\"type\":\"address\"}],\"name\":\"transferOwnership\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"string\",\"name\":\"taskId\",\"type\":\"string\"},{\"internalType\":\"uint256\",\"name\":\"createStage\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"createProgress\",\"type\":\"uint256\"}],\"name\":\"updateVmCreateProgress\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"}]",
}

// VmCreateABI is the input ABI used to generate the binding from.
// Deprecated: Use VmCreateMetaData.ABI instead.
var VmCreateABI = VmCreateMetaData.ABI

// VmCreate is an auto generated Go binding around an Ethereum contract.
type VmCreate struct {
	VmCreateCaller     // Read-only binding to the contract
	VmCreateTransactor // Write-only binding to the contract
	VmCreateFilterer   // Log filterer for contract events
}

// VmCreateCaller is an auto generated read-only Go binding around an Ethereum contract.
type VmCreateCaller struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// VmCreateTransactor is an auto generated write-only Go binding around an Ethereum contract.
type VmCreateTransactor struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// VmCreateFilterer is an auto generated log filtering Go binding around an Ethereum contract events.
type VmCreateFilterer struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// VmCreateSession is an auto generated Go binding around an Ethereum contract,
// with pre-set call and transact options.
type VmCreateSession struct {
	Contract     *VmCreate         // Generic contract binding to set the session for
	CallOpts     bind.CallOpts     // Call options to use throughout this session
	TransactOpts bind.TransactOpts // Transaction auth options to use throughout this session
}

// VmCreateCallerSession is an auto generated read-only Go binding around an Ethereum contract,
// with pre-set call options.
type VmCreateCallerSession struct {
	Contract *VmCreateCaller // Generic contract caller binding to set the session for
	CallOpts bind.CallOpts   // Call options to use throughout this session
}

// VmCreateTransactorSession is an auto generated write-only Go binding around an Ethereum contract,
// with pre-set transact options.
type VmCreateTransactorSession struct {
	Contract     *VmCreateTransactor // Generic contract transactor binding to set the session for
	TransactOpts bind.TransactOpts   // Transaction auth options to use throughout this session
}

// VmCreateRaw is an auto generated low-level Go binding around an Ethereum contract.
type VmCreateRaw struct {
	Contract *VmCreate // Generic contract binding to access the raw methods on
}

// VmCreateCallerRaw is an auto generated low-level read-only Go binding around an Ethereum contract.
type VmCreateCallerRaw struct {
	Contract *VmCreateCaller // Generic read-only contract binding to access the raw methods on
}

// VmCreateTransactorRaw is an auto generated low-level write-only Go binding around an Ethereum contract.
type VmCreateTransactorRaw struct {
	Contract *VmCreateTransactor // Generic write-only contract binding to access the raw methods on
}

// NewVmCreate creates a new instance of VmCreate, bound to a specific deployed contract.
func NewVmCreate(address common.Address, backend bind.ContractBackend) (*VmCreate, error) {
	contract, err := bindVmCreate(address, backend, backend, backend)
	if err != nil {
		return nil, err
	}
	return &VmCreate{VmCreateCaller: VmCreateCaller{contract: contract}, VmCreateTransactor: VmCreateTransactor{contract: contract}, VmCreateFilterer: VmCreateFilterer{contract: contract}}, nil
}

// NewVmCreateCaller creates a new read-only instance of VmCreate, bound to a specific deployed contract.
func NewVmCreateCaller(address common.Address, caller bind.ContractCaller) (*VmCreateCaller, error) {
	contract, err := bindVmCreate(address, caller, nil, nil)
	if err != nil {
		return nil, err
	}
	return &VmCreateCaller{contract: contract}, nil
}

// NewVmCreateTransactor creates a new write-only instance of VmCreate, bound to a specific deployed contract.
func NewVmCreateTransactor(address common.Address, transactor bind.ContractTransactor) (*VmCreateTransactor, error) {
	contract, err := bindVmCreate(address, nil, transactor, nil)
	if err != nil {
		return nil, err
	}
	return &VmCreateTransactor{contract: contract}, nil
}

// NewVmCreateFilterer creates a new log filterer instance of VmCreate, bound to a specific deployed contract.
func NewVmCreateFilterer(address common.Address, filterer bind.ContractFilterer) (*VmCreateFilterer, error) {
	contract, err := bindVmCreate(address, nil, nil, filterer)
	if err != nil {
		return nil, err
	}
	return &VmCreateFilterer{contract: contract}, nil
}

// bindVmCreate binds a generic wrapper to an already deployed contract.
func bindVmCreate(address common.Address, caller bind.ContractCaller, transactor bind.ContractTransactor, filterer bind.ContractFilterer) (*bind.BoundContract, error) {
	parsed, err := abi.JSON(strings.NewReader(VmCreateABI))
	if err != nil {
		return nil, err
	}
	return bind.NewBoundContract(address, parsed, caller, transactor, filterer), nil
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_VmCreate *VmCreateRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _VmCreate.Contract.VmCreateCaller.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_VmCreate *VmCreateRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _VmCreate.Contract.VmCreateTransactor.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_VmCreate *VmCreateRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _VmCreate.Contract.VmCreateTransactor.contract.Transact(opts, method, params...)
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_VmCreate *VmCreateCallerRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _VmCreate.Contract.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_VmCreate *VmCreateTransactorRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _VmCreate.Contract.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_VmCreate *VmCreateTransactorRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _VmCreate.Contract.contract.Transact(opts, method, params...)
}

// Const is a free data retrieval call binding the contract method 0xe76dba42.
//
// Solidity: function _const() view returns(address)
func (_VmCreate *VmCreateCaller) Const(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _VmCreate.contract.Call(opts, &out, "_const")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// Const is a free data retrieval call binding the contract method 0xe76dba42.
//
// Solidity: function _const() view returns(address)
func (_VmCreate *VmCreateSession) Const() (common.Address, error) {
	return _VmCreate.Contract.Const(&_VmCreate.CallOpts)
}

// Const is a free data retrieval call binding the contract method 0xe76dba42.
//
// Solidity: function _const() view returns(address)
func (_VmCreate *VmCreateCallerSession) Const() (common.Address, error) {
	return _VmCreate.Contract.Const(&_VmCreate.CallOpts)
}

// GetTaskId is a free data retrieval call binding the contract method 0x13859688.
//
// Solidity: function getTaskId() view returns(string)
func (_VmCreate *VmCreateCaller) GetTaskId(opts *bind.CallOpts) (string, error) {
	var out []interface{}
	err := _VmCreate.contract.Call(opts, &out, "getTaskId")

	if err != nil {
		return *new(string), err
	}

	out0 := *abi.ConvertType(out[0], new(string)).(*string)

	return out0, err

}

// GetTaskId is a free data retrieval call binding the contract method 0x13859688.
//
// Solidity: function getTaskId() view returns(string)
func (_VmCreate *VmCreateSession) GetTaskId() (string, error) {
	return _VmCreate.Contract.GetTaskId(&_VmCreate.CallOpts)
}

// GetTaskId is a free data retrieval call binding the contract method 0x13859688.
//
// Solidity: function getTaskId() view returns(string)
func (_VmCreate *VmCreateCallerSession) GetTaskId() (string, error) {
	return _VmCreate.Contract.GetTaskId(&_VmCreate.CallOpts)
}

// GetVmCreateProgress is a free data retrieval call binding the contract method 0xb1870375.
//
// Solidity: function getVmCreateProgress(string taskId) view returns(uint256, uint256)
func (_VmCreate *VmCreateCaller) GetVmCreateProgress(opts *bind.CallOpts, taskId string) (*big.Int, *big.Int, error) {
	var out []interface{}
	err := _VmCreate.contract.Call(opts, &out, "getVmCreateProgress", taskId)

	if err != nil {
		return *new(*big.Int), *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)
	out1 := *abi.ConvertType(out[1], new(*big.Int)).(**big.Int)

	return out0, out1, err

}

// GetVmCreateProgress is a free data retrieval call binding the contract method 0xb1870375.
//
// Solidity: function getVmCreateProgress(string taskId) view returns(uint256, uint256)
func (_VmCreate *VmCreateSession) GetVmCreateProgress(taskId string) (*big.Int, *big.Int, error) {
	return _VmCreate.Contract.GetVmCreateProgress(&_VmCreate.CallOpts, taskId)
}

// GetVmCreateProgress is a free data retrieval call binding the contract method 0xb1870375.
//
// Solidity: function getVmCreateProgress(string taskId) view returns(uint256, uint256)
func (_VmCreate *VmCreateCallerSession) GetVmCreateProgress(taskId string) (*big.Int, *big.Int, error) {
	return _VmCreate.Contract.GetVmCreateProgress(&_VmCreate.CallOpts, taskId)
}

// IsAdmin is a free data retrieval call binding the contract method 0x24d7806c.
//
// Solidity: function isAdmin(address _addr) view returns(bool)
func (_VmCreate *VmCreateCaller) IsAdmin(opts *bind.CallOpts, _addr common.Address) (bool, error) {
	var out []interface{}
	err := _VmCreate.contract.Call(opts, &out, "isAdmin", _addr)

	if err != nil {
		return *new(bool), err
	}

	out0 := *abi.ConvertType(out[0], new(bool)).(*bool)

	return out0, err

}

// IsAdmin is a free data retrieval call binding the contract method 0x24d7806c.
//
// Solidity: function isAdmin(address _addr) view returns(bool)
func (_VmCreate *VmCreateSession) IsAdmin(_addr common.Address) (bool, error) {
	return _VmCreate.Contract.IsAdmin(&_VmCreate.CallOpts, _addr)
}

// IsAdmin is a free data retrieval call binding the contract method 0x24d7806c.
//
// Solidity: function isAdmin(address _addr) view returns(bool)
func (_VmCreate *VmCreateCallerSession) IsAdmin(_addr common.Address) (bool, error) {
	return _VmCreate.Contract.IsAdmin(&_VmCreate.CallOpts, _addr)
}

// Owner is a free data retrieval call binding the contract method 0x8da5cb5b.
//
// Solidity: function owner() view returns(address)
func (_VmCreate *VmCreateCaller) Owner(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _VmCreate.contract.Call(opts, &out, "owner")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// Owner is a free data retrieval call binding the contract method 0x8da5cb5b.
//
// Solidity: function owner() view returns(address)
func (_VmCreate *VmCreateSession) Owner() (common.Address, error) {
	return _VmCreate.Contract.Owner(&_VmCreate.CallOpts)
}

// Owner is a free data retrieval call binding the contract method 0x8da5cb5b.
//
// Solidity: function owner() view returns(address)
func (_VmCreate *VmCreateCallerSession) Owner() (common.Address, error) {
	return _VmCreate.Contract.Owner(&_VmCreate.CallOpts)
}

// TaskProgress is a free data retrieval call binding the contract method 0x34d578ef.
//
// Solidity: function taskProgress(string , uint8 ) view returns(uint256)
func (_VmCreate *VmCreateCaller) TaskProgress(opts *bind.CallOpts, arg0 string, arg1 uint8) (*big.Int, error) {
	var out []interface{}
	err := _VmCreate.contract.Call(opts, &out, "taskProgress", arg0, arg1)

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// TaskProgress is a free data retrieval call binding the contract method 0x34d578ef.
//
// Solidity: function taskProgress(string , uint8 ) view returns(uint256)
func (_VmCreate *VmCreateSession) TaskProgress(arg0 string, arg1 uint8) (*big.Int, error) {
	return _VmCreate.Contract.TaskProgress(&_VmCreate.CallOpts, arg0, arg1)
}

// TaskProgress is a free data retrieval call binding the contract method 0x34d578ef.
//
// Solidity: function taskProgress(string , uint8 ) view returns(uint256)
func (_VmCreate *VmCreateCallerSession) TaskProgress(arg0 string, arg1 uint8) (*big.Int, error) {
	return _VmCreate.Contract.TaskProgress(&_VmCreate.CallOpts, arg0, arg1)
}

// AddAdmin is a paid mutator transaction binding the contract method 0x70480275.
//
// Solidity: function addAdmin(address _admin) returns()
func (_VmCreate *VmCreateTransactor) AddAdmin(opts *bind.TransactOpts, _admin common.Address) (*types.Transaction, error) {
	return _VmCreate.contract.Transact(opts, "addAdmin", _admin)
}

// AddAdmin is a paid mutator transaction binding the contract method 0x70480275.
//
// Solidity: function addAdmin(address _admin) returns()
func (_VmCreate *VmCreateSession) AddAdmin(_admin common.Address) (*types.Transaction, error) {
	return _VmCreate.Contract.AddAdmin(&_VmCreate.TransactOpts, _admin)
}

// AddAdmin is a paid mutator transaction binding the contract method 0x70480275.
//
// Solidity: function addAdmin(address _admin) returns()
func (_VmCreate *VmCreateTransactorSession) AddAdmin(_admin common.Address) (*types.Transaction, error) {
	return _VmCreate.Contract.AddAdmin(&_VmCreate.TransactOpts, _admin)
}

// AddVirtualMachine is a paid mutator transaction binding the contract method 0xb3570a36.
//
// Solidity: function addVirtualMachine(string taskId, string callerIp, string cpuModel, uint64 cpuNum, uint64 cpuCores, string gpuModel, uint64 gpuNum, uint64 memNum, string os) returns()
func (_VmCreate *VmCreateTransactor) AddVirtualMachine(opts *bind.TransactOpts, taskId string, callerIp string, cpuModel string, cpuNum uint64, cpuCores uint64, gpuModel string, gpuNum uint64, memNum uint64, os string) (*types.Transaction, error) {
	return _VmCreate.contract.Transact(opts, "addVirtualMachine", taskId, callerIp, cpuModel, cpuNum, cpuCores, gpuModel, gpuNum, memNum, os)
}

// AddVirtualMachine is a paid mutator transaction binding the contract method 0xb3570a36.
//
// Solidity: function addVirtualMachine(string taskId, string callerIp, string cpuModel, uint64 cpuNum, uint64 cpuCores, string gpuModel, uint64 gpuNum, uint64 memNum, string os) returns()
func (_VmCreate *VmCreateSession) AddVirtualMachine(taskId string, callerIp string, cpuModel string, cpuNum uint64, cpuCores uint64, gpuModel string, gpuNum uint64, memNum uint64, os string) (*types.Transaction, error) {
	return _VmCreate.Contract.AddVirtualMachine(&_VmCreate.TransactOpts, taskId, callerIp, cpuModel, cpuNum, cpuCores, gpuModel, gpuNum, memNum, os)
}

// AddVirtualMachine is a paid mutator transaction binding the contract method 0xb3570a36.
//
// Solidity: function addVirtualMachine(string taskId, string callerIp, string cpuModel, uint64 cpuNum, uint64 cpuCores, string gpuModel, uint64 gpuNum, uint64 memNum, string os) returns()
func (_VmCreate *VmCreateTransactorSession) AddVirtualMachine(taskId string, callerIp string, cpuModel string, cpuNum uint64, cpuCores uint64, gpuModel string, gpuNum uint64, memNum uint64, os string) (*types.Transaction, error) {
	return _VmCreate.Contract.AddVirtualMachine(&_VmCreate.TransactOpts, taskId, callerIp, cpuModel, cpuNum, cpuCores, gpuModel, gpuNum, memNum, os)
}

// DelAdmin is a paid mutator transaction binding the contract method 0x62d91855.
//
// Solidity: function delAdmin(address _admin) returns()
func (_VmCreate *VmCreateTransactor) DelAdmin(opts *bind.TransactOpts, _admin common.Address) (*types.Transaction, error) {
	return _VmCreate.contract.Transact(opts, "delAdmin", _admin)
}

// DelAdmin is a paid mutator transaction binding the contract method 0x62d91855.
//
// Solidity: function delAdmin(address _admin) returns()
func (_VmCreate *VmCreateSession) DelAdmin(_admin common.Address) (*types.Transaction, error) {
	return _VmCreate.Contract.DelAdmin(&_VmCreate.TransactOpts, _admin)
}

// DelAdmin is a paid mutator transaction binding the contract method 0x62d91855.
//
// Solidity: function delAdmin(address _admin) returns()
func (_VmCreate *VmCreateTransactorSession) DelAdmin(_admin common.Address) (*types.Transaction, error) {
	return _VmCreate.Contract.DelAdmin(&_VmCreate.TransactOpts, _admin)
}

// RenounceOwnership is a paid mutator transaction binding the contract method 0x715018a6.
//
// Solidity: function renounceOwnership() returns()
func (_VmCreate *VmCreateTransactor) RenounceOwnership(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _VmCreate.contract.Transact(opts, "renounceOwnership")
}

// RenounceOwnership is a paid mutator transaction binding the contract method 0x715018a6.
//
// Solidity: function renounceOwnership() returns()
func (_VmCreate *VmCreateSession) RenounceOwnership() (*types.Transaction, error) {
	return _VmCreate.Contract.RenounceOwnership(&_VmCreate.TransactOpts)
}

// RenounceOwnership is a paid mutator transaction binding the contract method 0x715018a6.
//
// Solidity: function renounceOwnership() returns()
func (_VmCreate *VmCreateTransactorSession) RenounceOwnership() (*types.Transaction, error) {
	return _VmCreate.Contract.RenounceOwnership(&_VmCreate.TransactOpts)
}

// SetConstant is a paid mutator transaction binding the contract method 0xc88e7e42.
//
// Solidity: function setConstant(address const) returns()
func (_VmCreate *VmCreateTransactor) SetConstant(opts *bind.TransactOpts, arg0 common.Address) (*types.Transaction, error) {
	return _VmCreate.contract.Transact(opts, "setConstant", arg0)
}

// SetConstant is a paid mutator transaction binding the contract method 0xc88e7e42.
//
// Solidity: function setConstant(address const) returns()
func (_VmCreate *VmCreateSession) SetConstant(arg0 common.Address) (*types.Transaction, error) {
	return _VmCreate.Contract.SetConstant(&_VmCreate.TransactOpts, arg0)
}

// SetConstant is a paid mutator transaction binding the contract method 0xc88e7e42.
//
// Solidity: function setConstant(address const) returns()
func (_VmCreate *VmCreateTransactorSession) SetConstant(arg0 common.Address) (*types.Transaction, error) {
	return _VmCreate.Contract.SetConstant(&_VmCreate.TransactOpts, arg0)
}

// SnatchTask is a paid mutator transaction binding the contract method 0x5d04c897.
//
// Solidity: function snatchTask(string taskId, address creater) returns()
func (_VmCreate *VmCreateTransactor) SnatchTask(opts *bind.TransactOpts, taskId string, creater common.Address) (*types.Transaction, error) {
	return _VmCreate.contract.Transact(opts, "snatchTask", taskId, creater)
}

// SnatchTask is a paid mutator transaction binding the contract method 0x5d04c897.
//
// Solidity: function snatchTask(string taskId, address creater) returns()
func (_VmCreate *VmCreateSession) SnatchTask(taskId string, creater common.Address) (*types.Transaction, error) {
	return _VmCreate.Contract.SnatchTask(&_VmCreate.TransactOpts, taskId, creater)
}

// SnatchTask is a paid mutator transaction binding the contract method 0x5d04c897.
//
// Solidity: function snatchTask(string taskId, address creater) returns()
func (_VmCreate *VmCreateTransactorSession) SnatchTask(taskId string, creater common.Address) (*types.Transaction, error) {
	return _VmCreate.Contract.SnatchTask(&_VmCreate.TransactOpts, taskId, creater)
}

// TransferOwnership is a paid mutator transaction binding the contract method 0xf2fde38b.
//
// Solidity: function transferOwnership(address newOwner) returns()
func (_VmCreate *VmCreateTransactor) TransferOwnership(opts *bind.TransactOpts, newOwner common.Address) (*types.Transaction, error) {
	return _VmCreate.contract.Transact(opts, "transferOwnership", newOwner)
}

// TransferOwnership is a paid mutator transaction binding the contract method 0xf2fde38b.
//
// Solidity: function transferOwnership(address newOwner) returns()
func (_VmCreate *VmCreateSession) TransferOwnership(newOwner common.Address) (*types.Transaction, error) {
	return _VmCreate.Contract.TransferOwnership(&_VmCreate.TransactOpts, newOwner)
}

// TransferOwnership is a paid mutator transaction binding the contract method 0xf2fde38b.
//
// Solidity: function transferOwnership(address newOwner) returns()
func (_VmCreate *VmCreateTransactorSession) TransferOwnership(newOwner common.Address) (*types.Transaction, error) {
	return _VmCreate.Contract.TransferOwnership(&_VmCreate.TransactOpts, newOwner)
}

// UpdateVmCreateProgress is a paid mutator transaction binding the contract method 0x6c1b2427.
//
// Solidity: function updateVmCreateProgress(string taskId, uint256 createStage, uint256 createProgress) returns()
func (_VmCreate *VmCreateTransactor) UpdateVmCreateProgress(opts *bind.TransactOpts, taskId string, createStage *big.Int, createProgress *big.Int) (*types.Transaction, error) {
	return _VmCreate.contract.Transact(opts, "updateVmCreateProgress", taskId, createStage, createProgress)
}

// UpdateVmCreateProgress is a paid mutator transaction binding the contract method 0x6c1b2427.
//
// Solidity: function updateVmCreateProgress(string taskId, uint256 createStage, uint256 createProgress) returns()
func (_VmCreate *VmCreateSession) UpdateVmCreateProgress(taskId string, createStage *big.Int, createProgress *big.Int) (*types.Transaction, error) {
	return _VmCreate.Contract.UpdateVmCreateProgress(&_VmCreate.TransactOpts, taskId, createStage, createProgress)
}

// UpdateVmCreateProgress is a paid mutator transaction binding the contract method 0x6c1b2427.
//
// Solidity: function updateVmCreateProgress(string taskId, uint256 createStage, uint256 createProgress) returns()
func (_VmCreate *VmCreateTransactorSession) UpdateVmCreateProgress(taskId string, createStage *big.Int, createProgress *big.Int) (*types.Transaction, error) {
	return _VmCreate.Contract.UpdateVmCreateProgress(&_VmCreate.TransactOpts, taskId, createStage, createProgress)
}

// VmCreateAddCreateVMInfoEventIterator is returned from FilterAddCreateVMInfoEvent and is used to iterate over the raw logs and unpacked data for AddCreateVMInfoEvent events raised by the VmCreate contract.
type VmCreateAddCreateVMInfoEventIterator struct {
	Event *VmCreateAddCreateVMInfoEvent // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *VmCreateAddCreateVMInfoEventIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(VmCreateAddCreateVMInfoEvent)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(VmCreateAddCreateVMInfoEvent)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *VmCreateAddCreateVMInfoEventIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *VmCreateAddCreateVMInfoEventIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// VmCreateAddCreateVMInfoEvent represents a AddCreateVMInfoEvent event raised by the VmCreate contract.
type VmCreateAddCreateVMInfoEvent struct {
	TaskId   string
	Owner    common.Address
	CallerIp string
	CpuModel string
	CpuNum   uint64
	CpuCores uint64
	GpuModel string
	GpuNum   uint64
	MemNum   uint64
	Os       string
	Raw      types.Log // Blockchain specific contextual infos
}

// FilterAddCreateVMInfoEvent is a free log retrieval operation binding the contract event 0x7d25d4d054c4e119d70f7f809edd27dfdff08e176a4a4a3f25e7e7ad63d3398e.
//
// Solidity: event AddCreateVMInfoEvent(string taskId, address owner, string callerIp, string cpuModel, uint64 cpuNum, uint64 cpuCores, string gpuModel, uint64 gpuNum, uint64 memNum, string os)
func (_VmCreate *VmCreateFilterer) FilterAddCreateVMInfoEvent(opts *bind.FilterOpts) (*VmCreateAddCreateVMInfoEventIterator, error) {

	logs, sub, err := _VmCreate.contract.FilterLogs(opts, "AddCreateVMInfoEvent")
	if err != nil {
		return nil, err
	}
	return &VmCreateAddCreateVMInfoEventIterator{contract: _VmCreate.contract, event: "AddCreateVMInfoEvent", logs: logs, sub: sub}, nil
}

// WatchAddCreateVMInfoEvent is a free log subscription operation binding the contract event 0x7d25d4d054c4e119d70f7f809edd27dfdff08e176a4a4a3f25e7e7ad63d3398e.
//
// Solidity: event AddCreateVMInfoEvent(string taskId, address owner, string callerIp, string cpuModel, uint64 cpuNum, uint64 cpuCores, string gpuModel, uint64 gpuNum, uint64 memNum, string os)
func (_VmCreate *VmCreateFilterer) WatchAddCreateVMInfoEvent(opts *bind.WatchOpts, sink chan<- *VmCreateAddCreateVMInfoEvent) (event.Subscription, error) {

	logs, sub, err := _VmCreate.contract.WatchLogs(opts, "AddCreateVMInfoEvent")
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(VmCreateAddCreateVMInfoEvent)
				if err := _VmCreate.contract.UnpackLog(event, "AddCreateVMInfoEvent", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseAddCreateVMInfoEvent is a log parse operation binding the contract event 0x7d25d4d054c4e119d70f7f809edd27dfdff08e176a4a4a3f25e7e7ad63d3398e.
//
// Solidity: event AddCreateVMInfoEvent(string taskId, address owner, string callerIp, string cpuModel, uint64 cpuNum, uint64 cpuCores, string gpuModel, uint64 gpuNum, uint64 memNum, string os)
func (_VmCreate *VmCreateFilterer) ParseAddCreateVMInfoEvent(log types.Log) (*VmCreateAddCreateVMInfoEvent, error) {
	event := new(VmCreateAddCreateVMInfoEvent)
	if err := _VmCreate.contract.UnpackLog(event, "AddCreateVMInfoEvent", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// VmCreateOwnershipTransferredIterator is returned from FilterOwnershipTransferred and is used to iterate over the raw logs and unpacked data for OwnershipTransferred events raised by the VmCreate contract.
type VmCreateOwnershipTransferredIterator struct {
	Event *VmCreateOwnershipTransferred // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *VmCreateOwnershipTransferredIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(VmCreateOwnershipTransferred)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(VmCreateOwnershipTransferred)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *VmCreateOwnershipTransferredIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *VmCreateOwnershipTransferredIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// VmCreateOwnershipTransferred represents a OwnershipTransferred event raised by the VmCreate contract.
type VmCreateOwnershipTransferred struct {
	PreviousOwner common.Address
	NewOwner      common.Address
	Raw           types.Log // Blockchain specific contextual infos
}

// FilterOwnershipTransferred is a free log retrieval operation binding the contract event 0x8be0079c531659141344cd1fd0a4f28419497f9722a3daafe3b4186f6b6457e0.
//
// Solidity: event OwnershipTransferred(address indexed previousOwner, address indexed newOwner)
func (_VmCreate *VmCreateFilterer) FilterOwnershipTransferred(opts *bind.FilterOpts, previousOwner []common.Address, newOwner []common.Address) (*VmCreateOwnershipTransferredIterator, error) {

	var previousOwnerRule []interface{}
	for _, previousOwnerItem := range previousOwner {
		previousOwnerRule = append(previousOwnerRule, previousOwnerItem)
	}
	var newOwnerRule []interface{}
	for _, newOwnerItem := range newOwner {
		newOwnerRule = append(newOwnerRule, newOwnerItem)
	}

	logs, sub, err := _VmCreate.contract.FilterLogs(opts, "OwnershipTransferred", previousOwnerRule, newOwnerRule)
	if err != nil {
		return nil, err
	}
	return &VmCreateOwnershipTransferredIterator{contract: _VmCreate.contract, event: "OwnershipTransferred", logs: logs, sub: sub}, nil
}

// WatchOwnershipTransferred is a free log subscription operation binding the contract event 0x8be0079c531659141344cd1fd0a4f28419497f9722a3daafe3b4186f6b6457e0.
//
// Solidity: event OwnershipTransferred(address indexed previousOwner, address indexed newOwner)
func (_VmCreate *VmCreateFilterer) WatchOwnershipTransferred(opts *bind.WatchOpts, sink chan<- *VmCreateOwnershipTransferred, previousOwner []common.Address, newOwner []common.Address) (event.Subscription, error) {

	var previousOwnerRule []interface{}
	for _, previousOwnerItem := range previousOwner {
		previousOwnerRule = append(previousOwnerRule, previousOwnerItem)
	}
	var newOwnerRule []interface{}
	for _, newOwnerItem := range newOwner {
		newOwnerRule = append(newOwnerRule, newOwnerItem)
	}

	logs, sub, err := _VmCreate.contract.WatchLogs(opts, "OwnershipTransferred", previousOwnerRule, newOwnerRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(VmCreateOwnershipTransferred)
				if err := _VmCreate.contract.UnpackLog(event, "OwnershipTransferred", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseOwnershipTransferred is a log parse operation binding the contract event 0x8be0079c531659141344cd1fd0a4f28419497f9722a3daafe3b4186f6b6457e0.
//
// Solidity: event OwnershipTransferred(address indexed previousOwner, address indexed newOwner)
func (_VmCreate *VmCreateFilterer) ParseOwnershipTransferred(log types.Log) (*VmCreateOwnershipTransferred, error) {
	event := new(VmCreateOwnershipTransferred)
	if err := _VmCreate.contract.UnpackLog(event, "OwnershipTransferred", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// VmCreateSnatchTaskEventIterator is returned from FilterSnatchTaskEvent and is used to iterate over the raw logs and unpacked data for SnatchTaskEvent events raised by the VmCreate contract.
type VmCreateSnatchTaskEventIterator struct {
	Event *VmCreateSnatchTaskEvent // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *VmCreateSnatchTaskEventIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(VmCreateSnatchTaskEvent)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(VmCreateSnatchTaskEvent)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *VmCreateSnatchTaskEventIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *VmCreateSnatchTaskEventIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// VmCreateSnatchTaskEvent represents a SnatchTaskEvent event raised by the VmCreate contract.
type VmCreateSnatchTaskEvent struct {
	TaskId   string
	Creater  common.Address
	Snatcher common.Address
	Raw      types.Log // Blockchain specific contextual infos
}

// FilterSnatchTaskEvent is a free log retrieval operation binding the contract event 0x269704899edcfe419dffb9b9581ba9dc9388ff0cffe1cd177f9fd18ab81590b0.
//
// Solidity: event SnatchTaskEvent(string taskId, address creater, address snatcher)
func (_VmCreate *VmCreateFilterer) FilterSnatchTaskEvent(opts *bind.FilterOpts) (*VmCreateSnatchTaskEventIterator, error) {

	logs, sub, err := _VmCreate.contract.FilterLogs(opts, "SnatchTaskEvent")
	if err != nil {
		return nil, err
	}
	return &VmCreateSnatchTaskEventIterator{contract: _VmCreate.contract, event: "SnatchTaskEvent", logs: logs, sub: sub}, nil
}

// WatchSnatchTaskEvent is a free log subscription operation binding the contract event 0x269704899edcfe419dffb9b9581ba9dc9388ff0cffe1cd177f9fd18ab81590b0.
//
// Solidity: event SnatchTaskEvent(string taskId, address creater, address snatcher)
func (_VmCreate *VmCreateFilterer) WatchSnatchTaskEvent(opts *bind.WatchOpts, sink chan<- *VmCreateSnatchTaskEvent) (event.Subscription, error) {

	logs, sub, err := _VmCreate.contract.WatchLogs(opts, "SnatchTaskEvent")
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(VmCreateSnatchTaskEvent)
				if err := _VmCreate.contract.UnpackLog(event, "SnatchTaskEvent", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseSnatchTaskEvent is a log parse operation binding the contract event 0x269704899edcfe419dffb9b9581ba9dc9388ff0cffe1cd177f9fd18ab81590b0.
//
// Solidity: event SnatchTaskEvent(string taskId, address creater, address snatcher)
func (_VmCreate *VmCreateFilterer) ParseSnatchTaskEvent(log types.Log) (*VmCreateSnatchTaskEvent, error) {
	event := new(VmCreateSnatchTaskEvent)
	if err := _VmCreate.contract.UnpackLog(event, "SnatchTaskEvent", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}
