package models

import "math/big"

type VmStatusRep struct {
	Status string `json:"status"`
}

type ResponseArr struct {
	Data []interface{} `json:"data"`
}

type Response struct {
	Data map[string]interface{} `json:"data"`
}

type ResponseStr struct {
	Data string `json:"data"`
}

type QemuList struct {
	Cpus     int64    `json:"cpus"`
	VmId     int64    `json:"vmid"`
	Pid      int64    `json:"pid"`
	MaxMem   *big.Int `json:"maxMem"`
	Template int64    `json:"template"`
}

type NetWorkResult struct {
	Result []*NetworkInfo `json:"result"`
}

type NetworkInfo struct {
	IpAddresses []IpInfo `json:"ip-addresses"`
	Name        string   `json:"name"`
}

type IpInfo struct {
	IpAddress     string `json:"ip-address"`
	Prefix        int    `json:"prefix"`
	IpAddressType string `json:"ip-address-type"`
}
