package controllers

import (
	"crypto/ecdsa"
	"encoding/json"
	"github.com/astaxie/beego"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/common/hexutil"
	"github.com/ethereum/go-ethereum/crypto"
	"time"
	"token-uri/models"
)

type LLMController struct {
	BaseController
}

func (c *LLMController) GetContainerSign() {
	signData := &models.TaskInfo{}
	reqData := c.Ctx.Input.RequestBody
	err := json.Unmarshal(reqData, signData)
	if err != nil {
		c.ResponseInfo(500, "sign failed", nil)
		return
	}
	signPrv := beego.AppConfig.String("sign_prv")
	bridgePrv := stringToPrivateKey(signPrv)
	hashData, _ := json.Marshal(signData)
	hash := crypto.Keccak256Hash(hashData)
	signature, _ := crypto.Sign(hash.Bytes(), bridgePrv)
	signHex := common.Bytes2Hex(signature)
	c.ResponseInfo(200, "sign successful", signHex)
}

func (c *LLMController) GetExecRes() {
	time.Sleep(time.Second * 5)
	c.ResponseInfo(200, "OK", "Task successfully")
}

func stringToPrivateKey(privateKeyStr string) *ecdsa.PrivateKey {
	privateKeyByte, err := hexutil.Decode(privateKeyStr)
	if err != nil {
		return nil
	}
	privateKey, err := crypto.ToECDSA(privateKeyByte)
	if err != nil {
		return nil
	}
	return privateKey

}
