package models

import (
	"github.com/ethereum/go-ethereum/common"
	"math/big"
)

type LotteryPeriodListRes struct {
	PoolAddr    string   `json:"poolAddr"`
	TokenIdList []string `json:"tokenIdList"`
}

type LotteryUserList struct {
	UserAddr string `json:"userAddr"`
	Value    string `json:"value"`
	Hash     string `json:"hash"`
}

type LotteryHashLastSix struct {
	Hash   string `json:"hash"`
	SortBy string `json:"sortBy"`
}

type FilterRes struct {
	Code int         `json:"code"`
	Msg  interface{} `json:"msg"`
	Data interface{} `json:"data"`
}

type PoolInfoRes struct {
	Started_     []bool           `abi:"started_" json:"started_"`
	NftAddrs_    []common.Address `abi:"nftAddrs_" json:"nftAddrs_"`
	NftInfo_     [][]string       `abi:"nftInfo_" json:"nftInfo_"`
	PoolInfo_    [][]*big.Int     `abi:"poolInfo_" json:"poolInfo_"`
	PoolHistory_ [][]*big.Int     `abi:"poolHistory_"  json:"poolHistory_"`
}

type WinnerListRes struct {
	PoolAddr  string     `json:"poolAddr"`
	PeriodArr [][]int64  `json:"periodArr"`
	WinnerArr [][]string `json:"winnerArr"`
	TxHashArr [][]string `json:"txHashArr"`
	SignArr   [][]string `json:"signArr"`
}
