package sync

import (
	"bufio"
	"github.com/astaxie/beego"
	"github.com/astaxie/beego/logs"
	"github.com/astaxie/beego/orm"
	"github.com/ethereum/go-ethereum/accounts/abi"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/crypto"
	log "github.com/sirupsen/logrus"
	"github.com/wuban/nft-event/models"
	"github.com/wuban/nft-event/utils"
	"math/big"
	"os"
	"strconv"
)

// LotteryTopic ERC721 transfer event topic
var LotteryTopic = crypto.Keccak256Hash([]byte("Lottery(address,uint256,uint256,address,uint256)")).Hex()

func LotteryContractHandler(vLog types.Log) error {
	contractAddr := beego.AppConfig.String("lotteryContract")
	logs.Info("handler lottery contract logs")
	file, err := os.Open("./sync/Lottery_Event.json")
	if err != nil {
		panic(err)
	}
	defer func(file *os.File) {
		err := file.Close()
		if err != nil {
			log.Error("read file close failed:", err)
		}
	}(file)
	lotteryAbiInfo, _ := abi.JSON(bufio.NewReader(file))
	log.Info("LotteryTopic:", LotteryTopic)
	{
		txHash := vLog.TxHash.Hex()
		method := vLog.Topics[0]
		switch method.String() {
		case LotteryTopic:
			rp, err := lotteryAbiInfo.Unpack("Lottery", vLog.Data)
			period, err := utils.HexToInt64(vLog.Topics[2].Hex())
			if err != nil {
				log.Error("HexToInt64 error:", err.Error())
				return err
			}
			userAddr := rp[0].(common.Address).Hex()
			value := rp[1].(*big.Int)
			log.Info("value:", value.String())
			tokenId, _ := utils.HexToInt64(vLog.Topics[3].Hex())
			lottery := &models.Lottery{
				ContractAddr: contractAddr,
				PoolAddr:     utils.HexToAddr(vLog.Topics[1].Hex()).String(),
				Period:       period,
				User:         userAddr,
				Value:        value.String(),
				TokenId:      strconv.FormatInt(tokenId, 10),
				Hash:         txHash,
				SortBy:       txHash[len(txHash)-6:],
			}
			o := orm.NewOrm()
			exist := o.QueryTable("lottery").Filter("hash", lottery.Hash).Exist()
			if exist {
				break
			}
			log.Info("Insert data lottery:", lottery)
			_, err = o.Insert(lottery)
			if err != nil {
				logs.Error("Insert lottery error:", err.Error())
				return err
			}
		}
	}
	return nil
}
