package sync

import (
	"bufio"
	"github.com/astaxie/beego/logs"
	"github.com/astaxie/beego/orm"
	"github.com/ethereum/go-ethereum/accounts/abi"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/crypto"
	log "github.com/sirupsen/logrus"
	"github.com/wuban/nft-event/models"
	"github.com/wuban/nft-event/utils"
	"math/big"
	"os"
)

// LotteryTopic ERC721 transfer event topic
var LotteryTopic = crypto.Keccak256Hash([]byte("Lottery(address,uint256,address,uint256)")).Hex()

func LotteryContractHandler(vLog types.Log) error {
	logs.Info("handler lottery contract logs")
	file, err := os.Open("./sync/Lottery_Event.json")
	if err != nil {
		panic(err)
	}
	defer func(file *os.File) {
		err := file.Close()
		if err != nil {
			log.Error("read file close failed:", err)
		}
	}(file)
	lotteryAbiInfo, _ := abi.JSON(bufio.NewReader(file))
	log.Info("LotteryTopic:", LotteryTopic)
	{
		txHash := vLog.TxHash.Hex()
		method := vLog.Topics[0]
		switch method.String() {
		case LotteryTopic:
			rp, err := lotteryAbiInfo.Unpack("Lottery", vLog.Data)
			period, err := utils.HexToInt64(vLog.Topics[2].Hex())
			if err != nil {
				log.Error("HexToInt64 error:", err.Error())
				return err
			}
			value := rp[0].(*big.Int)
			log.Info("value:", value.String())
			lottery := &models.Lottery{
				PoolAddr: utils.HexToAddr(vLog.Topics[1].Hex()).String(),
				Period:   period,
				User:     utils.HexToAddr(vLog.Topics[3].Hex()).String(),
				Value:    value.String(),
				Hash:     txHash,
				SortBy:   txHash[len(txHash)-6:],
			}
			log.Info("Insert data lottery:", lottery)
			o := orm.NewOrm()
			//lotteryVar := &models.Lottery{}
			// todo 是否需要过滤每个用户只能参加一次抽奖的日志
			//o.QueryTable("lottery").Filter("pool_addr", lottery.PoolAddr).Filter("period", lottery.Period).Filter("User", lottery.User).All(lotteryVar)
			//if lotteryVar.PoolAddr != "" {
			//	log.Warning("The lottery is exist", lotteryVar)
			//	return nil
			//}
			_, err = o.Insert(lottery)
			if err != nil {
				logs.Error("Insert lottery error:", err.Error())
				return err
			}
		}
	}
	return nil
}
