package routers

import (
	"github.com/astaxie/beego"
	"github.com/wuban/nft-event/controllers"
)

func init() {
	beego.Router("/api/v1/event/get/tokenIdList", &controllers.LotteryController{}, "get:GetTokenIdList")
	beego.Router("/api/v1/event/get/joinUserList", &controllers.LotteryController{}, "get:GetUserList")
	beego.Router("/api/v1/event/get/sortCondition", &controllers.LotteryController{}, "get:GetHashSortByCondition")
	beego.Router("/api/v1/event/get/param", &controllers.LotteryController{}, "get:ForwardReq")
	beego.Router("/getToken", &controllers.AuthController{}, "get:GetToken")
	// 添加鉴权过滤器
	//beego.InsertFilter("/*", beego.BeforeRouter, utils.AuthFilter)
}
