package utils

import (
	"encoding/hex"
	"fmt"
	"github.com/astaxie/beego"
	"github.com/dgrijalva/jwt-go"
	"github.com/ethereum/go-ethereum/common"
	log "github.com/sirupsen/logrus"
)

func IsAddress(val string) bool {
	return common.IsHexAddress(val)
}

func HexToAddr(val string) common.Address {
	return common.HexToAddress(val)
}

func HexToInt64(hexStr string) (int64, error) {
	// 去除十六进制字符串的前缀 "0x"
	if len(hexStr) > 2 && hexStr[0:2] == "0x" {
		hexStr = hexStr[2:]
	}

	// 解码十六进制字符串
	bytes, err := hex.DecodeString(hexStr)
	if err != nil {
		return 0, err
	}

	// 将解码后的字节切片转换为 int64 类型
	value := int64(0)
	for _, b := range bytes {
		value = (value << 8) | int64(b)
	}

	return value, nil
}

func CheckToken(tokenString string) bool {
	token, _ := jwt.Parse(tokenString, func(token *jwt.Token) (interface{}, error) {
		if _, ok := token.Method.(*jwt.SigningMethodHMAC); !ok {
			return nil, fmt.Errorf("UnExpected signing method")
		}
		return []byte(beego.AppConfig.String("secret")), nil
	})
	if token == nil {
		return false
	}
	claims, _ := token.Claims.(jwt.MapClaims)
	log.Info("claims:", claims)
	return true
}
