package main

import (
	"fmt"
	"github.com/hyperledger/fabric/core/chaincode/shim"
	"testing"
)

func TestGXHCC(t *testing.T) {
	cc := new(GXHCC)
	stub := shim.NewMockStub("GXHCC",cc)
	response:= stub.MockInit("init",nil)
	fmt.Println(string(response.Payload))
	input := `{"aname":"alibusi","aname":"alibus","atype":"type","alinkman":"","aader":"aader","amob":"1234567890","backup":{"id":"1","aname":"alibusi","atype":"type","alinkman":"","aader":"aader","amob":"1234567890"}}`
	responseByPut := stub.MockInvoke("invoke1",[][]byte{[]byte("put"), []byte("alibusi"),[]byte(input)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPut.Status,responseByPut.Message,string(responseByPut.Payload))
	responseByget := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(input)})
	fmt.Printf("Invoke status %d,message %s and payload %s \n",responseByget.Status,responseByget.Message,string(responseByget.Payload))
	return
	input2 := `{"id":"1","aname":"aaa","atype":"aaa","alinkman":"cc","aader":"aader","amob":"1234567890","backup":{"id":"1","aname":"alibusi","atype":"type","alinkman":"aaa","aader":"aader","amob":"1234567890"}}`
	responseByPut2 := stub.MockInvoke("invoke1",[][]byte{[]byte("put"), []byte("alibusi"),[]byte(input2)})
	fmt.Printf("Invoke22 status %d,message %s and payload %s\n",responseByPut2.Status,responseByPut2.Message,string(responseByPut2.Payload))
	responseByget2 := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(`{"id":"1"}`)})
	fmt.Printf("Invoke22 status %d,message %s and payload %s",responseByget2.Status,responseByget2.Message,string(responseByget2.Payload))
}

func TestGXHSchema(t *testing.T){

	input := `{"id":"1","aname":"alibusi","aname":"alibus","atype":"type","alinkman":"","aader":"aader",
"amob":"1234567890","backup":{"id":"1","aname":"alibusi","atype":"type","alinkman":"",
"aader":"aader","amob":"1234567890"}}`

	inputarrary := `[{"id":"1","aname":"alibusi","atype":"type","alinkman":"",
"aader":"aader","amob":"1234567890","backup":{"id":"1","aname":"alibusi","atype":"type",
"alinkman":"","aader":"aader","amob":"1234567890"}},{"id":"2","aname":"alibusi","atype":"type",
"alinkman":"","aader":"aader","amob":"1234567890","backup":{"id":"1","aname":"alibusi","atype":"type",
"alinkman":"","aader":"aader","amob":"1234567890"}}]`

	update := `{"alinkman":"张三","id":"1","backup":{}}`
	cc := new(GXHCC)
	stub := shim.NewMockStub("GXHCC",cc)
	response:= stub.MockInit("init",nil)
	fmt.Println("MockInit Payload: ",string(response.Payload))

	fmt.Println()
	fmt.Println("========================================invoke schema put============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("put"),[]byte("alibusi"),[]byte(input)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",
		responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))

	responseByGet := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("get"),[]byte("alibusi")})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",
		responseByGet.Status,responseByGet.Message,string(responseByGet.Payload))
	fmt.Println()
	fmt.Println("========================================invoke data put============================================")
	fmt.Println()
	fmt.Println()

	responseByPut := stub.MockInvoke("invoke1",[][]byte{[]byte("put"), []byte("alibusi"),[]byte(inputarrary)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s\n",
		responseByPut.Status,responseByPut.Message,string(responseByPut.Payload))

	responseByget := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(`{"id":"1"}`)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget.Status,responseByget.Message,string(responseByget.Payload))


	fmt.Println()
	fmt.Println("========================================invoke data update============================================")
	fmt.Println()
	fmt.Println()

	responseByUpdate := stub.MockInvoke("invoke1",[][]byte{[]byte("update"), []byte("alibusi"),[]byte(update)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s\n",
		responseByUpdate.Status,responseByUpdate.Message,string(responseByUpdate.Payload))

	responseByget2 := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(`{"id":"1"}`)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget2.Status,responseByget2.Message,string(responseByget2.Payload))

	//inputfail := `{"id":"2","atype":"type","alinkman":"","aader":"aader","amob":"1234567890","backup":{"id":"1","aname":"alibusi","atype":"type","alinkman":"","aader":"aader","amob":"1234567890"}}`
	//fmt.Println()
	//fmt.Println("========================================fail input data============================================")
	//
	//
	//responseByPutfail := stub.MockInvoke("invoke1",[][]byte{[]byte("put"), []byte("alibusi"),[]byte(inputfail)})
	//fmt.Printf("Invoke status %d,message %s and payload %s\n",
	//	responseByPutfail.Status,responseByPutfail.Message,string(responseByPutfail.Payload))
	//responseBygetfail := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(`{"id":"1"}`)})
	//fmt.Printf("Invoke status %d,message %s and payload %s \n",
	//	responseBygetfail.Status,responseBygetfail.Message,string(responseBygetfail.Payload))
}


func TestGXH(t *testing.T){
	cc := new(GXHCC)
	stub := shim.NewMockStub("GXHCC",cc)
	stub.MockInit("init",nil)
	stub.MockInvoke("invoke1",[][]byte{[]byte("cert")})
}