package main

import (
	"fmt"
	"github.com/hyperledger/fabric/core/chaincode/shim"
	"testing"
)


var schema = `{"Parameters":{"Alinkman":{"Value":"Alinkman","Read":"","Write":""},"Amob":{"Value":"Amob","Read":"","Write":""},
"Aname":{"Value":"Aname","Read":"","Write":""},"Atype":{"Value":"Atype","Read":"","Write":""},"Backup":{"Value":[{"Value":"1",
"Read":"","Write":""},{"Value":"Aname","Read":"","Write":""},{"Value":"Atype","Read":"","Write":""},{"Value":"Alinkman","Read":"","Write":""}],
"Read":"","Write":""},"id":{"Value":"1","Read":"","Write":""}},"Read":"","Write":"","ParametersRead":true,"ParametersWrite":true}`

func TestGXHCC(t *testing.T) {
	cc := new(GXHCC)
	stub := shim.NewMockStub("GXHCC",cc)
	response:= stub.MockInit("init",nil)
	fmt.Println(string(response.Payload))
	input := `{"aname":"alibusi","aname":"alibus","atype":"type","alinkman":"","aader":"aader","amob":"1234567890","backup":{"id":"1","aname":"alibusi","atype":"type","alinkman":"","aader":"aader","amob":"1234567890"}}`
	responseByPut := stub.MockInvoke("invoke1",[][]byte{[]byte("put"), []byte("alibusi"),[]byte(input)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPut.Status,responseByPut.Message,string(responseByPut.Payload))
	responseByget := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(input)})
	fmt.Printf("Invoke status %d,message %s and payload %s \n",responseByget.Status,responseByget.Message,string(responseByget.Payload))
	return
	input2 := `{"id":"1","aname":"aaa","atype":"aaa","alinkman":"cc","aader":"aader","amob":"1234567890","backup":{"id":"1","aname":"alibusi","atype":"type","alinkman":"aaa","aader":"aader","amob":"1234567890"}}`
	responseByPut2 := stub.MockInvoke("invoke1",[][]byte{[]byte("put"), []byte("alibusi"),[]byte(input2)})
	fmt.Printf("Invoke22 status %d,message %s and payload %s\n",responseByPut2.Status,responseByPut2.Message,string(responseByPut2.Payload))
	responseByget2 := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(`{"id":"1"}`)})
	fmt.Printf("Invoke22 status %d,message %s and payload %s",responseByget2.Status,responseByget2.Message,string(responseByget2.Payload))
}


func TestGXHSchema(t *testing.T){

	input := `{"id":"1","aname":"alibusi","aname":"alibus","atype":"type","alinkman":"","aader":"aader",
"amob":"1234567890","backup":{"id":"1","aname":"alibusi","atype":"type","alinkman":"",
"aader":"aader","amob":"1234567890"}}`

	inputarrary := `[{"id":"1","aname":"alibusi","atype":"type","alinkman":"",
"aader":"aader","amob":"1234567890","backup":{"id":"1","aname":"alibusi","atype":"type",
"alinkman":"","aader":"aader","amob":"1234567890"}},{"id":"2","aname":"alibusi","atype":"type",
"alinkman":"","aader":"aader","amob":"1234567890","backup":{"id":"1","aname":"alibusi","atype":"type",
"alinkman":"","aader":"aader","amob":"1234567890"}}]`

	update := `{"alinkman":"张三","id":"1","backup":{}}`
	cc := new(GXHCC)
	stub := shim.NewMockStub("GXHCC",cc)
	response:= stub.MockInit("init",nil)
	fmt.Println("MockInit Payload: ",string(response.Payload))

	fmt.Println()
	fmt.Println("========================================invoke schema put============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("put"),[]byte("alibusi"),[]byte(input)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",
		responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))

	responseByGet := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("get"),[]byte("alibusi")})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",
		responseByGet.Status,responseByGet.Message,string(responseByGet.Payload))
	fmt.Println()
	fmt.Println("========================================invoke data put============================================")
	fmt.Println()
	fmt.Println()

	responseByPut := stub.MockInvoke("invoke1",[][]byte{[]byte("put"), []byte("alibusi"),[]byte(inputarrary)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s\n",
		responseByPut.Status,responseByPut.Message,string(responseByPut.Payload))

	responseByget := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(`{"id":"1"}`)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget.Status,responseByget.Message,string(responseByget.Payload))


	fmt.Println()
	fmt.Println("========================================invoke data update============================================")
	fmt.Println()
	fmt.Println()

	responseByUpdate := stub.MockInvoke("invoke1",[][]byte{[]byte("update"), []byte("alibusi"),[]byte(update)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s\n",
		responseByUpdate.Status,responseByUpdate.Message,string(responseByUpdate.Payload))

	responseByget2 := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(`{"id":"1"}`)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget2.Status,responseByget2.Message,string(responseByget2.Payload))

	//inputfail := `{"id":"2","atype":"type","alinkman":"","aader":"aader","amob":"1234567890","backup":{"id":"1","aname":"alibusi","atype":"type","alinkman":"","aader":"aader","amob":"1234567890"}}`
	//fmt.Println()
	//fmt.Println("========================================fail input data============================================")
	//
	//
	//responseByPutfail := stub.MockInvoke("invoke1",[][]byte{[]byte("put"), []byte("alibusi"),[]byte(inputfail)})
	//fmt.Printf("Invoke status %d,message %s and payload %s\n",
	//	responseByPutfail.Status,responseByPutfail.Message,string(responseByPutfail.Payload))
	//responseBygetfail := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(`{"id":"1"}`)})
	//fmt.Printf("Invoke status %d,message %s and payload %s \n",
	//	responseBygetfail.Status,responseBygetfail.Message,string(responseBygetfail.Payload))
}

/*
	以下部分是增加权限内容的测试
*/

var (
	authInput = `{"Parameters":{"alinkman":{"Value":"Alinkman","Read":["user"],"Write":["admin"]},"amob":{"Value":"Amob","Read":[],"Write":[]},"aname":
{"Value":"Aname","Read":["admin"],"Write":["admin"]},"atype":{"Value":"Atype","Read":["admin"],"Write":["admin"]},"backup":{"Value":{"aname":
{"Value":"Aname","Read":["admin"],"Write":["admin"]},"atype":{"Value":"Atype","Read":["admin"],"Write":["admin"]}},"Read":["admin"],"Write":["admin"]},
"id":{"Value":"1","Read":[],"Write":[]}},"Read":[],"Write":["user"]}

`

	inputUpdate = `{"id":"1","aname":"alibusi","atype":"newtype","alinkman":"newalinkman",
"amob":"new1234567890","backup":{"aname":"alibusi","atype":"type"}}`

	inputarrary = `[{"id":"1","aname":"alibusi","atype":"type","alinkman":"alinkman",
"amob":"1234567890","backup":{"aname":"alibusi","atype":"type"}},{"id":"2","aname":"alibusi","atype":"type","alinkman":"alinkman",
"amob":"1234567890","backup":{"aname":"alibusi","atype":"type"}}]`
)
func TestGXHSchemaAuth(t *testing.T){
	cc := new(GXHCC)
	stub := shim.NewMockStub("GXHCC",cc)
	stub.MockInit("init",nil)
	fmt.Println()
	fmt.Println("========================================invoke schema put============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("put"),[]byte("alibusi"),[]byte(authInput)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",
		responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	responseByget := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("get"),[]byte("alibusi")})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget.Status,responseByget.Message,string(responseByget.Payload))
}


func TestGXHDataPutAuth(t *testing.T){
	cc := new(GXHCC)
	stub := shim.NewMockStub("GXHCC",cc)
	stub.MockInit("init",nil)
	fmt.Println()
	fmt.Println("========================================invoke schema put============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("put"),[]byte("alibusi"),[]byte(authInput)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",
		responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	responseByget := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("get"),[]byte("alibusi")})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget.Status,responseByget.Message,string(responseByget.Payload))
	fmt.Println()
	fmt.Println("========================================invoke data put============================================")
	fmt.Println()
	fmt.Println()
	responseByPut := stub.MockInvoke("invoke1",[][]byte{[]byte("put"), []byte("alibusi"),[]byte(inputarrary)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s\n",
		responseByPut.Status,responseByPut.Message,string(responseByPut.Payload))

	responseByget = stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(`{"id":"1"}`)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget.Status,responseByget.Message,string(responseByget.Payload))
	fmt.Println()
	fmt.Println("========================================invoke data update============================================")
	fmt.Println()
	fmt.Println()
	responseByUpdate := stub.MockInvoke("invoke1",[][]byte{[]byte("update"), []byte("alibusi"),[]byte(inputUpdate)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s\n",
		responseByUpdate.Status,responseByUpdate.Message,string(responseByUpdate.Payload))

	responseByget2 := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(`{"id":"1"}`)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget2.Status,responseByget2.Message,string(responseByget2.Payload))
}