package main

import (
	"encoding/json"
	"fmt"
	"github.com/hyperledger/fabric/core/chaincode/shim"
)

/*
	put
	args 字段说明：
	1：args[0]代表我们具体操作的表，
    2：args[1:]后面的数据表示要记录到数据库的数据,每一个string 必须是json字符串，并且需要每一个json 字符串都必须包含id 字段

*/
func put(args []string, stub shim.ChaincodeStubInterface) (string, error) {
	if len(args) < 2 {
		return "", fmt.Errorf("Expected  more than 2 parameters to function put!")
	}
	var mapResult map[string]interface{}
	var schemaMap map[string]interface{}
	schema := &Schema{}
	result, err := schema.get(args[0], stub)
	if err != nil {
		return "", err
	}
	json.Unmarshal([]byte(result),&schemaMap)

	for k, v := range args[1:] {
		if err := json.Unmarshal([]byte(v), &mapResult); err != nil {
			return "", fmt.Errorf("parameters Unmarshal fail,args index %d string not json string, err:%s", k, err)
		}
		Id ,ok:= mapResult["id"]
		if !ok{
			return "", fmt.Errorf("The id field must exist ")
		}
		if result,err := stub.GetState(args[0]+Id.(string));err!=nil{
			return "", fmt.Errorf("get %s data happen err: ", args[0]+Id.(string))
		}else if result!=nil{
			return "", fmt.Errorf("%s data already exist", args[0]+Id.(string))
		}
		if !SchemaCheck(schemaMap,mapResult){
			return "", fmt.Errorf("SchemaCheck fail,args index %d string doesn't match %s format", k,args[0])
		}
		putDate,_:=json.Marshal(mapResult)
		if err := stub.PutState(args[0]+Id.(string), putDate); err != nil {
			return "", fmt.Errorf("PutState fail, err :%s", err)
		}

	}
	return fmt.Sprintf("%s put data success!", args[0]), nil
}

/*
	修改一个表的一条数据的一个或者多个字段值
*/
func update(args []string, stub shim.ChaincodeStubInterface) (string, error) {
	if len(args) != 2 {
		return "", fmt.Errorf("Expected 2 parameters to function put! ")
	}
	var mapResult map[string]interface{}
	var allMap map[string]interface{}
	if err := json.Unmarshal([]byte(args[1]), &mapResult); err != nil  {
		return "", fmt.Errorf("parameters Unmarshal fail,args index %d string not json string,err: ", err)
	}

	Id ,ok:= mapResult["id"]
	if !ok{
		return "", fmt.Errorf("The id field must exist ")
	}
	result, err := stub.GetState(args[0] + Id.(string))
	if err != nil || result == nil {
		return "", fmt.Errorf("GetState data fail,please check your parameters ")
	}
	if err := json.Unmarshal(result, &allMap); err != nil {
		return "", fmt.Errorf("result parameters Unmarshal fail err:%s ", err)
	}
	if err := Deassign(mapResult, allMap); err != nil {
		return "", err
	} else {
		resultByte, _:= json.Marshal(mapResult)
		if err := stub.PutState(args[0]+Id.(string), resultByte);err!=nil{
			return "", fmt.Errorf("updateState date fail, err :%s ", err)
		}
		return fmt.Sprintf("%s update data success!", args[0]), nil
	}

}

func get(args []string, stub shim.ChaincodeStubInterface) (string, error) {
	if len(args) != 2 {
		return "", fmt.Errorf("Expected  2 parameters to function put!")
	}
	var mapResult map[string]interface{}
	if err := json.Unmarshal([]byte(args[1]), &mapResult); err != nil {
		return "", fmt.Errorf("parameters Unmarshal fail,args index string not json string,err: %s", err)
	}

	Id := mapResult["id"]
	Id ,ok:= mapResult["id"]
	if !ok{
		return "", fmt.Errorf("The id field must exist ")
	}
	result, err := stub.GetState(args[0] + Id.(string))
	if err != nil || result == nil {
		return "", fmt.Errorf("GetState data fail,please check your parameters ")
	}
	return string(result), nil
}

/*
	重新赋值，并检查相应的格式是否正确
*/
func Deassign(upMap ,result map[string]interface{}) error {
	if len(upMap) > len(result){
		return fmt.Errorf("Deassign fail,paramters format  doesn't match! ",)
	}
	for k, v := range upMap {
		if resultV,ok := result[k];ok{
			resultMap, resultok := resultV.(map[string]interface{})
			if vMap, ok := v.(map[string]interface{});ok {
				if resultok{
					Deassign(vMap,resultMap)
				}else{
					return fmt.Errorf("Deassign fail, format doesn't match! ")
				}
			}else if !resultok{
				result[k] = v
			}
		}else{
			return fmt.Errorf("Deassign fail %s key nonentity ",k)
		}
	}
	return nil
}


func SchemaCheck(schema, checkmap map[string]interface{}) bool {
	if len(schema) != len(checkmap) {
		return false
	}
	for k, v := range checkmap {
		if schemaV, ok := schema[k]; !ok {
			return false
		} else {
			if parameterS, ok := schemaV.(map[string]interface{}); ok {
				if parameterC, ok := v.(map[string]interface{}); !ok {
					return false
				} else {
					if !SchemaCheck(parameterS, parameterC) {
						return false
					}
				}
			}
		}

	}
	return true
}
